/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RegistryElementDescriptor;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.InvalidGridGeometryException;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.coverage.processing.CannotReprojectException;
import org.geotoolkit.coverage.processing.CoverageProcessingException;
import org.geotoolkit.coverage.processing.Operation2D;
import org.geotoolkit.factory.FactoryFinder;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.image.jai.Registry;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.parameter.ImagingParameterDescriptors;
import org.geotoolkit.parameter.ImagingParameters;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.transform.DimensionFilter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

@Immutable
@Deprecated
public class OperationJAI
extends Operation2D {
    private static final long serialVersionUID = -5974520239347639965L;
    protected static final String RENDERED_MODE = "rendered";
    protected final OperationDescriptor operation;

    public OperationJAI(String string) throws OperationNotFoundException {
        this(OperationJAI.getOperationDescriptor(string));
    }

    public OperationJAI(OperationDescriptor operationDescriptor) {
        this(operationDescriptor, (ParameterDescriptorGroup)new ImagingParameterDescriptors((RegistryElementDescriptor)operationDescriptor));
    }

    protected OperationJAI(OperationDescriptor operationDescriptor, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
        this.operation = operationDescriptor;
        ArgumentChecks.ensureNonNull((String)"operation", (Object)operationDescriptor);
        OperationJAI.ensureRenderedImage(operationDescriptor.getDestClass(RENDERED_MODE));
        Class[] classArray = operationDescriptor.getSourceClasses(RENDERED_MODE);
        if (classArray != null) {
            int n = classArray.length;
            assert (n == operationDescriptor.getNumSources());
            for (int i = 0; i < n; ++i) {
                OperationJAI.ensureRenderedImage(classArray[i]);
            }
        }
        assert (super.getNumSources() == operationDescriptor.getNumSources());
    }

    protected static OperationDescriptor getOperationDescriptor(String string) throws OperationNotFoundException {
        OperationRegistry operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        OperationDescriptor operationDescriptor = (OperationDescriptor)operationRegistry.getDescriptor(RENDERED_MODE, string);
        if (operationDescriptor != null) {
            return operationDescriptor;
        }
        if (string.startsWith("org.geotoolkit.") && operationRegistry.getDescriptor(RENDERED_MODE, "org.geotoolkit.Combine") == null) {
            try {
                Registry.registerGeotoolkitServices(operationRegistry);
            }
            catch (RuntimeException runtimeException) {
                Logging.unexpectedException((Logger)AbstractCoverageProcessor.LOGGER, OperationJAI.class, (String)"getOperationDescriptor", (Throwable)runtimeException);
            }
            operationDescriptor = (OperationDescriptor)operationRegistry.getDescriptor(RENDERED_MODE, string);
            if (operationDescriptor != null) {
                return operationDescriptor;
            }
        }
        throw new OperationNotFoundException(Errors.format((int)180, (Object)string));
    }

    private static void ensureRenderedImage(Class<?> clazz) throws IllegalArgumentException {
        if (!RenderedImage.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(Errors.format((int)76, clazz, RenderedImage.class));
        }
    }

    protected ParameterBlockJAI prepareParameters(ParameterValueGroup parameterValueGroup) {
        ImagingParameters imagingParameters = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockJAI parameterBlockJAI = (ParameterBlockJAI)imagingParameters.parameters;
        org.geotoolkit.parameter.Parameters.copy((ParameterValueGroup)parameterValueGroup, (ParameterValueGroup)imagingParameters);
        return parameterBlockJAI;
    }

    @Override
    protected Coverage doOperation(ParameterValueGroup parameterValueGroup, Hints hints) throws CoverageProcessingException {
        ParameterBlockJAI parameterBlockJAI = this.prepareParameters(parameterValueGroup);
        String[] stringArray = this.operation.getSourceNames();
        GridCoverage2D[] gridCoverage2DArray = new GridCoverage2D[stringArray.length];
        ViewType viewType = this.extractSources(parameterValueGroup, stringArray, gridCoverage2DArray);
        this.resampleToCommonGeometry(gridCoverage2DArray, null, null, hints);
        GridCoverage2D gridCoverage2D = gridCoverage2DArray[0];
        CoordinateReferenceSystem coordinateReferenceSystem = gridCoverage2D.getCoordinateReferenceSystem2D();
        MathTransform2D mathTransform2D = gridCoverage2D.getGridGeometry().getGridToCRS2D();
        for (int i = 0; i < gridCoverage2DArray.length; ++i) {
            GridCoverage2D gridCoverage2D2 = gridCoverage2DArray[i];
            if (!CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)gridCoverage2D2.getCoordinateReferenceSystem2D()) || !CRS.equalsIgnoreMetadata((Object)mathTransform2D, (Object)gridCoverage2D2.getGridGeometry().getGridToCRS2D())) {
                throw new IllegalArgumentException(Errors.format((int)91));
            }
            parameterBlockJAI.setSource(stringArray[i], (Object)gridCoverage2D2.getRenderedImage());
        }
        gridCoverage2D = this.deriveGridCoverage(gridCoverage2DArray, new Parameters(coordinateReferenceSystem, mathTransform2D, parameterBlockJAI, hints));
        if (viewType != null) {
            gridCoverage2D = gridCoverage2D.view(viewType);
        }
        return gridCoverage2D;
    }

    private static String unsupported(CoordinateReferenceSystem coordinateReferenceSystem) {
        return Errors.format((int)238, (Object)coordinateReferenceSystem.getName().getCode());
    }

    private static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem coordinateReferenceSystem, int n, int n2) throws InvalidGridGeometryException {
        if (n == n2) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.getSubCRS((CoordinateReferenceSystem)coordinateReferenceSystem, (int)n, (int)n2);
        if (coordinateReferenceSystem2 == null) {
            throw new InvalidGridGeometryException(OperationJAI.unsupported(coordinateReferenceSystem));
        }
        return coordinateReferenceSystem2;
    }

    private static void ensureStableDimensions(DimensionFilter dimensionFilter) throws InvalidGridGeometryException {
        int[] nArray = dimensionFilter.getSourceDimensions();
        Arrays.sort(nArray);
        int[] nArray2 = dimensionFilter.getTargetDimensions();
        Arrays.sort(nArray2);
        if (!Arrays.equals(nArray, nArray2)) {
            throw new InvalidGridGeometryException(Errors.format((int)244));
        }
    }

    protected void resampleToCommonGeometry(GridCoverage2D[] gridCoverage2DArray, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform2D mathTransform2D, Hints hints) throws InvalidGridGeometryException, CannotReprojectException {
        if (gridCoverage2DArray == null || gridCoverage2DArray.length == 0) {
            return;
        }
        GridCoverage2D gridCoverage2D = gridCoverage2DArray[0];
        if (coordinateReferenceSystem == null) {
            if (mathTransform2D == null && gridCoverage2DArray.length == 1) {
                return;
            }
            coordinateReferenceSystem = gridCoverage2D.getCoordinateReferenceSystem2D();
        } else {
            try {
                coordinateReferenceSystem = CRSUtilities.getCRS2D((CoordinateReferenceSystem)coordinateReferenceSystem);
            }
            catch (TransformException transformException) {
                throw new CannotReprojectException(OperationJAI.unsupported(coordinateReferenceSystem), transformException);
            }
        }
        if (mathTransform2D == null) {
            mathTransform2D = gridCoverage2D.getGridGeometry().getGridToCRS2D();
        }
        AbstractCoverageProcessor abstractCoverageProcessor = OperationJAI.getProcessor((RenderingHints)hints);
        for (int i = 0; i < gridCoverage2DArray.length; ++i) {
            MathTransform mathTransform;
            ParameterValueGroup parameterValueGroup;
            GridGeometry2D gridGeometry2D;
            Object object;
            GridCoverage2D gridCoverage2D2 = gridCoverage2DArray[i];
            GridGeometry2D gridGeometry2D2 = gridCoverage2D2.getGridGeometry();
            CoordinateReferenceSystem coordinateReferenceSystem2 = gridCoverage2D2.getCoordinateReferenceSystem2D();
            CoordinateReferenceSystem coordinateReferenceSystem3 = gridCoverage2D2.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata((Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2)) {
                object = coordinateReferenceSystem3;
            } else {
                int n = Math.min(gridGeometry2D2.axisDimensionX, gridGeometry2D2.axisDimensionY);
                int n2 = Math.max(gridGeometry2D2.axisDimensionX, gridGeometry2D2.axisDimensionY) + 1;
                int n3 = coordinateReferenceSystem3.getCoordinateSystem().getDimension();
                if (n2 - n != coordinateReferenceSystem2.getCoordinateSystem().getDimension()) {
                    throw new InvalidGridGeometryException(OperationJAI.unsupported(coordinateReferenceSystem3));
                }
                gridGeometry2D = OperationJAI.getSubCRS(coordinateReferenceSystem3, 0, n);
                parameterValueGroup = OperationJAI.getSubCRS(coordinateReferenceSystem3, n2, n3);
                Object[] objectArray = new CoordinateReferenceSystem[3];
                int n4 = 0;
                if (gridGeometry2D != null) {
                    objectArray[n4++] = gridGeometry2D;
                }
                objectArray[n4++] = coordinateReferenceSystem;
                if (parameterValueGroup != null) {
                    objectArray[n4++] = parameterValueGroup;
                }
                objectArray = (CoordinateReferenceSystem[])ArraysExt.resize((Object[])objectArray, (int)n4);
                if (n4 == 1) {
                    object = objectArray[0];
                } else {
                    try {
                        object = FactoryFinder.getCRSFactory((Hints)hints).createCompoundCRS(Collections.singletonMap("name", coordinateReferenceSystem.getName().getCode()), (CoordinateReferenceSystem[])objectArray);
                    }
                    catch (FactoryException factoryException) {
                        throw new CannotReprojectException(factoryException);
                    }
                }
            }
            MathTransform2D mathTransform2D2 = gridGeometry2D2.getGridToCRS2D();
            MathTransform mathTransform2 = gridGeometry2D2.getGridToCRS();
            if (CRS.equalsIgnoreMetadata((Object)mathTransform2D, (Object)mathTransform2D2)) {
                mathTransform = mathTransform2;
            } else {
                int n = Math.min(gridGeometry2D2.gridDimensionX, gridGeometry2D2.gridDimensionY);
                int n5 = Math.max(gridGeometry2D2.gridDimensionX, gridGeometry2D2.gridDimensionY) + 1;
                int n6 = mathTransform2.getSourceDimensions();
                if (n5 - n != mathTransform2D2.getSourceDimensions()) {
                    throw new InvalidGridGeometryException(Errors.format((int)244));
                }
                MathTransformFactory mathTransformFactory = FactoryFinder.getMathTransformFactory((Hints)hints);
                DimensionFilter dimensionFilter = new DimensionFilter(mathTransformFactory);
                mathTransform = mathTransform2D;
                try {
                    MathTransform mathTransform3;
                    if (n != 0) {
                        dimensionFilter.addSourceDimensionRange(0, n);
                        mathTransform3 = dimensionFilter.separate(mathTransform2);
                        OperationJAI.ensureStableDimensions(dimensionFilter);
                        mathTransform3 = mathTransformFactory.createPassThroughTransform(0, mathTransform3, n6 - n);
                        mathTransform = mathTransformFactory.createConcatenatedTransform(mathTransform3, mathTransform);
                    }
                    if (n5 != n6) {
                        dimensionFilter.clear();
                        dimensionFilter.addSourceDimensionRange(n5, n6);
                        mathTransform3 = dimensionFilter.separate(mathTransform2);
                        OperationJAI.ensureStableDimensions(dimensionFilter);
                        mathTransform3 = mathTransformFactory.createPassThroughTransform(n5, mathTransform3, 0);
                        mathTransform = mathTransformFactory.createConcatenatedTransform(mathTransform, mathTransform3);
                    }
                }
                catch (FactoryException factoryException) {
                    throw new CannotReprojectException(Errors.format((int)37, (Object)gridCoverage2D2.getName()), factoryException);
                }
            }
            gridGeometry2D = new GridGeometry2D(null, mathTransform, (CoordinateReferenceSystem)object);
            parameterValueGroup = abstractCoverageProcessor.getOperation("Resample").getParameters();
            parameterValueGroup.parameter("Source").setValue((Object)gridCoverage2D2);
            parameterValueGroup.parameter("GridGeometry").setValue((Object)gridGeometry2D);
            parameterValueGroup.parameter("CoordinateReferenceSystem").setValue(object);
            gridCoverage2DArray[i] = (GridCoverage2D)abstractCoverageProcessor.doOperation(parameterValueGroup);
        }
    }

    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] gridCoverage2DArray, Parameters parameters) {
        Object object;
        RenderingHints renderingHints;
        ImageLayout imageLayout;
        GridCoverage2D gridCoverage2D = gridCoverage2DArray[0];
        GridSampleDimension[][] gridSampleDimensionArray = new GridSampleDimension[gridCoverage2DArray.length][];
        for (int i = 0; i < gridSampleDimensionArray.length; ++i) {
            gridSampleDimensionArray[i] = gridCoverage2DArray[i].getSampleDimensions();
        }
        Object[] objectArray = this.deriveSampleDimension(gridSampleDimensionArray, parameters);
        int n = -1;
        for (int i = 0; i < gridSampleDimensionArray.length; ++i) {
            if (!Arrays.equals(objectArray, gridSampleDimensionArray[i])) continue;
            gridCoverage2D = gridCoverage2DArray[i];
            n = i;
            break;
        }
        ImageLayout imageLayout2 = imageLayout = (renderingHints = ImageUtilities.getRenderingHints(parameters.getSource())) != null ? (ImageLayout)renderingHints.get(JAI.KEY_IMAGE_LAYOUT) : null;
        if (!(imageLayout != null && imageLayout.isValid(512) || objectArray == null || objectArray.length == 0)) {
            int n2 = CoverageUtilities.getVisibleBand(gridCoverage2D.getRenderedImage());
            if (n2 >= objectArray.length) {
                n2 = 0;
            }
            if ((object = ((GridSampleDimension)objectArray[n2]).getColorModel(n2, objectArray.length)) != null) {
                if (imageLayout == null) {
                    imageLayout = new ImageLayout();
                }
                imageLayout = imageLayout.setColorModel((ColorModel)object);
            }
        }
        if (imageLayout != null) {
            if (renderingHints == null) {
                renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            } else {
                renderingHints.put(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            }
        }
        if (parameters.hints != null) {
            if (renderingHints != null) {
                renderingHints.add((RenderingHints)parameters.hints);
            } else {
                renderingHints = parameters.hints;
            }
        }
        InternationalString internationalString = this.deriveName(gridCoverage2DArray, n, parameters);
        object = gridCoverage2D.getCoordinateReferenceSystem();
        MathTransform mathTransform = gridCoverage2D.getGridGeometry().getGridToCRS();
        RenderedImage renderedImage = this.createRenderedImage(parameters.parameters, renderingHints);
        Map<String, ?> map = this.getProperties(renderedImage, (CoordinateReferenceSystem)object, internationalString, mathTransform, gridCoverage2DArray, parameters);
        return OperationJAI.getFactory(parameters.hints).create((CharSequence)internationalString, renderedImage, (CoordinateReferenceSystem)object, mathTransform, (GridSampleDimension[])objectArray, gridCoverage2DArray, map);
    }

    protected Map<String, ?> getProperties(RenderedImage renderedImage, CoordinateReferenceSystem coordinateReferenceSystem, InternationalString internationalString, MathTransform mathTransform, GridCoverage2D[] gridCoverage2DArray, Parameters parameters) {
        return null;
    }

    protected static int getQuantitative(Category[] categoryArray) {
        int n = -1;
        for (int i = 0; i < categoryArray.length; ++i) {
            if (!categoryArray[i].isQuantitative()) continue;
            if (n >= 0) {
                return -1;
            }
            n = i;
        }
        return n;
    }

    protected GridSampleDimension[] deriveSampleDimension(GridSampleDimension[][] gridSampleDimensionArray, Parameters parameters) {
        int n = 1;
        for (int i = 0; i < gridSampleDimensionArray.length; ++i) {
            int n2 = gridSampleDimensionArray[i].length;
            if (n2 == 1) continue;
            if (n != 1 && n2 != n) {
                return null;
            }
            n = n2;
        }
        GridSampleDimension[] gridSampleDimensionArray2 = new GridSampleDimension[n];
        Category[] categoryArray = new Category[gridSampleDimensionArray.length];
        Unit[] unitArray = new Unit[gridSampleDimensionArray.length];
        while (--n >= 0) {
            List<Category> list;
            Unit<?> unit;
            Unit<?> unit2 = null;
            Category[] categoryArray2 = null;
            int n3 = 0;
            int n4 = gridSampleDimensionArray.length;
            while (--n4 >= 0) {
                unit2 = unit[((GridSampleDimension[])(unit = gridSampleDimensionArray[n4])).length == 1 ? 0 : n];
                list = unit2.getCategories();
                if (list == null) {
                    gridSampleDimensionArray2[n] = unit2;
                    continue;
                }
                categoryArray2 = (Category[])list.toArray();
                n3 = OperationJAI.getQuantitative(categoryArray2);
                if (n3 < 0) {
                    return null;
                }
                unitArray[n4] = unit2.getUnits();
                categoryArray[n4] = categoryArray2[n3];
            }
            if (categoryArray2 == null) continue;
            void var10_13 = categoryArray2[n3];
            unit = unit2.getUnits();
            list = this.deriveCategory(categoryArray, parameters);
            Unit<?> unit3 = this.deriveUnit(unitArray, parameters);
            if (list == null) {
                return null;
            }
            if (!var10_13.equals(list) || !Utilities.equals(unit, unit3)) {
                CharSequence charSequence = null;
                categoryArray2[n3] = list;
                gridSampleDimensionArray2[n] = new GridSampleDimension(charSequence, categoryArray2, unit3);
                continue;
            }
            gridSampleDimensionArray2[n] = unit2;
        }
        return gridSampleDimensionArray2;
    }

    protected Category deriveCategory(Category[] categoryArray, Parameters parameters) {
        NumberRange[] numberRangeArray = new NumberRange[categoryArray.length];
        for (int i = 0; i < numberRangeArray.length; ++i) {
            numberRangeArray[i] = categoryArray[i].getRange();
        }
        NumberRange<?> numberRange = this.deriveRange(numberRangeArray, parameters);
        if (numberRange != null) {
            Category category = categoryArray[0];
            return new Category((CharSequence)category.getName(), category.getColors(), category.geophysics(false).getRange(), numberRange).geophysics(true);
        }
        return null;
    }

    protected NumberRange<?> deriveRange(NumberRange<?>[] numberRangeArray, Parameters parameters) {
        return null;
    }

    protected Unit<?> deriveUnit(Unit<?>[] unitArray, Parameters parameters) {
        return null;
    }

    protected InternationalString deriveName(GridCoverage2D[] gridCoverage2DArray, int n, Parameters parameters) {
        InternationalString[] internationalStringArray;
        if (n >= 0) {
            internationalStringArray = new InternationalString[]{gridCoverage2DArray[n].getName()};
        } else {
            internationalStringArray = new InternationalString[gridCoverage2DArray.length];
            for (int i = 0; i < internationalStringArray.length; ++i) {
                internationalStringArray[i] = gridCoverage2DArray[i].getName();
            }
        }
        return new Name(this.getName(), internationalStringArray);
    }

    protected RenderedImage createRenderedImage(ParameterBlockJAI parameterBlockJAI, RenderingHints renderingHints) {
        return OperationJAI.getJAI(renderingHints).createNS(this.operation.getName(), (ParameterBlock)parameterBlockJAI, renderingHints);
    }

    public static JAI getJAI(RenderingHints renderingHints) {
        Object object;
        if (renderingHints != null && (object = renderingHints.get(Hints.JAI_INSTANCE)) instanceof JAI) {
            return (JAI)object;
        }
        return JAI.getDefaultInstance();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            OperationJAI operationJAI = (OperationJAI)object;
            return Utilities.equals((Object)this.operation, (Object)operationJAI.operation);
        }
        return false;
    }

    protected static final class Parameters {
        public final CoordinateReferenceSystem crs;
        public final MathTransform2D gridToCRS;
        public final ParameterBlockJAI parameters;
        public final Hints hints;

        Parameters(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform2D mathTransform2D, ParameterBlockJAI parameterBlockJAI, Hints hints) {
            this.crs = coordinateReferenceSystem;
            this.gridToCRS = mathTransform2D;
            this.parameters = parameterBlockJAI;
            this.hints = hints;
        }

        final RenderedImage getSource() {
            int n = this.parameters.getNumSources();
            for (int i = 0; i < n; ++i) {
                Object object = this.parameters.getSource(i);
                if (!(object instanceof RenderedImage)) continue;
                return (RenderedImage)object;
            }
            return null;
        }
    }

    private static final class Name
    extends AbstractInternationalString
    implements Serializable {
        private static final long serialVersionUID = -8096255331549347383L;
        private final String operation;
        private final InternationalString[] sources;

        public Name(String string, InternationalString[] internationalStringArray) {
            this.operation = string;
            this.sources = internationalStringArray;
        }

        public String toString(Locale locale) {
            StringBuilder stringBuilder = new StringBuilder(this.operation);
            stringBuilder.append('(');
            for (int i = 0; i < this.sources.length; ++i) {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.sources[i].toString(locale));
            }
            return stringBuilder.append(')').toString();
        }
    }
}

