/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.util.HashMap;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.CoverageFactoryFinder;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridCoverageFactory;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.processing.AbstractOperation;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.parameter.DefaultParameterDescriptor;
import org.geotoolkit.referencing.NamedIdentifier;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

@Immutable
@Deprecated
public abstract class Operation2D
extends AbstractOperation {
    private static final long serialVersionUID = 574096338873406394L;
    protected static final int PRIMARY_SOURCE_INDEX = 0;
    private static final ViewType[] PREFERRED_OUTPUTS = new ViewType[]{ViewType.GEOPHYSICS, ViewType.PACKED, ViewType.PHOTOGRAPHIC, ViewType.RENDERED};
    public static final ParameterDescriptor<GridCoverage2D> SOURCE_0;
    public static final ParameterDescriptor<GridCoverage2D> SOURCE_1;
    public static final ParameterDescriptor<GridCoverage2D> SOURCE_2;

    protected Operation2D(ParameterDescriptorGroup parameterDescriptorGroup) {
        super(parameterDescriptorGroup);
    }

    protected ViewType getComputationView(ParameterValueGroup parameterValueGroup) {
        return ViewType.GEOPHYSICS;
    }

    protected ViewType extractSources(ParameterValueGroup parameterValueGroup, GridCoverage2D[] gridCoverage2DArray) throws ParameterNotFoundException, InvalidParameterValueException {
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterValueGroup);
        ArgumentChecks.ensureNonNull((String)"sources", (Object)gridCoverage2DArray);
        String[] stringArray = new String[gridCoverage2DArray.length];
        if (gridCoverage2DArray.length == 1) {
            stringArray[0] = "Source";
        } else {
            StringBuilder stringBuilder = new StringBuilder("source");
            int n = stringBuilder.length();
            for (int i = 0; i < gridCoverage2DArray.length; ++i) {
                stringBuilder.setLength(n);
                stringArray[i] = stringBuilder.append(i).toString();
            }
        }
        return this.extractSources(parameterValueGroup, stringArray, gridCoverage2DArray);
    }

    protected ViewType extractSources(ParameterValueGroup parameterValueGroup, String[] stringArray, GridCoverage2D[] gridCoverage2DArray) throws ParameterNotFoundException, InvalidParameterValueException {
        ArgumentChecks.ensureNonNull((String)"parameters", (Object)parameterValueGroup);
        ArgumentChecks.ensureNonNull((String)"sourceNames", (Object)stringArray);
        ArgumentChecks.ensureNonNull((String)"sources", (Object)gridCoverage2DArray);
        if (gridCoverage2DArray.length != stringArray.length) {
            throw new IllegalArgumentException(Errors.format((int)110, (Object)"sources", (Object)"sourceNames"));
        }
        ViewType viewType = this.getComputationView(parameterValueGroup);
        ArgumentChecks.ensureNonNull((String)"computationView", (Object)((Object)viewType));
        ViewType viewType2 = ViewType.SAME;
        for (int i = 0; i < stringArray.length; ++i) {
            Set<ViewType> set;
            Object object = parameterValueGroup.parameter(stringArray[i]).getValue();
            if (!(object instanceof GridCoverage2D)) {
                throw new InvalidParameterValueException(Errors.format((int)76, (Object)Classes.getClass((Object)object), GridCoverage2D.class), stringArray[i], object);
            }
            GridCoverage2D gridCoverage2D = (GridCoverage2D)object;
            GridCoverage2D gridCoverage2D2 = gridCoverage2D.view(viewType);
            if (i == 0 && gridCoverage2D != gridCoverage2D2 && (set = gridCoverage2D.getViewTypes()) != null) {
                for (ViewType viewType3 : PREFERRED_OUTPUTS) {
                    if (!set.contains((Object)viewType3)) continue;
                    viewType2 = viewType3;
                    break;
                }
            }
            gridCoverage2DArray[i] = gridCoverage2D2;
        }
        return viewType2;
    }

    static GridCoverageFactory getFactory(Hints hints) {
        return CoverageFactoryFinder.getGridCoverageFactory(hints);
    }

    static {
        HashMap<String, NamedIdentifier> hashMap = new HashMap<String, NamedIdentifier>(4);
        hashMap.put("name", new NamedIdentifier(Citations.OGC, "Source"));
        hashMap.put("alias", new NamedIdentifier(Citations.JAI, "source0"));
        SOURCE_0 = new DefaultParameterDescriptor(hashMap, GridCoverage2D.class, null, null, null, null, null, true);
        hashMap.clear();
        hashMap.put("name", new NamedIdentifier(Citations.JAI, "source1"));
        SOURCE_1 = new DefaultParameterDescriptor(hashMap, GridCoverage2D.class, null, null, null, null, null, true);
        hashMap.put("name", new NamedIdentifier(Citations.JAI, "source2"));
        SOURCE_2 = new DefaultParameterDescriptor(hashMap, GridCoverage2D.class, null, null, null, null, null, true);
    }
}

