/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.RenderingHints;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.Interpolator2D;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.coverage.processing.AbstractOperation;
import org.geotoolkit.coverage.processing.CoverageProcessingException;
import org.geotoolkit.factory.FactoryRegistry;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.FactoryUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

@ThreadSafe
public class DefaultCoverageProcessor
extends AbstractCoverageProcessor {
    private static final Comparator<String> COMPARATOR;
    private final Map<String, Operation> operations = new TreeMap<String, Operation>(COMPARATOR);
    private final FactoryRegistry registry = new FactoryRegistry(Arrays.asList(Operation.class));
    private final AbstractCoverageProcessor declaredProcessor;

    public DefaultCoverageProcessor(Hints hints) {
        this(hints, null);
    }

    DefaultCoverageProcessor(Hints hints, AbstractCoverageProcessor abstractCoverageProcessor) {
        Map map = this.hints;
        map.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        map.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        map.put(Hints.COORDINATE_OPERATION_FACTORY, null);
        map.put(Hints.LENIENT_DATUM_SHIFT, null);
        map.put(Hints.DATUM_SHIFT_METHOD, null);
        FactoryUtilities.addImplementationHints((RenderingHints)hints, (Map)map);
        map.remove(Hints.GRID_COVERAGE_PROCESSOR);
        if (abstractCoverageProcessor == null) {
            abstractCoverageProcessor = this;
        }
        this.declaredProcessor = abstractCoverageProcessor;
    }

    protected synchronized void addOperation(Operation operation) throws IllegalStateException {
        ArgumentChecks.ensureNonNull((String)"operation", (Object)operation);
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        this.addOperationImpl(operation);
    }

    private void addOperationImpl(Operation operation) throws IllegalStateException {
        String string = operation.getName().trim();
        Operation operation2 = this.operations.put(string, operation);
        if (operation2 != null && !operation2.equals(operation)) {
            this.operations.put(operation2.getName().trim(), operation2);
            throw new IllegalStateException(Errors.getResources((Locale)this.getLocale()).getString(179, (Object)operation.getName()));
        }
    }

    @Override
    public synchronized Collection<Operation> getOperations() {
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        return this.operations.values();
    }

    @Override
    public synchronized Operation getOperation(String string) throws OperationNotFoundException {
        Operation operation;
        ArgumentChecks.ensureNonNull((String)"name", (Object)string);
        string = string.trim();
        if (this.operations.isEmpty()) {
            this.scanForPlugins();
        }
        if ((operation = this.operations.get(string)) != null) {
            return operation;
        }
        throw new OperationNotFoundException(Errors.getResources((Locale)this.getLocale()).getString(180, (Object)string));
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    @Override
    public synchronized Coverage doOperation(ParameterValueGroup parameterValueGroup) throws CoverageProcessingException, OperationNotFoundException {
        Object object;
        Object object22;
        Coverage coverage = DefaultCoverageProcessor.getPrimarySource(parameterValueGroup);
        String string = DefaultCoverageProcessor.getOperationName(parameterValueGroup);
        Operation operation = this.getOperation(string);
        Object[] objectArray = null;
        if (!string.equalsIgnoreCase("Interpolate")) {
            for (Object object22 : parameterValueGroup.values()) {
                if (!(object22 instanceof ParameterValue) || !((object = ((ParameterValue)object22).getValue()) instanceof Interpolator2D)) continue;
                Object[] objectArray2 = ((Interpolator2D)object).getInterpolations();
                if (objectArray == null) {
                    objectArray = objectArray2;
                    continue;
                }
                if (Arrays.equals(objectArray, objectArray2)) continue;
                objectArray = null;
                break;
            }
        }
        Hints hints = EMPTY_HINTS.clone();
        FactoryUtilities.addValidEntries((Map)this.hints, (RenderingHints)hints, (boolean)true);
        hints.put((Object)Hints.GRID_COVERAGE_PROCESSOR, (Object)this.declaredProcessor);
        try {
            object22 = (AbstractOperation)operation;
        }
        catch (ClassCastException classCastException) {
            throw new OperationNotFoundException(Errors.getResources((Locale)this.getLocale()).getString(180, (Object)string), (Throwable)classCastException);
        }
        object = ((AbstractOperation)object22).doOperation(parameterValueGroup, hints);
        if (objectArray != null && object instanceof GridCoverage2D && !(object instanceof Interpolator2D)) {
            object = Interpolator2D.create((GridCoverage2D)object, (Interpolation[])objectArray);
        }
        this.log(coverage, (Coverage)object, string, false);
        return object;
    }

    public synchronized void scanForPlugins() {
        Iterator iterator = this.registry.getServiceProviders(Operation.class, null, null, null);
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            String string = operation.getName().trim();
            if (this.operations.containsKey(string)) continue;
            this.addOperationImpl(operation);
        }
    }

    static {
        long l = Runtime.getRuntime().maxMemory();
        TileCache tileCache = JAI.getDefaultInstance().getTileCache();
        if (l >= 0x8000000L && tileCache.getMemoryCapacity() < 0x4000000L) {
            tileCache.setMemoryCapacity(0x4000000L);
        }
        float f = (float)tileCache.getMemoryCapacity() / 1048576.0f;
        LOGGER.log(Level.CONFIG, "Java Advanced Imaging: {0}, TileCache capacity={1} Mb", new Object[]{JAI.getBuildVersion(), Float.valueOf(f)});
        if (tileCache.getMemoryCapacity() + 0x400000L >= l) {
            LogRecord logRecord = Loggings.format((Level)Level.SEVERE, (int)24, (Object)((double)l / 1048576.0));
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
        COMPARATOR = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.toLowerCase(Locale.US).compareTo(string2.toLowerCase(Locale.US));
            }
        };
    }
}

