/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.util.Collection;
import javax.media.jai.PlanarImage;
import net.jcip.annotations.ThreadSafe;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.Cache;
import org.geotoolkit.coverage.grid.RenderedCoverage;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.coverage.processing.CachedOperationParameters;
import org.geotoolkit.coverage.processing.CoverageProcessingException;
import org.geotoolkit.coverage.processing.DefaultCoverageProcessor;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.lang.Buffered;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterValueGroup;

@Buffered
@ThreadSafe
public class CachingCoverageProcessor
extends AbstractCoverageProcessor {
    protected final AbstractCoverageProcessor processor;
    private final Cache<CachedOperationParameters, Coverage> cache = new Cache(12, 0L, false);

    public CachingCoverageProcessor() {
        this(EMPTY_HINTS);
    }

    public CachingCoverageProcessor(Hints hints) {
        Object object;
        AbstractCoverageProcessor abstractCoverageProcessor = null;
        if (hints != null && (object = hints.get((Object)Hints.GRID_COVERAGE_PROCESSOR)) instanceof AbstractCoverageProcessor) {
            abstractCoverageProcessor = (AbstractCoverageProcessor)((Object)object);
        }
        if (abstractCoverageProcessor == null) {
            abstractCoverageProcessor = new DefaultCoverageProcessor(hints, this);
        }
        this.processor = abstractCoverageProcessor;
        this.hints.put(Hints.GRID_COVERAGE_PROCESSOR, abstractCoverageProcessor);
    }

    public CachingCoverageProcessor(AbstractCoverageProcessor abstractCoverageProcessor) {
        ArgumentChecks.ensureNonNull((String)"processor", (Object)((Object)abstractCoverageProcessor));
        this.processor = abstractCoverageProcessor;
        this.hints.put(Hints.GRID_COVERAGE_PROCESSOR, abstractCoverageProcessor);
    }

    @Override
    public Collection<Operation> getOperations() {
        return this.processor.getOperations();
    }

    @Override
    public Operation getOperation(String string) throws OperationNotFoundException {
        return this.processor.getOperation(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Coverage doOperation(ParameterValueGroup parameterValueGroup) throws OperationNotFoundException, CoverageProcessingException {
        String string = CachingCoverageProcessor.getOperationName(parameterValueGroup);
        Operation operation = this.processor.getOperation(string);
        CachedOperationParameters cachedOperationParameters = new CachedOperationParameters(operation, parameterValueGroup);
        Coverage coverage = (Coverage)this.cache.peek((Object)cachedOperationParameters);
        if (coverage != null) {
            this.log(CachingCoverageProcessor.getPrimarySource(parameterValueGroup), coverage, string, true);
            return coverage;
        }
        Cache.Handler handler = this.cache.lock((Object)cachedOperationParameters);
        try {
            Object object;
            coverage = (Coverage)handler.peek();
            if (coverage != null) {
                this.log(CachingCoverageProcessor.getPrimarySource(parameterValueGroup), coverage, string, true);
                Coverage coverage2 = coverage;
                return coverage2;
            }
            coverage = this.processor.doOperation(parameterValueGroup);
            if (coverage instanceof RenderedCoverage && (object = ((RenderedCoverage)coverage).getRenderedImage()) instanceof PlanarImage) {
                ((PlanarImage)object).addSink((Object)cachedOperationParameters);
            }
            object = coverage;
            return object;
        }
        finally {
            handler.putAndUnlock((Object)coverage);
        }
    }
}

