/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.RenderingHints;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.coverage.processing.CoverageProcessingException;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.Operation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

@Immutable
public abstract class AbstractOperation
implements Operation,
Serializable {
    private static final long serialVersionUID = -1441856042779942954L;
    protected final ParameterDescriptorGroup descriptor;

    protected AbstractOperation(ParameterDescriptorGroup parameterDescriptorGroup) {
        ArgumentChecks.ensureNonNull((String)"descriptor", (Object)parameterDescriptorGroup);
        this.descriptor = parameterDescriptorGroup;
    }

    public String getName() {
        return this.descriptor.getName().getCode();
    }

    @Deprecated
    public String getDescription() {
        InternationalString internationalString = this.descriptor.getRemarks();
        return internationalString != null ? internationalString.toString() : null;
    }

    @Deprecated
    public String getDocURL() {
        return null;
    }

    @Deprecated
    public String getVersion() {
        return this.descriptor.getName().getVersion();
    }

    @Deprecated
    public String getVendor() {
        return "Geotoolkit.org";
    }

    public int getNumSources() {
        return AbstractOperation.getNumSources(this.descriptor);
    }

    private static int getNumSources(ParameterDescriptorGroup parameterDescriptorGroup) {
        int n = 0;
        for (GeneralParameterDescriptor generalParameterDescriptor : parameterDescriptorGroup.descriptors()) {
            Class clazz;
            if (generalParameterDescriptor instanceof ParameterDescriptorGroup) {
                n += AbstractOperation.getNumSources((ParameterDescriptorGroup)generalParameterDescriptor);
                continue;
            }
            if (!(generalParameterDescriptor instanceof ParameterDescriptor) || !Coverage.class.isAssignableFrom(clazz = ((ParameterDescriptor)generalParameterDescriptor).getValueClass())) continue;
            ++n;
        }
        return n;
    }

    public ParameterValueGroup getParameters() {
        return this.descriptor.createValue();
    }

    protected abstract Coverage doOperation(ParameterValueGroup var1, Hints var2) throws IllegalArgumentException, CoverageProcessingException;

    static AbstractCoverageProcessor getProcessor(RenderingHints renderingHints) {
        Object object;
        if (renderingHints != null && (object = renderingHints.get(Hints.GRID_COVERAGE_PROCESSOR)) instanceof AbstractCoverageProcessor) {
            return (AbstractCoverageProcessor)((Object)object);
        }
        return AbstractCoverageProcessor.getInstance();
    }

    public int hashCode() {
        return this.descriptor.hashCode() ^ 0x80D9DFD6;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            AbstractOperation abstractOperation = (AbstractOperation)object;
            return Utilities.equals((Object)this.descriptor, (Object)abstractOperation.descriptor);
        }
        return false;
    }

    public String toString() {
        return Classes.getShortClassName((Object)this) + '[' + this.getName() + ']';
    }
}

