/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.processing;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.coverage.CoverageFactoryFinder;
import org.geotoolkit.coverage.grid.Interpolator2D;
import org.geotoolkit.coverage.processing.AbstractOperation;
import org.geotoolkit.coverage.processing.CoverageParameterWriter;
import org.geotoolkit.coverage.processing.CoverageProcessingException;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.processing.GridCoverageProcessor;
import org.opengis.coverage.processing.Operation;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.InternationalString;

@ThreadSafe
public abstract class AbstractCoverageProcessor
extends Factory
implements GridCoverageProcessor,
Localized {
    public static final Logger LOGGER = Logging.getLogger(AbstractCoverageProcessor.class);
    public static final Level OPERATION = new LogLevel("OPERATION", 780);

    protected AbstractCoverageProcessor() {
    }

    public static AbstractCoverageProcessor getInstance() {
        return (AbstractCoverageProcessor)CoverageFactoryFinder.getCoverageProcessor(new Hints((RenderingHints.Key)Hints.GRID_COVERAGE_PROCESSOR, AbstractCoverageProcessor.class));
    }

    public abstract Collection<Operation> getOperations();

    public abstract Operation getOperation(String var1) throws OperationNotFoundException;

    public abstract Coverage doOperation(ParameterValueGroup var1) throws OperationNotFoundException, CoverageProcessingException;

    public Locale getLocale() {
        return Locale.getDefault();
    }

    final void log(Coverage coverage, Coverage coverage2, String string, boolean bl) {
        if (coverage != coverage2) {
            String string2 = "Nearest";
            if (coverage2 instanceof Interpolator2D) {
                string2 = ImageUtilities.getInterpolationName(((Interpolator2D)coverage2).getInterpolation());
            }
            Locale locale = this.getLocale();
            LogRecord logRecord = Loggings.getResources((Locale)locale).getLogRecord(OPERATION, 2, (Object)AbstractCoverageProcessor.getName(coverage != null ? coverage : coverage2, locale), (Object)string, (Object)string2, (Object)(bl ? 1 : 0));
            logRecord.setSourceClassName(((Object)((Object)this)).getClass().getCanonicalName());
            logRecord.setSourceMethodName("doOperation");
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    static Coverage getPrimarySource(ParameterValueGroup parameterValueGroup) {
        try {
            return (Coverage)parameterValueGroup.parameter("Source").getValue();
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            return null;
        }
    }

    static String getOperationName(ParameterValueGroup parameterValueGroup) {
        return parameterValueGroup.getDescriptor().getName().getCode().trim();
    }

    private static String getName(Coverage coverage, Locale locale) {
        InternationalString internationalString;
        if (coverage instanceof AbstractCoverage && (internationalString = ((AbstractCoverage)coverage).getName()) != null) {
            return internationalString.toString(locale);
        }
        return Vocabulary.getResources((Locale)locale).getString(311);
    }

    public void listOperations(Writer writer) throws IOException {
        Collection<Operation> collection = this.getOperations();
        CoverageParameterWriter coverageParameterWriter = new CoverageParameterWriter(writer);
        ArrayList<ParameterDescriptorGroup> arrayList = new ArrayList<ParameterDescriptorGroup>(collection.size());
        for (Operation operation : collection) {
            if (!(operation instanceof AbstractOperation)) continue;
            arrayList.add(((AbstractOperation)operation).descriptor);
        }
        coverageParameterWriter.summary(arrayList);
    }

    public void printOperations(Writer writer, String[] stringArray) throws OperationNotFoundException, IOException {
        CoverageParameterWriter coverageParameterWriter = new CoverageParameterWriter(writer);
        String string = System.getProperty("line.separator", "\n");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                Operation operation = this.getOperation(stringArray[i]);
                if (!(operation instanceof AbstractOperation)) continue;
                writer.write(string);
                coverageParameterWriter.format(((AbstractOperation)operation).descriptor);
            }
        } else {
            for (Operation operation : this.getOperations()) {
                if (!(operation instanceof AbstractOperation)) continue;
                writer.write(string);
                coverageParameterWriter.format(((AbstractOperation)operation).descriptor);
            }
        }
    }

    private static final class LogLevel
    extends Level {
        private static final long serialVersionUID = -2944283575307061508L;

        protected LogLevel(String string, int n) {
            super(string, n);
        }
    }
}

