/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import org.apache.sis.util.ArraysExt;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.LookupTableFactory;
import org.geotoolkit.coverage.grid.ViewType;
import org.geotoolkit.coverage.processing.AbstractCoverageProcessor;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.internal.coverage.CoverageUtilities;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Loggings;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

final class ViewsManager {
    private static final float EPS = 1.0E-5f;
    private final Map<ViewType, GridCoverage2D> views = new EnumMap<ViewType, GridCoverage2D>(ViewType.class);

    private ViewsManager(GridCoverage2D gridCoverage2D) {
        boolean bl = true;
        boolean bl2 = true;
        int n = gridCoverage2D.getNumSampleDimensions();
        block0: for (int i = 0; i < n; ++i) {
            GridSampleDimension gridSampleDimension = gridCoverage2D.getSampleDimension(i);
            if (gridSampleDimension == null || XCollections.isNullOrEmpty(gridSampleDimension.getCategories())) continue;
            bl2 = false;
            GridSampleDimension gridSampleDimension2 = gridSampleDimension.geophysics(false);
            if (gridSampleDimension != gridSampleDimension2) {
                for (Category category : gridSampleDimension2.getCategories()) {
                    if (!category.isQuantitative()) continue;
                    continue block0;
                }
            }
            bl = false;
        }
        ViewType viewType = bl2 ? ViewType.PHOTOGRAPHIC : (bl ? ViewType.GEOPHYSICS : ViewType.PACKED);
        this.views.put(viewType, gridCoverage2D);
        this.views.put(ViewType.NATIVE, gridCoverage2D.getNativeView());
    }

    static ViewsManager create(GridCoverage2D gridCoverage2D) {
        Class<? extends GridCoverage2D> clazz = gridCoverage2D.getViewClass();
        if (clazz != null) {
            List<GridCoverage> list = gridCoverage2D.getSources();
            while (list != null) {
                LinkedHashSet linkedHashSet = null;
                for (GridCoverage gridCoverage : list) {
                    Object object;
                    if (gridCoverage instanceof GridCoverage2D) {
                        object = (GridCoverage2D)gridCoverage;
                        if (Utilities.equals((Object)gridCoverage2D.image, (Object)((GridCoverage2D)object).image) && Utilities.equals((Object)gridCoverage2D.gridGeometry, (Object)((GridCoverage2D)object).gridGeometry) && Arrays.equals(gridCoverage2D.sampleDimensions, ((GridCoverage2D)object).sampleDimensions) && ((GridCoverage2D)object).getViewClass() == clazz) {
                            return ((GridCoverage2D)object).copyViewsTo(gridCoverage2D);
                        }
                    }
                    if (XCollections.isNullOrEmpty((Collection)(object = gridCoverage.getSources()))) continue;
                    if (linkedHashSet == null) {
                        linkedHashSet = new LinkedHashSet(object);
                        continue;
                    }
                    linkedHashSet.addAll(object);
                }
                list = linkedHashSet;
            }
        }
        return new ViewsManager(gridCoverage2D);
    }

    public synchronized GridCoverage2D get(GridCoverage2D gridCoverage2D, ViewType viewType, Hints hints) {
        GridCoverage2D gridCoverage2D2 = this.views.get((Object)viewType);
        if (gridCoverage2D2 != null) {
            return gridCoverage2D2;
        }
        gridCoverage2D2 = this.views.get((Object)ViewType.NATIVE);
        if (gridCoverage2D2 == null) {
            throw new IllegalStateException("This coverage has been disposed.");
        }
        switch (viewType) {
            case RENDERED: {
                gridCoverage2D2 = this.rendered(gridCoverage2D, hints);
                break;
            }
            case PACKED: {
                gridCoverage2D2 = ViewsManager.geophysics(gridCoverage2D2, false, hints);
                break;
            }
            case GEOPHYSICS: {
                gridCoverage2D2 = ViewsManager.geophysics(gridCoverage2D2, true, hints);
                break;
            }
            case PHOTOGRAPHIC: {
                gridCoverage2D2 = ViewsManager.photographic(gridCoverage2D2, hints);
                break;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((int)73, (Object)"type", (Object)((Object)viewType)));
            }
        }
        gridCoverage2D2 = gridCoverage2D.specialize(gridCoverage2D2);
        if (gridCoverage2D.copyViewsTo(gridCoverage2D2) != this) {
            throw new AssertionError();
        }
        this.views.put(viewType, gridCoverage2D2);
        return gridCoverage2D2;
    }

    private static GridCoverage2D photographic(GridCoverage2D gridCoverage2D, Hints hints) {
        LookupTableJAI lookupTableJAI;
        int n;
        ColorSpace colorSpace;
        Object object;
        Object object2;
        Object object3;
        ColorModel colorModel;
        RenderedImage renderedImage = gridCoverage2D.getRenderedImage();
        ColorModel colorModel2 = renderedImage.getColorModel();
        if (colorModel2 instanceof ComponentColorModel) {
            return gridCoverage2D;
        }
        if (colorModel2 instanceof IndexColorModel) {
            colorModel = (IndexColorModel)colorModel2;
            int n2 = ((IndexColorModel)colorModel).getMapSize();
            if (ColorUtilities.isGrayPalette((IndexColorModel)colorModel, false)) {
                object3 = new byte[n2];
                ((IndexColorModel)colorModel).getGreens((byte[])object3);
                if (colorModel.hasAlpha()) {
                    object2 = new byte[n2];
                    ((IndexColorModel)colorModel).getAlphas((byte[])object2);
                    object = new byte[][]{object3, object2};
                } else {
                    object = new byte[][]{object3};
                }
                colorSpace = ColorSpace.getInstance(1003);
            } else {
                object = new byte[colorModel2.getNumComponents()][n2];
                switch (((byte[][])object).length) {
                    default: {
                        ((IndexColorModel)colorModel).getAlphas(object[3]);
                    }
                    case 3: {
                        ((IndexColorModel)colorModel).getBlues(object[2]);
                    }
                    case 2: {
                        ((IndexColorModel)colorModel).getGreens(object[1]);
                    }
                    case 1: {
                        ((IndexColorModel)colorModel).getReds(object[0]);
                    }
                    case 0: 
                }
                colorSpace = colorModel.getColorSpace();
            }
            n = 0;
            lookupTableJAI = new LookupTableJAI((byte[][])object);
        } else {
            lookupTableJAI = null;
            colorSpace = colorModel2.getColorSpace();
            n = colorModel2 instanceof DirectColorModel ? 0 : renderedImage.getSampleModel().getTransferType();
        }
        colorModel = new ComponentColorModel(colorSpace, colorModel2.hasAlpha(), colorModel2.isAlphaPremultiplied(), colorModel2.getTransparency(), n);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(renderedImage.getWidth(), renderedImage.getHeight());
        object = ImageUtilities.getRenderingHints(renderedImage);
        if (object == null) {
            object = new RenderingHints(null);
        }
        if ((object3 = (Object)((ImageLayout)((RenderingHints)object).get(JAI.KEY_IMAGE_LAYOUT))) == null) {
            object3 = new ImageLayout();
        }
        object3.setColorModel(colorModel);
        object3.setSampleModel(sampleModel);
        ((RenderingHints)object).put(JAI.KEY_IMAGE_LAYOUT, object3);
        object2 = lookupTableJAI != null ? (Object)LookupDescriptor.create((RenderedImage)renderedImage, (LookupTableJAI)lookupTableJAI, (RenderingHints)object) : (Object)FormatDescriptor.create((RenderedImage)renderedImage, (Integer)n, (RenderingHints)object);
        assert (object2.getColorModel() instanceof ComponentColorModel);
        return ViewsManager.createView(gridCoverage2D, (RenderedOp)object2, null, 2, hints);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GridCoverage2D geophysics(GridCoverage2D gridCoverage2D, boolean bl, Hints hints) {
        int n;
        String string;
        RenderingHints renderingHints;
        ParameterBlock parameterBlock;
        Object[] objectArray;
        Object[] objectArray2;
        block45: {
            int n2;
            int n3;
            Object object;
            int n4;
            Object object2;
            PlanarImage planarImage = gridCoverage2D.image;
            while (planarImage instanceof NullOpImage && (object2 = (NullOpImage)planarImage).getNumSources() == 1) {
                planarImage = object2.getSourceImage(0);
            }
            object2 = planarImage.getSampleModel();
            int n5 = ((SampleModel)object2).getNumBands();
            objectArray2 = gridCoverage2D.sampleDimensions;
            objectArray = (GridSampleDimension[])objectArray2.clone();
            assert (objectArray.length == n5) : objectArray.length;
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                objectArray[n4] = ((GridSampleDimension)objectArray[n4]).geophysics(bl);
            }
            if (Arrays.equals(objectArray2, objectArray)) {
                return gridCoverage2D;
            }
            n4 = CoverageUtilities.getVisibleBand(planarImage);
            Object[] objectArray3 = bl ? objectArray2 : objectArray;
            boolean bl2 = true;
            MathTransform1D[] mathTransform1DArray = new MathTransform1D[n5];
            for (int i = 0; i < n5; bl2 &= object.isIdentity(), ++i) {
                object = ((GridSampleDimension)objectArray3[i]).getSampleToGeophysics();
                if (object != null && !bl) {
                    try {
                        object = object.inverse();
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        object = null;
                        bl2 = false;
                    }
                }
                mathTransform1DArray[i] = object;
            }
            if (bl2) {
                return gridCoverage2D;
            }
            ImageLayout imageLayout = ImageUtilities.getImageLayout((RenderedImage)planarImage);
            object = ((GridSampleDimension)objectArray[n4]).getColorModel(n4, n5);
            SampleModel sampleModel = ((ColorModel)object).createCompatibleSampleModel(imageLayout.getTileWidth((RenderedImage)planarImage), imageLayout.getTileHeight((RenderedImage)planarImage));
            imageLayout = imageLayout.setSampleModel(sampleModel).setColorModel((ColorModel)object);
            parameterBlock = new ParameterBlock().addSource(planarImage);
            renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
            renderingHints.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            renderingHints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
            string = null;
            if (mathTransform1DArray != null) {
                try {
                    n3 = ((SampleModel)object2).getDataType();
                    n2 = sampleModel.getDataType();
                    LookupTableJAI lookupTableJAI = LookupTableFactory.create(n3, n2, mathTransform1DArray);
                    if (lookupTableJAI != null) {
                        string = "Lookup";
                        parameterBlock = parameterBlock.add(lookupTableJAI);
                    }
                }
                catch (TransformException transformException) {
                    // empty catch block
                }
            }
            if (string == null) {
                try {
                    n3 = 1;
                    n2 = 1;
                    boolean bl3 = false;
                    double[] dArray = null;
                    double[] dArray2 = null;
                    Object object3 = null;
                    block9: for (int i = 0; i < n5; ++i) {
                        List<Category> list = ((GridSampleDimension)objectArray2[i]).getCategories();
                        int n6 = list.size();
                        float[] fArray = null;
                        float[] fArray2 = null;
                        double d = Double.NaN;
                        double d2 = Double.NaN;
                        int n7 = 0;
                        for (int j = 0; j < n6; ++j) {
                            double d3;
                            double d4;
                            NumberRange<?> numberRange;
                            Category category;
                            block43: {
                                category = list.get(j);
                                Category category2 = category.geophysics(false);
                                MathTransform1D mathTransform1D = category2.getSampleToGeophysics();
                                if (mathTransform1D == null) {
                                    if (bl) {
                                        n3 = 0;
                                        numberRange = category.geophysics(true).getRange();
                                        d4 = numberRange.getMinimum();
                                        if (Double.doubleToRawLongBits(d4) != Double.doubleToRawLongBits(numberRange.getMaximum())) {
                                            n2 = 0;
                                            break block9;
                                        }
                                        d3 = 0.0;
                                        break block43;
                                    } else {
                                        n2 = 0;
                                        assert (!category2.equals(category)) : category2;
                                        numberRange = category2.getRange();
                                        if (numberRange.getMinimum(true) == 0.0 && numberRange.getMaximum(true) == 0.0) {
                                            assert (Double.isNaN(category.getRange().getMinimum())) : category;
                                            bl3 = true;
                                            continue;
                                        }
                                        n3 = 0;
                                        break block9;
                                    }
                                }
                                if (!bl) {
                                    mathTransform1D = mathTransform1D.inverse();
                                }
                                d4 = mathTransform1D.transform(0.0);
                                d3 = mathTransform1D.derivative(Double.NaN);
                                if (Double.isNaN(d3) || Double.isNaN(d4)) {
                                    n3 = 0;
                                    n2 = 0;
                                    break block9;
                                }
                            }
                            if (j == 0) {
                                if (i == 0) {
                                    dArray = new double[n5];
                                    dArray2 = new double[n5];
                                    object3 = new float[n5][][];
                                }
                                fArray = new float[n6 * 2];
                                fArray2 = new float[n6 * 2];
                                object3[i] = new float[][]{fArray, fArray2};
                                dArray2[i] = d4;
                                dArray[i] = d3;
                            }
                            if (d4 != dArray2[i] || d3 != dArray[i]) {
                                n3 = 0;
                            }
                            numberRange = category.getRange();
                            double d5 = numberRange.getMinimum(true);
                            double d6 = numberRange.getMaximum(true);
                            float f = (float)d5;
                            float f2 = (float)d6;
                            float f3 = (float)(d5 * d3 + d4);
                            float f4 = (float)(d6 * d3 + d4);
                            assert (f <= f2) : numberRange;
                            if (Math.abs(d5 - d) <= (double)1.0E-5f) {
                                if (Math.abs((double)f3 - d2) <= (double)1.0E-5f || Double.isNaN(d2)) {
                                    --n7;
                                } else {
                                    assert (fArray[n7 - 1] < f) : d;
                                    n2 = 0;
                                }
                            } else if (j != 0) assert (!(d > (double)f)) : d;
                            fArray[n7] = f;
                            fArray[n7 + 1] = f2;
                            fArray2[n7] = f3;
                            fArray2[n7 + 1] = f4;
                            n7 += 2;
                            d = numberRange.getMaximum(false);
                            d2 = d * d3 + d4;
                        }
                        fArray = ArraysExt.resize(fArray, (int)n7);
                        object3[i][0] = fArray;
                        fArray2 = ArraysExt.resize(fArray2, (int)n7);
                        object3[i][1] = fArray2;
                        assert (ArraysExt.isSorted((float[])fArray, (boolean)false));
                    }
                    if (n3 != 0 && dArray != null && (!bl3 || ViewsManager.isZeroExcluded((RenderedImage)planarImage, dArray, dArray2))) {
                        if (((SampleModel)object2).getDataType() != 1) {
                            string = "Rescale";
                            parameterBlock = parameterBlock.add(dArray).add(dArray2);
                        }
                        break block45;
                    }
                    if (n2 != 0 && object3 == null) {
                        // empty if block
                    }
                }
                catch (TransformException transformException) {
                    Logging.recoverableException(GridCoverage2D.class, (String)"view", (Throwable)transformException);
                }
            }
        }
        if (string == null) {
            parameterBlock = parameterBlock.add(objectArray2);
            string = "org.geotoolkit.SampleTranscode";
        }
        RenderedOp renderedOp = JAI.create(string, (ParameterBlock)parameterBlock, (RenderingHints)renderingHints);
        if (bl) {
            n = 1;
            return ViewsManager.createView(gridCoverage2D, renderedOp, (GridSampleDimension[])objectArray, n, hints);
        }
        n = 0;
        return ViewsManager.createView(gridCoverage2D, renderedOp, (GridSampleDimension[])objectArray, n, hints);
    }

    private GridCoverage2D rendered(GridCoverage2D gridCoverage2D, Hints hints) {
        return this.get(gridCoverage2D, ViewType.PACKED, hints);
    }

    private static GridCoverage2D createView(GridCoverage2D gridCoverage2D, RenderedOp renderedOp, GridSampleDimension[] gridSampleDimensionArray, int n, Hints hints) {
        GridCoverage[] gridCoverageArray;
        InternationalString internationalString = gridCoverage2D.getName();
        if (GridCoverage2D.LOGGER.isLoggable(AbstractCoverageProcessor.OPERATION)) {
            gridCoverageArray = renderedOp.getOperationName();
            String string = gridCoverageArray.substring(gridCoverageArray.lastIndexOf(46) + 1);
            Locale locale = gridCoverage2D.getLocale();
            LogRecord logRecord = Loggings.getResources((Locale)locale).getLogRecord(AbstractCoverageProcessor.OPERATION, 46, (Object)new Object[]{internationalString != null ? internationalString.toString(locale) : Vocabulary.getResources((Locale)locale).getString(311), n, string});
            logRecord.setSourceClassName(GridCoverage2D.class.getName());
            logRecord.setSourceMethodName("geophysics");
            Logger logger = GridCoverage2D.LOGGER;
            logRecord.setLoggerName(logger.getName());
            logger.log(logRecord);
        }
        gridCoverageArray = new GridCoverage[]{gridCoverage2D};
        return new GridCoverage2D((CharSequence)internationalString, (RenderedImage)renderedOp, gridCoverage2D.gridGeometry, gridSampleDimensionArray, gridCoverageArray, null, hints);
    }

    private static boolean isZeroExcluded(RenderedImage renderedImage, double[] dArray, double[] dArray2) {
        Object object;
        Object object2;
        if (renderedImage instanceof WritableRenderedImage) {
            return false;
        }
        Object object3 = renderedImage;
        while (object3 instanceof PlanarImage) {
            int n;
            object2 = (PlanarImage)renderedImage;
            if (object3 instanceof RenderedOp) {
                object = (RenderedOp)object3;
                String string = object.getOperationName();
                if (string.equalsIgnoreCase("Extrema")) {
                    int n2 = object.getNumParameters();
                    for (int i = 0; i < n2; ++i) {
                        if (!(object.getObjectParameter(i) instanceof ROI)) continue;
                        return false;
                    }
                    break;
                }
                if (!string.equalsIgnoreCase("Null") && !string.equalsIgnoreCase("Histogram")) {
                    return false;
                }
            }
            if ((n = object2.getNumSources()) >= 2) {
                return false;
            }
            if (n == 0) break;
            object3 = object2.getSourceObject(0);
        }
        if (!((object2 = renderedImage.getProperty("extrema")) instanceof double[][])) {
            return false;
        }
        object = (double[][])object2;
        if (((RenderedOp)object).length != 2) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            double d2 = dArray2[i];
            reference var13_14 = object[1][i] * d + d2;
            reference var11_13 = object[0][i] * d + d2;
            if (var13_14 > var11_13) {
                reference var15_15 = var13_14;
                var13_14 = var11_13;
                var11_13 = var15_15;
            }
            if (var13_14 > 0.0 || var11_13 < 0.0) continue;
            return false;
        }
        return true;
    }

    public synchronized Collection<GridCoverage2D> dispose(boolean bl) {
        int n;
        do {
            n = 0;
            Iterator<GridCoverage2D> iterator = this.views.values().iterator();
            while (iterator.hasNext()) {
                GridCoverage2D gridCoverage2D = iterator.next();
                if (!gridCoverage2D.disposeImage(bl)) continue;
                iterator.remove();
                ++n;
            }
        } while (n != 0);
        return this.views.values();
    }
}

