/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.util.Arrays;
import java.util.Map;
import javax.media.jai.LookupTableJAI;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.collection.WeakValueHashMap;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.TransformException;

final class LookupTableFactory
extends Static {
    private static final Map<LookupTableFactory, LookupTableJAI> pool = new WeakValueHashMap();
    private final int sourceType;
    private final int targetType;
    private final MathTransform1D[] transforms;

    private LookupTableFactory(int n, int n2, MathTransform1D[] mathTransform1DArray) {
        this.sourceType = n;
        this.targetType = n2;
        this.transforms = mathTransform1DArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LookupTableJAI create(int n, int n2, MathTransform1D[] mathTransform1DArray) throws TransformException {
        int n3 = mathTransform1DArray.length;
        for (int i = 0; i < n3; ++i) {
            if (mathTransform1DArray[i] != null) continue;
            return null;
        }
        Map<LookupTableFactory, LookupTableJAI> map = pool;
        synchronized (map) {
            int n4;
            int n5;
            LookupTableFactory lookupTableFactory = new LookupTableFactory(n, n2, mathTransform1DArray);
            LookupTableJAI lookupTableJAI = pool.get((Object)lookupTableFactory);
            if (lookupTableJAI != null) {
                return lookupTableJAI;
            }
            switch (n) {
                default: {
                    return null;
                }
                case 0: {
                    n5 = 256;
                    n4 = 0;
                    break;
                }
                case 1: 
                case 2: {
                    if (n2 != 0) {
                        return null;
                    }
                    n5 = 65536;
                    n4 = n == 2 ? Short.MIN_VALUE : 0;
                }
            }
            switch (n2) {
                default: {
                    return null;
                }
                case 5: {
                    double[][] dArrayArray = new double[n3][];
                    double[] dArray = new double[n5];
                    int n6 = n5;
                    while (--n6 >= 0) {
                        dArray[n6] = n6;
                    }
                    n6 = n3;
                    while (--n6 >= 0) {
                        double[] dArray2 = n6 == 0 ? dArray : (double[])dArray.clone();
                        mathTransform1DArray[n6].transform(dArray2, 0, dArray2, 0, dArray2.length);
                        dArrayArray[n6] = dArray2;
                    }
                    lookupTableJAI = new LookupTableJAI((double[][])dArrayArray, n4);
                    break;
                }
                case 4: {
                    float[][] fArrayArray = new float[n3][];
                    float[] fArray = new float[n5];
                    int n7 = n5;
                    while (--n7 >= 0) {
                        fArray[n7] = n7;
                    }
                    n7 = mathTransform1DArray.length;
                    while (--n7 >= 0) {
                        float[] fArray2 = n7 == 0 ? fArray : (float[])fArray.clone();
                        mathTransform1DArray[n7].transform(fArray2, 0, fArray2, 0, n5);
                        fArrayArray[n7] = fArray2;
                    }
                    lookupTableJAI = new LookupTableJAI((float[][])fArrayArray, n4);
                    break;
                }
                case 3: {
                    int[][] nArrayArray = new int[n3][];
                    int n8 = n3;
                    while (--n8 >= 0) {
                        MathTransform1D mathTransform1D = mathTransform1DArray[n8];
                        int[] nArray = new int[n5];
                        int n9 = n5;
                        while (--n9 >= 0) {
                            nArray[n9] = (int)Math.min(Math.max(Math.round(mathTransform1D.transform((double)(n9 + n4))), Integer.MIN_VALUE), Integer.MAX_VALUE);
                        }
                        nArrayArray[n8] = nArray;
                    }
                    lookupTableJAI = new LookupTableJAI((int[][])nArrayArray, n4);
                    break;
                }
                case 1: 
                case 2: {
                    int n10;
                    int n11;
                    if (n2 == 2) {
                        n11 = Short.MIN_VALUE;
                        n10 = Short.MAX_VALUE;
                    } else {
                        n11 = 0;
                        n10 = 65535;
                    }
                    short[][] sArrayArray = new short[n3][];
                    int n12 = n3;
                    while (--n12 >= 0) {
                        MathTransform1D mathTransform1D = mathTransform1DArray[n12];
                        short[] sArray = new short[n5];
                        int n13 = n5;
                        while (--n13 >= 0) {
                            sArray[n13] = (short)Math.min(Math.max(Math.round(mathTransform1D.transform((double)(n13 + n4))), (long)n11), (long)n10);
                        }
                        sArrayArray[n12] = sArray;
                    }
                    lookupTableJAI = new LookupTableJAI((short[][])sArrayArray, n4, n11 != 0);
                    break;
                }
                case 0: {
                    byte[][] byArrayArray = new byte[n3][];
                    int n14 = n3;
                    while (--n14 >= 0) {
                        MathTransform1D mathTransform1D = mathTransform1DArray[n14];
                        byte[] byArray = new byte[n5];
                        int n15 = n5;
                        while (--n15 >= 0) {
                            byArray[n15] = (byte)Math.min(Math.max(Math.round(mathTransform1D.transform((double)(n15 + n4))), 0L), 255L);
                        }
                        byArrayArray[n14] = byArray;
                    }
                    lookupTableJAI = new LookupTableJAI((byte[][])byArrayArray, n4);
                    break;
                }
            }
            pool.put(lookupTableFactory, lookupTableJAI);
            return lookupTableJAI;
        }
    }

    public int hashCode() {
        return this.sourceType + 31 * this.targetType + Arrays.hashCode(this.transforms);
    }

    public boolean equals(Object object) {
        if (object instanceof LookupTableFactory) {
            LookupTableFactory lookupTableFactory = (LookupTableFactory)((Object)object);
            return this.sourceType == lookupTableFactory.sourceType && this.targetType == lookupTableFactory.targetType && Arrays.equals(this.transforms, lookupTableFactory.transforms);
        }
        return false;
    }
}

