/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import org.geotoolkit.coverage.grid.Calculator2D;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public final class Interpolator2D
extends Calculator2D {
    private static final long serialVersionUID = 9028980295030908004L;
    private static final float ONE_EPSILON = 0.99999994f;
    private static Interpolation[] DEFAULTS;
    private final MathTransform2D toGrid;
    private final Interpolation interpolation;
    private final Interpolator2D fallback;
    private final int xmin;
    private final int ymin;
    private final int xmax;
    private final int ymax;
    private final int top;
    private final int left;
    private final Rectangle bounds;
    private transient double[][] doubles;
    private transient float[][] floats;
    private transient int[][] ints;

    public static GridCoverage2D create(GridCoverage2D gridCoverage2D) {
        if (DEFAULTS == null) {
            DEFAULTS = new Interpolation[]{Interpolation.getInstance((int)2), Interpolation.getInstance((int)1), Interpolation.getInstance((int)0)};
        }
        return Interpolator2D.create(gridCoverage2D, DEFAULTS);
    }

    public static GridCoverage2D create(GridCoverage2D gridCoverage2D, Interpolation ... interpolationArray) {
        while (gridCoverage2D instanceof Calculator2D) {
            gridCoverage2D = ((Calculator2D)gridCoverage2D).source;
        }
        if (interpolationArray.length == 0 || interpolationArray[0] instanceof InterpolationNearest) {
            return gridCoverage2D;
        }
        return new Interpolator2D(gridCoverage2D, interpolationArray, 0);
    }

    private Interpolator2D(GridCoverage2D gridCoverage2D, Interpolation[] interpolationArray, int n) {
        super((CharSequence)null, gridCoverage2D);
        this.interpolation = interpolationArray[n];
        this.fallback = n + 1 < interpolationArray.length ? (interpolationArray[n + 1] instanceof InterpolationNearest ? this : new Interpolator2D(gridCoverage2D, interpolationArray, n + 1)) : null;
        if (this.fallback != null && this.fallback != this) {
            this.toGrid = this.fallback.toGrid;
        } else {
            try {
                MathTransform2D mathTransform2D = this.gridGeometry.getGridToCRS2D();
                this.toGrid = mathTransform2D.inverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException(noninvertibleTransformException);
            }
        }
        int n2 = this.interpolation.getLeftPadding();
        int n3 = this.interpolation.getRightPadding();
        int n4 = this.interpolation.getTopPadding();
        int n5 = this.interpolation.getBottomPadding();
        this.top = n4;
        this.left = n2;
        int n6 = this.image.getMinX();
        int n7 = this.image.getMinY();
        this.xmin = n6 + n2;
        this.ymin = n7 + n4;
        this.xmax = n6 + this.image.getWidth() - n3;
        this.ymax = n7 + this.image.getHeight() - n5;
        this.bounds = new Rectangle(0, 0, this.interpolation.getWidth(), this.interpolation.getHeight());
    }

    @Override
    protected GridCoverage2D specialize(GridCoverage2D gridCoverage2D) {
        return Interpolator2D.create(gridCoverage2D, this.getInterpolations());
    }

    Class<Interpolator2D> getViewClass() {
        return Interpolator2D.class;
    }

    public Interpolation[] getInterpolations() {
        ArrayList<Interpolation> arrayList = new ArrayList<Interpolation>(4);
        Interpolator2D interpolator2D = this;
        do {
            arrayList.add(this.interpolation);
            if (interpolator2D.fallback != interpolator2D) continue;
            arrayList.add(Interpolation.getInstance((int)0));
            break;
        } while ((interpolator2D = interpolator2D.fallback) != null);
        return arrayList.toArray(new Interpolation[arrayList.size()]);
    }

    @Override
    public Interpolation getInterpolation() {
        return this.interpolation;
    }

    @Override
    public int[] evaluate(Point2D point2D, int[] nArray) throws CannotEvaluateException {
        if (this.fallback != null) {
            nArray = super.evaluate(point2D, nArray);
        }
        try {
            Point2D point2D2 = this.toGrid.transform(point2D, null);
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            if (!Double.isNaN(d) && !Double.isNaN(d2) && (nArray = this.interpolate(d, d2, nArray, 0, this.image.getNumBands())) != null) {
                return nArray;
            }
        }
        catch (TransformException transformException) {
            throw new CannotEvaluateException(this.formatEvaluateError(point2D, false), (Throwable)transformException);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(point2D, true));
    }

    @Override
    public float[] evaluate(Point2D point2D, float[] fArray) throws CannotEvaluateException {
        if (this.fallback != null) {
            fArray = super.evaluate(point2D, fArray);
        }
        try {
            Point2D point2D2 = this.toGrid.transform(point2D, null);
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            if (!Double.isNaN(d) && !Double.isNaN(d2) && (fArray = this.interpolate(d, d2, fArray, 0, this.image.getNumBands())) != null) {
                return fArray;
            }
        }
        catch (TransformException transformException) {
            throw new CannotEvaluateException(this.formatEvaluateError(point2D, false), (Throwable)transformException);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(point2D, true));
    }

    @Override
    public double[] evaluate(Point2D point2D, double[] dArray) throws CannotEvaluateException {
        if (this.fallback != null) {
            dArray = super.evaluate(point2D, dArray);
        }
        try {
            Point2D point2D2 = this.toGrid.transform(point2D, null);
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            if (!Double.isNaN(d) && !Double.isNaN(d2) && (dArray = this.interpolate(d, d2, dArray, 0, this.image.getNumBands())) != null) {
                return dArray;
            }
        }
        catch (TransformException transformException) {
            throw new CannotEvaluateException(this.formatEvaluateError(point2D, false), (Throwable)transformException);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(point2D, true));
    }

    private synchronized int[] interpolate(double d, double d2, int[] nArray, int n, int n2) {
        int n3;
        int n4;
        double d3 = Math.floor(d);
        double d4 = Math.floor(d2);
        int n5 = (int)d3;
        int n6 = (int)d4;
        if (n5 < this.xmin || n5 >= this.xmax || n6 < this.ymin || n6 >= this.ymax) {
            if (this.fallback == null) {
                return null;
            }
            if (this.fallback == this) {
                return nArray;
            }
            return this.fallback.interpolate(d, d2, nArray, n, n2);
        }
        Object object = this.ints;
        if (object == null) {
            int n7 = this.interpolation.getHeight();
            n4 = this.interpolation.getWidth();
            int[][] nArrayArray = new int[n7][];
            object = nArrayArray;
            this.ints = nArrayArray;
            for (n3 = 0; n3 < n7; ++n3) {
                object[n3] = new int[n4];
            }
        }
        if (nArray == null) {
            nArray = new int[n2];
        }
        this.bounds.x = n5 - this.left;
        this.bounds.y = n6 - this.top;
        RectIter rectIter = RectIterFactory.create((RenderedImage)this.image, (Rectangle)this.bounds);
        while (n < n2) {
            int n8;
            rectIter.startLines();
            n4 = 0;
            do {
                rectIter.startPixels();
                int[] nArray2 = object[n4++];
                n8 = 0;
                do {
                    nArray2[n8++] = rectIter.getSample(n);
                } while (!rectIter.nextPixelDone());
                assert (n8 == nArray2.length);
            } while (!rectIter.nextLineDone());
            assert (n4 == ((int[][])object).length);
            n3 = (int)((d - d3) * (double)(1 << this.interpolation.getSubsampleBitsH()));
            n8 = (int)((d2 - d4) * (double)(1 << this.interpolation.getSubsampleBitsV()));
            nArray[n] = this.interpolation.interpolate(object, n3, n8);
            ++n;
        }
        return nArray;
    }

    /*
     * Exception decompiling
     */
    private synchronized float[] interpolate(double var1_1, double var3_2, float[] var5_3, int var6_4, int var7_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private synchronized double[] interpolate(double var1_1, double var3_2, double[] var5_3, int var6_4, int var7_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

