/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Rectangle;
import net.jcip.annotations.Immutable;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GridCoordinates2D;
import org.geotoolkit.util.Cloneable;
import org.opengis.coverage.grid.GridEnvelope;

@Immutable
public class GridEnvelope2D
extends Rectangle
implements GridEnvelope,
Cloneable {
    private static final long serialVersionUID = -3370515914148690059L;

    public GridEnvelope2D() {
    }

    public GridEnvelope2D(Rectangle rectangle) {
        super(rectangle);
    }

    public GridEnvelope2D(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public final int getDimension() {
        return 2;
    }

    public GridCoordinates2D getLow() {
        return new GridCoordinates2D(this.x, this.y);
    }

    public GridCoordinates2D getHigh() {
        return new GridCoordinates2D(this.x + this.width - 1, this.y + this.height - 1);
    }

    public int getLow(int n) {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(n));
    }

    public int getHigh(int n) {
        switch (n) {
            case 0: {
                return this.x + this.width - 1;
            }
            case 1: {
                return this.y + this.height - 1;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(n));
    }

    public int getSpan(int n) {
        switch (n) {
            case 0: {
                return this.width;
            }
            case 1: {
                return this.height;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(n));
    }

    @Override
    public String toString() {
        return GeneralGridEnvelope.toString(this);
    }

    @Override
    public GridEnvelope2D clone() {
        return (GridEnvelope2D)super.clone();
    }
}

