/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Arrays;
import java.util.Map;
import javax.measure.unit.Unit;
import javax.media.jai.ImageFunction;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.RenderedSampleDimension;
import org.geotoolkit.factory.Factory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.FactoryUtilities;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;

@ThreadSafe
@Deprecated
public class GridCoverageFactory
extends Factory {
    private static final boolean USE_BUILDER = false;
    private final Hints builderHints;
    private final Hints userHints = null;

    public GridCoverageFactory() {
        this(EMPTY_HINTS);
    }

    public GridCoverageFactory(Hints hints) {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        String string = null;
        if (hints != null) {
            coordinateReferenceSystem = (CoordinateReferenceSystem)hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            if (Utilities.equals((Object)coordinateReferenceSystem, (Object)DefaultGeographicCRS.WGS84) || Utilities.equals((Object)coordinateReferenceSystem, (Object)DefaultGeographicCRS.WGS84_3D)) {
                coordinateReferenceSystem = null;
            }
            if ((string = (String)hints.get((Object)Hints.TILE_ENCODING)) != null && (string = string.trim()).isEmpty()) {
                string = null;
            }
        }
        this.hints.put(Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, coordinateReferenceSystem);
        this.hints.put(Hints.TILE_ENCODING, string);
        Hints hints2 = new Hints((RenderingHints)EMPTY_HINTS);
        FactoryUtilities.addValidEntries((Map)this.hints, (RenderingHints)hints2, (boolean)true);
        this.builderHints = hints2.isEmpty() ? null : hints2;
    }

    protected CoordinateReferenceSystem getDefaultCRS(int n) {
        CoordinateReferenceSystem coordinateReferenceSystem = (CoordinateReferenceSystem)this.hints.get(Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (coordinateReferenceSystem != null) {
            return coordinateReferenceSystem;
        }
        switch (n) {
            case 2: {
                return DefaultGeographicCRS.WGS84;
            }
            case 3: {
                return DefaultGeographicCRS.WGS84_3D;
            }
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"dimension", (Object)n));
    }

    public GridCoverage2D create(CharSequence charSequence, ImageFunction imageFunction, GridGeometry2D gridGeometry2D, GridSampleDimension[] gridSampleDimensionArray, Map<?, ?> map) {
        MathTransform2D mathTransform2D = gridGeometry2D.getGridToCRS2D();
        if (!(mathTransform2D instanceof AffineTransform)) {
            throw new IllegalArgumentException(Errors.format((int)140));
        }
        AffineTransform affineTransform = (AffineTransform)mathTransform2D;
        if (affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0) {
            throw new IllegalArgumentException("Shear and rotation not supported");
        }
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        double d3 = -affineTransform.getTranslateX() / d;
        double d4 = -affineTransform.getTranslateY() / d2;
        GridEnvelope gridEnvelope = gridGeometry2D.getExtent();
        ParameterBlock parameterBlock = new ParameterBlock().add(imageFunction).add(gridEnvelope.getSpan(0)).add(gridEnvelope.getSpan(1)).add((float)d).add((float)d2).add((float)d3).add((float)d4);
        RenderedOp renderedOp = JAI.create((String)"ImageFunction", (ParameterBlock)parameterBlock);
        return this.create(charSequence, (RenderedImage)renderedOp, gridGeometry2D, gridSampleDimensionArray, null, map);
    }

    public GridCoverage2D create(CharSequence charSequence, float[][] fArray, Envelope envelope) {
        int n = 0;
        int n2 = fArray.length;
        for (int i = 0; i < n2; ++i) {
            float[] fArray2 = fArray[i];
            if (fArray2 == null || fArray2.length <= n) continue;
            n = fArray2.length;
        }
        WritableRaster writableRaster = RasterFactory.createBandedRaster((int)4, (int)n, (int)n2, (int)1, null);
        for (int i = 0; i < n2; ++i) {
            int n3;
            float[] fArray3 = fArray[i];
            if (fArray3 != null) {
                for (n3 = 0; n3 < fArray3.length; ++n3) {
                    writableRaster.setSample(n3, i, 0, fArray3[n3]);
                }
            }
            while (n3 < n) {
                writableRaster.setSample(n3, i, 0, Float.NaN);
                ++n3;
            }
        }
        return this.create(charSequence, writableRaster, envelope);
    }

    public GridCoverage2D create(CharSequence charSequence, WritableRaster writableRaster, Envelope envelope) {
        return this.create(charSequence, writableRaster, envelope, null, null, null, (Color[][])null, null);
    }

    public GridCoverage2D create(CharSequence charSequence, WritableRaster writableRaster, Envelope envelope, double[] dArray, double[] dArray2, Unit<?> unit, Color[][] colorArray, RenderingHints renderingHints) {
        int n = writableRaster.getNumBands();
        Object[] objectArray = new Unit[n];
        Arrays.fill(objectArray, unit);
        Object[] objectArray2 = new CharSequence[n];
        Arrays.fill(objectArray2, charSequence);
        GridSampleDimension[] gridSampleDimensionArray = RenderedSampleDimension.create((CharSequence[])objectArray2, writableRaster, dArray, dArray2, objectArray, colorArray, renderingHints);
        ColorModel colorModel = gridSampleDimensionArray[0].getColorModel(0, gridSampleDimensionArray.length, writableRaster.getDataBuffer().getDataType());
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        return this.create(charSequence, (RenderedImage)bufferedImage, envelope, gridSampleDimensionArray, null, null);
    }

    public GridCoverage2D create(CharSequence charSequence, WritableRaster writableRaster, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, double[] dArray, double[] dArray2, Unit<?> unit, Color[][] colorArray, RenderingHints renderingHints) {
        int n = writableRaster.getNumBands();
        Object[] objectArray = new Unit[n];
        Arrays.fill(objectArray, unit);
        Object[] objectArray2 = new CharSequence[n];
        Arrays.fill(objectArray2, charSequence);
        GridSampleDimension[] gridSampleDimensionArray = RenderedSampleDimension.create((CharSequence[])objectArray2, writableRaster, dArray, dArray2, objectArray, colorArray, renderingHints);
        ColorModel colorModel = gridSampleDimensionArray[0].getColorModel(0, gridSampleDimensionArray.length, writableRaster.getDataBuffer().getDataType());
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        return this.create(charSequence, bufferedImage, coordinateReferenceSystem, mathTransform, gridSampleDimensionArray, null, null);
    }

    private static GridSampleDimension[] createDefaultBands(CharSequence charSequence, Raster raster) {
        GridSampleDimension[] gridSampleDimensionArray = new GridSampleDimension[raster.getNumBands()];
        RenderedSampleDimension.create(charSequence, null, raster, raster.getSampleModel(), null, gridSampleDimensionArray);
        return gridSampleDimensionArray;
    }

    public GridCoverage2D create(CharSequence charSequence, WritableRaster writableRaster, Envelope envelope, GridSampleDimension ... gridSampleDimensionArray) {
        if (gridSampleDimensionArray == null || gridSampleDimensionArray.length == 0) {
            gridSampleDimensionArray = GridCoverageFactory.createDefaultBands(charSequence, writableRaster);
        }
        ColorModel colorModel = gridSampleDimensionArray[0].getColorModel(0, gridSampleDimensionArray.length, writableRaster.getDataBuffer().getDataType());
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        return this.create(charSequence, (RenderedImage)bufferedImage, envelope, gridSampleDimensionArray, null, null);
    }

    public GridCoverage2D create(CharSequence charSequence, WritableRaster writableRaster, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, GridSampleDimension ... gridSampleDimensionArray) {
        if (gridSampleDimensionArray == null || gridSampleDimensionArray.length == 0) {
            gridSampleDimensionArray = GridCoverageFactory.createDefaultBands(charSequence, writableRaster);
        }
        ColorModel colorModel = gridSampleDimensionArray[0].getColorModel(0, gridSampleDimensionArray.length, writableRaster.getDataBuffer().getDataType());
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        return this.create(charSequence, bufferedImage, coordinateReferenceSystem, mathTransform, gridSampleDimensionArray, null, null);
    }

    public GridCoverage2D create(CharSequence charSequence, RenderedImage renderedImage, Envelope envelope) {
        return this.create(charSequence, renderedImage, envelope, null, null, null);
    }

    public GridCoverage2D create(CharSequence charSequence, RenderedImage renderedImage, Envelope envelope, GridSampleDimension[] gridSampleDimensionArray, GridCoverage[] gridCoverageArray, Map<?, ?> map) {
        Object object;
        if (envelope.getCoordinateReferenceSystem() == null) {
            object = new GeneralEnvelope(envelope);
            object.setCoordinateReferenceSystem(this.getDefaultCRS(object.getDimension()));
            envelope = object;
        }
        object = new GridGeometry2D(new GeneralGridEnvelope(renderedImage, envelope.getDimension()), envelope);
        return this.create(charSequence, renderedImage, (GridGeometry2D)object, gridSampleDimensionArray, gridCoverageArray, map);
    }

    public GridCoverage2D create(CharSequence charSequence, RenderedImage renderedImage, CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, GridSampleDimension[] gridSampleDimensionArray, GridCoverage[] gridCoverageArray, Map<?, ?> map) {
        GridGeometry2D gridGeometry2D = new GridGeometry2D(new GeneralGridEnvelope(renderedImage, coordinateReferenceSystem.getCoordinateSystem().getDimension()), mathTransform, coordinateReferenceSystem);
        return this.create(charSequence, renderedImage, gridGeometry2D, gridSampleDimensionArray, gridCoverageArray, map);
    }

    public GridCoverage2D create(CharSequence charSequence, RenderedImage renderedImage, GridGeometry2D gridGeometry2D, GridSampleDimension[] gridSampleDimensionArray, GridCoverage[] gridCoverageArray, Map<?, ?> map) {
        if (!gridGeometry2D.isDefined(1)) {
            int n = gridGeometry2D.getGridToCRS().getTargetDimensions();
            gridGeometry2D = new GridGeometry2D(gridGeometry2D, this.getDefaultCRS(n));
        }
        GridCoverage2D gridCoverage2D = new GridCoverage2D(charSequence, (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)renderedImage), gridGeometry2D, gridSampleDimensionArray, gridCoverageArray, map, this.userHints);
        gridCoverage2D.tileEncoding = (String)this.hints.get(Hints.TILE_ENCODING);
        return gridCoverage2D;
    }
}

