/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.measure.unit.Unit;
import javax.media.jai.ImageFunction;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.ImageFunctionDescriptor;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.GeneralGridGeometry;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridGeometry2D;
import org.geotoolkit.coverage.grid.InvalidGridGeometryException;
import org.geotoolkit.coverage.grid.RenderedSampleDimension;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.image.io.PaletteFactory;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.lang.Builder;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.AffineTransform2D;
import org.geotoolkit.referencing.operation.transform.LinearTransform1D;
import org.geotoolkit.referencing.operation.transform.LogarithmicTransform1D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.collection.BackingStoreException;
import org.geotoolkit.util.collection.XCollections;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridCoverageBuilder
extends Builder<GridCoverage> {
    protected CharSequence name;
    protected CoordinateReferenceSystem crs;
    protected Envelope envelope;
    protected GridEnvelope extent;
    protected MathTransform gridToCRS;
    protected PixelInCell pixelAnchor;
    protected GridGeometry gridGeometry;
    private transient GridGeometry cachedGridGeometry;
    protected int numBands;
    private Variable[] variables;
    private transient SampleDimension[] sampleDimensions;
    private TileLayout tileLayout;
    private Raster raster;
    protected RenderedImage image;
    private GridCoverage2D coverage;
    protected GridCoverage[] sources;
    protected Map<?, ?> properties;
    protected final Hints hints;

    public GridCoverageBuilder() {
        this.hints = null;
    }

    public GridCoverageBuilder(Hints hints) {
        this.hints = XCollections.isNullOrEmpty((Map)hints) ? null : new Hints((RenderingHints)hints);
    }

    public CharSequence getName() {
        CharSequence charSequence = this.name;
        if (charSequence == null) {
            Variable variable;
            Variable[] variableArray = this.variables;
            for (int i = 0; i < this.numBands && ((variable = variableArray[i]) == null || (charSequence = variable.getName()) == null); ++i) {
            }
        }
        return charSequence;
    }

    public void setName(CharSequence charSequence) {
        this.name = charSequence;
        this.coverage = null;
    }

    private static void ensureDimensionMatch(String string, int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)string, (Object)n, (Object)n2));
        }
    }

    private boolean isDefined(int n) {
        GridGeometry gridGeometry = this.gridGeometry;
        if (gridGeometry == null) {
            return false;
        }
        if (gridGeometry instanceof GeneralGridGeometry) {
            return ((GeneralGridGeometry)gridGeometry).isDefined(n);
        }
        return (n & 0xC) == n;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CoordinateReferenceSystem coordinateReferenceSystem = this.crs;
        if (coordinateReferenceSystem == null) {
            Envelope envelope = this.envelope;
            if (envelope != null) {
                return envelope.getCoordinateReferenceSystem();
            }
            if (this.isDefined(1)) {
                return ((GeneralGridGeometry)this.gridGeometry).getCoordinateReferenceSystem();
            }
            if (this.hints != null) {
                return (CoordinateReferenceSystem)this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
            }
        }
        return coordinateReferenceSystem;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws IllegalArgumentException {
        if (coordinateReferenceSystem != null) {
            int n = coordinateReferenceSystem.getCoordinateSystem().getDimension();
            MathTransform mathTransform = this.gridToCRS;
            if (mathTransform != null) {
                GridCoverageBuilder.ensureDimensionMatch("crs", n, mathTransform.getSourceDimensions());
            }
            if (this.isDefined(1)) {
                if (mathTransform == null) {
                    this.gridToCRS = this.gridGeometry.getGridToCRS();
                    this.pixelAnchor = null;
                }
                if (this.extent == null) {
                    this.extent = this.gridGeometry.getExtent();
                }
                this.gridGeometry = null;
            } else if (this.isDefined(2)) {
                this.gridGeometry = null;
            }
            Envelope envelope = this.envelope;
            if (envelope != null) {
                GridCoverageBuilder.ensureDimensionMatch("crs", n, envelope.getDimension());
                try {
                    this.envelope = Envelopes.transform((Envelope)envelope, (CoordinateReferenceSystem)coordinateReferenceSystem);
                }
                catch (TransformException transformException) {
                    throw new IllegalArgumentException(Errors.format((int)77), transformException);
                }
                if (this.envelope.getCoordinateReferenceSystem() != coordinateReferenceSystem) {
                    this.envelope = new ImmutableEnvelope(coordinateReferenceSystem, this.envelope);
                }
            }
        }
        this.crs = coordinateReferenceSystem;
        this.gridGeometryChanged();
    }

    public void setCoordinateReferenceSystem(String string) throws IllegalArgumentException {
        CoordinateReferenceSystem coordinateReferenceSystem = null;
        if (string != null) {
            try {
                coordinateReferenceSystem = CRS.decode((String)string, (boolean)true);
            }
            catch (FactoryException factoryException) {
                throw new IllegalArgumentException(Errors.format((int)77), factoryException);
            }
        }
        this.setCoordinateReferenceSystem(coordinateReferenceSystem);
    }

    public Envelope getEnvelope() {
        Envelope envelope = this.envelope;
        if (envelope != null) {
            if (envelope instanceof Cloneable) {
                return (Envelope)((Cloneable)envelope).clone();
            }
        } else if (this.isDefined(2)) {
            return ((GeneralGridGeometry)this.gridGeometry).getEnvelope();
        }
        return envelope;
    }

    public void setEnvelope(Envelope envelope) throws IllegalArgumentException {
        Envelope envelope2 = envelope;
        if (envelope2 != null) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            int n = envelope2.getDimension();
            MathTransform mathTransform = this.gridToCRS;
            if (mathTransform != null) {
                GridCoverageBuilder.ensureDimensionMatch("envelope", n, mathTransform.getTargetDimensions());
            }
            if ((coordinateReferenceSystem = this.crs) != null) {
                GridCoverageBuilder.ensureDimensionMatch("envelope", n, coordinateReferenceSystem.getCoordinateSystem().getDimension());
                try {
                    envelope2 = Envelopes.transform((Envelope)envelope2, (CoordinateReferenceSystem)coordinateReferenceSystem);
                }
                catch (TransformException transformException) {
                    throw new IllegalArgumentException(Errors.format((int)77), transformException);
                }
                if (envelope2.getCoordinateReferenceSystem() != coordinateReferenceSystem) {
                    envelope2 = new ImmutableEnvelope(coordinateReferenceSystem, envelope2);
                }
            }
            if (envelope2 == envelope) {
                envelope2 = ImmutableEnvelope.castOrCopy((Envelope)envelope2);
            }
        }
        this.envelope = envelope2;
        this.gridGeometryChanged();
    }

    public void setEnvelope(double ... dArray) throws IllegalArgumentException {
        GeneralEnvelope generalEnvelope = null;
        if (dArray != null) {
            CoordinateReferenceSystem coordinateReferenceSystem = this.crs;
            generalEnvelope = coordinateReferenceSystem != null ? new GeneralEnvelope(coordinateReferenceSystem) : new GeneralEnvelope(dArray.length / 2);
            generalEnvelope.setEnvelope(dArray);
        }
        this.setEnvelope((Envelope)generalEnvelope);
    }

    public GridEnvelope getExtent() {
        GridEnvelope gridEnvelope = this.extent;
        if (gridEnvelope != null) {
            if (gridEnvelope instanceof Cloneable) {
                return (GridEnvelope)((Cloneable)gridEnvelope).clone();
            }
        } else {
            if (this.isDefined(4)) {
                return this.gridGeometry.getExtent();
            }
            RenderedImage renderedImage = this.image;
            if (renderedImage != null) {
                return new GeneralGridEnvelope(renderedImage, this.getGridDimension(2));
            }
        }
        return gridEnvelope;
    }

    public void setExtent(GridEnvelope gridEnvelope) throws MismatchedDimensionException {
        int n;
        if (gridEnvelope != null && (n = this.getGridDimension(-1)) >= 0) {
            GridCoverageBuilder.ensureDimensionMatch("extent", gridEnvelope.getDimension(), n);
        }
        this.extent = gridEnvelope;
        this.gridGeometryChanged();
    }

    public void setExtent(int ... nArray) throws MismatchedDimensionException {
        this.setExtent(nArray != null ? new GeneralGridEnvelope(new int[nArray.length], nArray, false) : null);
    }

    private int getGridDimension(int n) {
        MathTransform mathTransform = null;
        GridGeometry gridGeometry = this.gridGeometry;
        if (gridGeometry != null) {
            if (gridGeometry instanceof GeneralGridGeometry) {
                return ((GeneralGridGeometry)gridGeometry).getDimension();
            }
            mathTransform = gridGeometry.getGridToCRS();
        }
        if (mathTransform == null && (mathTransform = this.gridToCRS) == null) {
            return n;
        }
        return mathTransform.getSourceDimensions();
    }

    private AffineTransform getAffineGridToCRS(PixelOrientation pixelOrientation, boolean bl) throws IllegalStateException {
        Serializable serializable;
        MathTransform mathTransform = this.gridToCRS;
        if (mathTransform == null) {
            serializable = GridGeometry2D.castOrCopy(this.getGridGeometry(false));
            if (serializable == null || !bl && !((GeneralGridGeometry)serializable).isDefined(8)) {
                return null;
            }
            PixelInCell pixelInCell = this.pixelAnchor;
            mathTransform = pixelInCell == null ? ((GridGeometry2D)serializable).getGridToCRS2D() : ((GridGeometry2D)serializable).getGridToCRS2D(pixelOrientation);
            bl = false;
        }
        if (mathTransform instanceof AffineTransform) {
            double d;
            serializable = (AffineTransform)mathTransform;
            if (bl && (d = -0.5 - PixelTranslation.getPixelTranslation((PixelInCell)this.getPixelAnchor())) != 0.0) {
                serializable = new AffineTransform((AffineTransform)serializable);
                ((AffineTransform)serializable).translate(d, d);
            }
            return serializable;
        }
        throw new IllegalStateException(Errors.format((int)140));
    }

    public AffineTransform getAffineGridToCRS() throws IllegalStateException {
        return this.getAffineGridToCRS(PixelTranslation.getPixelOrientation((PixelInCell)this.pixelAnchor), false);
    }

    public MathTransform getGridToCRS() {
        GridGeometry gridGeometry;
        MathTransform mathTransform = this.gridToCRS;
        if (mathTransform == null && (gridGeometry = this.getGridGeometry(false)) != null) {
            PixelInCell pixelInCell = this.pixelAnchor;
            if (pixelInCell == null) {
                return gridGeometry.getGridToCRS();
            }
            if (gridGeometry instanceof GeneralGridGeometry) {
                return ((GeneralGridGeometry)gridGeometry).getGridToCRS(pixelInCell);
            }
        }
        return mathTransform;
    }

    public void setGridToCRS(MathTransform mathTransform) throws MismatchedDimensionException {
        if (mathTransform != null) {
            CoordinateReferenceSystem coordinateReferenceSystem = this.crs;
            GridEnvelope gridEnvelope = this.extent;
            if (gridEnvelope != null) {
                GridCoverageBuilder.ensureDimensionMatch("gridToCRS", mathTransform.getSourceDimensions(), gridEnvelope.getDimension());
            }
            Envelope envelope = this.envelope;
            if (coordinateReferenceSystem != null || envelope != null) {
                GridCoverageBuilder.ensureDimensionMatch("gridToCRS", mathTransform.getTargetDimensions(), coordinateReferenceSystem != null ? coordinateReferenceSystem.getCoordinateSystem().getDimension() : envelope.getDimension());
            }
        }
        this.gridToCRS = mathTransform;
        this.gridGeometryChanged();
    }

    public void setGridToCRS(Matrix matrix) throws MismatchedDimensionException {
        this.setGridToCRS((MathTransform)(matrix != null ? MathTransforms.linear((Matrix)matrix) : null));
    }

    public void setGridToCRS(AffineTransform affineTransform) throws MismatchedDimensionException {
        this.setGridToCRS((MathTransform)(affineTransform != null ? MathTransforms.linear((AffineTransform)affineTransform) : null));
    }

    public void setGridToCRS(double d, double d2, double d3, double d4, double d5, double d6) throws MismatchedDimensionException {
        this.setGridToCRS((MathTransform)new AffineTransform2D(d, d2, d3, d4, d5, d6));
    }

    public PixelInCell getPixelAnchor() {
        PixelInCell pixelInCell = this.pixelAnchor;
        return pixelInCell != null ? pixelInCell : PixelInCell.CELL_CENTER;
    }

    public void setPixelAnchor(PixelInCell pixelInCell) {
        this.pixelAnchor = pixelInCell;
        this.gridGeometryChanged();
    }

    public GridGeometry getGridGeometry() {
        return this.getGridGeometry(true);
    }

    private GridGeometry getGridGeometry(boolean bl) {
        GridGeometry gridGeometry = this.gridGeometry;
        if (gridGeometry == null && (gridGeometry = this.cachedGridGeometry) == null) {
            MathTransform mathTransform;
            GridEnvelope gridEnvelope = this.getExtent();
            if (bl && (mathTransform = this.getGridToCRS()) != null) {
                gridGeometry = new GridGeometry2D(gridEnvelope, this.getPixelAnchor(), mathTransform, this.getCoordinateReferenceSystem(), this.hints);
            } else {
                Envelope envelope = this.getEnvelope();
                if (gridEnvelope != null || envelope != null) {
                    gridGeometry = new GridGeometry2D(gridEnvelope, envelope);
                }
            }
            if (bl) {
                this.cachedGridGeometry = gridGeometry;
            }
        }
        return gridGeometry;
    }

    public void setGridGeometry(GridGeometry gridGeometry) {
        this.gridGeometry = gridGeometry;
        this.gridGeometryChanged();
    }

    private void gridGeometryChanged() {
        this.cachedGridGeometry = null;
        this.coverage = null;
    }

    final void sampleDimensionsChanged() {
        this.sampleDimensions = null;
        this.coverage = null;
    }

    public int getNumBands() {
        int n = this.numBands;
        if (n == 0) {
            SampleModel sampleModel;
            RenderedImage renderedImage = this.image;
            if (renderedImage != null && (sampleModel = renderedImage.getSampleModel()) != null) {
                return sampleModel.getNumBands();
            }
            n = 1;
        }
        return n;
    }

    public void setNumBands(int n) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive((String)"n", (int)n);
        Variable[] variableArray = this.variables;
        if (variableArray != null && n < variableArray.length) {
            Arrays.fill((Object[])variableArray, this.numBands, variableArray.length, null);
        }
        this.numBands = n;
        this.sampleDimensionsChanged();
    }

    public Variable variable(int n) throws IllegalArgumentException {
        ArgumentChecks.ensurePositive((String)"band", (int)n);
        Variable[] variableArray = this.variables;
        if (variableArray == null) {
            this.variables = variableArray = new Variable[Math.max(4, n + 1)];
        } else if (n >= variableArray.length) {
            this.variables = variableArray = Arrays.copyOf(variableArray, Math.max(variableArray.length * 2, n + 1));
        }
        Variable variable = variableArray[n];
        if (variable == null) {
            variableArray[n] = variable = this.newVariable(n);
        }
        if (n >= this.numBands) {
            this.numBands = n + 1;
        }
        return variable;
    }

    protected Variable newVariable(int n) {
        return new Variable(n);
    }

    final double[] getArrayProperty(String string) {
        Object object;
        RenderedImage renderedImage = this.image;
        if (renderedImage != null && (object = renderedImage.getProperty(string)) instanceof double[]) {
            return (double[])object;
        }
        return null;
    }

    private SampleDimension[] getDefaultSampleDimensions() {
        Object object;
        Color[][] colorArray = null;
        Unit[] unitArray = null;
        CharSequence[] charSequenceArray = null;
        int n = this.numBands;
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            Color[] colorArray2;
            object = this.variables[i];
            if (object == null) continue;
            Unit<?> unit = object.getUnit();
            if (unit != null) {
                if (unitArray == null) {
                    unitArray = new Unit[n];
                }
                unitArray[i] = unit;
            }
            if ((colorArray2 = object.getColors()) != null) {
                if (colorArray == null) {
                    colorArray = new Color[n][];
                }
                colorArray[i] = colorArray2;
            }
            if ((charSequence = object.getName()) == null) continue;
            if (charSequenceArray == null) {
                charSequenceArray = new CharSequence[n];
            }
            charSequenceArray[i] = charSequence;
        }
        double[] dArray = this.getArrayProperty("minimum");
        object = this.getArrayProperty("maximum");
        if (this.raster != null) {
            return RenderedSampleDimension.create(charSequenceArray, this.raster, dArray, (double[])object, unitArray, colorArray, (RenderingHints)this.hints);
        }
        if (this.image != null) {
            return RenderedSampleDimension.create(charSequenceArray, this.image, dArray, (double[])object, unitArray, colorArray, (RenderingHints)this.hints);
        }
        return null;
    }

    public SampleDimension[] getSampleDimensions() {
        SampleDimension[] sampleDimensionArray = this.sampleDimensions;
        if (sampleDimensionArray == null) {
            int n;
            int n2 = n = this.numBands;
            while (--n2 >= 0) {
                SampleDimension sampleDimension = this.variable(n2).getSampleDimension();
                if (sampleDimension == null) continue;
                if (sampleDimension instanceof GridSampleDimension) {
                    if (sampleDimensionArray == null) {
                        sampleDimensionArray = new GridSampleDimension[n];
                    }
                } else if (sampleDimensionArray == null) {
                    sampleDimensionArray = new SampleDimension[n];
                } else if (sampleDimensionArray instanceof GridSampleDimension[]) {
                    SampleDimension[] sampleDimensionArray2 = sampleDimensionArray;
                    sampleDimensionArray = new SampleDimension[n];
                    System.arraycopy(sampleDimensionArray2, 0, sampleDimensionArray, 0, n);
                }
                sampleDimensionArray[n2] = sampleDimension;
            }
            if (sampleDimensionArray == null) {
                sampleDimensionArray = this.getDefaultSampleDimensions();
            } else if (sampleDimensionArray instanceof GridSampleDimension[]) {
                n2 = this.isGeophysics() ? 1 : 0;
                for (int i = 0; i < sampleDimensionArray.length; ++i) {
                    sampleDimensionArray[i] = ((GridSampleDimension[])sampleDimensionArray)[i].geophysics(n2 != 0);
                }
            }
            this.sampleDimensions = sampleDimensionArray;
        }
        return sampleDimensionArray != null ? (SampleDimension[])sampleDimensionArray.clone() : null;
    }

    public void setSampleDimensions(SampleDimension ... sampleDimensionArray) {
        this.setNumBands(sampleDimensionArray != null ? sampleDimensionArray.length : 0);
        if (sampleDimensionArray != null) {
            for (int i = 0; i < sampleDimensionArray.length; ++i) {
                this.variable(i).setSampleDimension(sampleDimensionArray[i]);
            }
        }
    }

    public void setSampleDimensions(double[] dArray, double[] dArray2, Unit<?> unit, Color[] ... colorArray) {
        int n = 0;
        if (dArray != null) {
            n = dArray.length;
        }
        if (dArray2 != null) {
            n = Math.max(n, dArray2.length);
        }
        if (colorArray != null) {
            n = Math.max(n, colorArray.length);
        }
        for (int i = 0; i < n; ++i) {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            Variable variable = this.variable(i);
            if (dArray != null && i < dArray.length) {
                d = dArray[i];
            }
            if (dArray2 != null && i < dArray2.length) {
                d2 = dArray2[i];
            }
            if (d != Double.NEGATIVE_INFINITY || d2 != Double.POSITIVE_INFINITY) {
                variable.setSampleRange(NumberRange.create((double)d, (double)d2));
            }
            if (colorArray != null && i < colorArray.length) {
                variable.setColors(colorArray[i]);
            }
            variable.setUnit(unit);
        }
    }

    public ColorModel getColorModel() {
        RenderedImage renderedImage;
        ColorModel colorModel = null;
        SampleDimension[] sampleDimensionArray = this.getSampleDimensions();
        if (sampleDimensionArray != null) {
            for (int i = 0; i < sampleDimensionArray.length; ++i) {
                int n;
                SampleDimension sampleDimension = sampleDimensionArray[i];
                if (!(sampleDimension instanceof GridSampleDimension) || (colorModel = (n = this.getDataType()) != 32 ? ((GridSampleDimension)sampleDimension).getColorModel(i, sampleDimensionArray.length, n) : ((GridSampleDimension)sampleDimension).getColorModel(i, sampleDimensionArray.length)) == null) continue;
                return colorModel;
            }
        }
        if ((renderedImage = this.image) != null) {
            colorModel = renderedImage.getColorModel();
        }
        return colorModel;
    }

    private int getDataType() {
        SampleModel sampleModel = null;
        if (this.image != null) {
            sampleModel = this.image.getSampleModel();
        }
        if (sampleModel == null && this.raster != null) {
            sampleModel = this.raster.getSampleModel();
        }
        return sampleModel != null ? sampleModel.getDataType() : 32;
    }

    private boolean isGeophysics() {
        switch (this.getDataType()) {
            case 4: 
            case 5: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        boolean bl = false;
        int n = this.numBands;
        while (--n >= 0) {
            SampleDimension sampleDimension = this.variable((int)n).sampleDimension;
            if (sampleDimension == null) continue;
            MathTransform1D mathTransform1D = sampleDimension.getSampleToGeophysics();
            if (mathTransform1D == null || !mathTransform1D.isIdentity()) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public Graphics createGraphics(boolean bl) throws UnsupportedOperationException {
        Graphics graphics;
        RenderedImage renderedImage = this.getRenderedImage();
        while (renderedImage instanceof RenderedImageAdapter) {
            renderedImage = ((RenderedImageAdapter)renderedImage).getWrappedImage();
        }
        if (renderedImage instanceof Image) {
            graphics = ((Image)((Object)renderedImage)).getGraphics();
        } else if (renderedImage instanceof PlanarImage) {
            graphics = ((PlanarImage)renderedImage).getGraphics();
        } else {
            throw new UnsupportedOperationException(Errors.format((int)253));
        }
        if (bl) {
            AffineTransform affineTransform = this.getAffineGridToCRS(PixelOrientation.UPPER_LEFT, true);
            if (affineTransform == null) {
                throw new IllegalStateException(Errors.format((int)236));
            }
            try {
                ((Graphics2D)graphics).transform(affineTransform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new IllegalArgumentException(Errors.format((int)126), noninvertibleTransformException);
            }
            catch (ClassCastException classCastException) {
                throw new UnsupportedOperationException(Errors.format((int)253), classCastException);
            }
        }
        return graphics;
    }

    public Rectangle getImageBounds() throws InvalidGridGeometryException {
        GridGeometry2D gridGeometry2D = GridGeometry2D.castOrCopy(this.getGridGeometry());
        if (gridGeometry2D != null) {
            return gridGeometry2D.getExtent2D();
        }
        RenderedImage renderedImage = this.image;
        if (renderedImage != null) {
            return ImageUtilities.getBounds(renderedImage);
        }
        throw new InvalidGridGeometryException(235);
    }

    public Dimension getTileSize() {
        Object object;
        TileLayout tileLayout = this.tileLayout;
        if (tileLayout != null && (object = tileLayout.getSize()) != null) {
            return object;
        }
        object = this.image;
        if (object != null) {
            int n = object.getTileWidth();
            int n2 = object.getTileHeight();
            if (n < object.getWidth() || n2 < object.getHeight()) {
                return new Dimension(n, n2);
            }
        }
        return null;
    }

    public void setTileSize(Dimension dimension) {
        TileLayout tileLayout = this.tileLayout;
        if (tileLayout != null) {
            tileLayout.setSize(dimension);
        } else if (dimension != null) {
            this.tileLayout = new TileLayout(dimension);
        }
    }

    public Point getTileGridOffset() {
        TileLayout tileLayout = this.tileLayout;
        if (tileLayout != null) {
            return tileLayout.getLocation();
        }
        RenderedImage renderedImage = this.image;
        if (renderedImage != null && ImageUtilities.isTiled(renderedImage)) {
            return new Point(renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset());
        }
        return null;
    }

    public void setTileGridOffset(Point point) {
        TileLayout tileLayout = this.tileLayout;
        if (tileLayout != null) {
            tileLayout.setLocation(point);
        } else if (point != null) {
            this.tileLayout = new TileLayout(point);
        }
    }

    public RenderedImage getRenderedImage() {
        if (this.image == null) {
            Point point;
            Rectangle rectangle = this.getImageBounds();
            Dimension dimension = this.getTileSize();
            if (dimension != null && dimension.width >= rectangle.width && dimension.height >= rectangle.height) {
                dimension = null;
            }
            if ((point = this.getTileGridOffset()) != null && point.x == rectangle.x && point.y == rectangle.y) {
                point = null;
            }
            ColorModel colorModel = this.getColorModel();
            if (dimension == null && point == null && rectangle.x == 0 && rectangle.y == 0) {
                this.image = colorModel == null ? new BufferedImage(rectangle.width, rectangle.height, 10) : new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height), false, null);
            } else {
                if (colorModel == null) {
                    colorModel = PlanarImage.getDefaultColorModel((int)0, (int)this.getNumBands());
                }
                this.image = new TiledImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height, point != null ? point.x : rectangle.x, point != null ? point.y : rectangle.y, colorModel.createCompatibleSampleModel(dimension != null ? dimension.width : rectangle.width, dimension != null ? dimension.height : rectangle.height), colorModel);
            }
        }
        return this.image;
    }

    public void setRenderedImage(RenderedImage renderedImage) {
        this.image = renderedImage;
        this.raster = null;
        this.coverage = null;
    }

    public void setRenderedImage(WritableRaster writableRaster) {
        this.image = null;
        this.raster = writableRaster;
        BufferedImage bufferedImage = null;
        if (writableRaster != null) {
            ColorModel colorModel = this.getColorModel();
            if (colorModel == null) {
                colorModel = PlanarImage.getDefaultColorModel((int)this.getDataType(), (int)writableRaster.getNumBands());
            }
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
        }
        this.setRenderedImage(bufferedImage);
    }

    /*
     * WARNING - void declaration
     */
    public void setRenderedImage(float[][] fArray) {
        WritableRaster writableRaster = null;
        if (fArray != null) {
            void var7_9;
            int n = 0;
            int n2 = fArray.length;
            float[][] object = fArray;
            int n3 = object.length;
            boolean object2 = false;
            while (var7_9 < n3) {
                float[] fArray2 = object[var7_9];
                if (fArray2 != null && fArray2.length > n) {
                    n = fArray2.length;
                }
                ++var7_9;
            }
            float[] fArray3 = new float[n * n2];
            n3 = 0;
            for (float[] fArray4 : fArray) {
                int n4 = 0;
                if (fArray4 != null) {
                    n4 = fArray4.length;
                    System.arraycopy(fArray4, 0, fArray3, n3, n4);
                }
                Arrays.fill(fArray3, n3 + n4, n3 += n, Float.NaN);
            }
            int[] nArray = new int[1];
            writableRaster = RasterFactory.createBandedRaster((DataBuffer)new DataBufferFloat(fArray3, fArray3.length), (int)n, (int)n2, (int)n, (int[])nArray, (int[])nArray, null);
        }
        this.setRenderedImage(writableRaster);
    }

    public void setRenderedImage(ImageFunction imageFunction) {
        RenderedOp renderedOp = null;
        if (imageFunction != null) {
            AffineTransform affineTransform = this.getAffineGridToCRS(PixelOrientation.CENTER, true);
            if (affineTransform == null) {
                throw new IllegalStateException(Errors.format((int)236));
            }
            if (affineTransform.getShearX() != 0.0 || affineTransform.getShearY() != 0.0) {
                throw new IllegalArgumentException("Shear and rotation not supported");
            }
            double d = affineTransform.getScaleX();
            double d2 = affineTransform.getScaleY();
            double d3 = -affineTransform.getTranslateX() / d;
            double d4 = -affineTransform.getTranslateY() / d2;
            GridEnvelope gridEnvelope = this.gridGeometry.getExtent();
            renderedOp = ImageFunctionDescriptor.create((ImageFunction)imageFunction, (Integer)gridEnvelope.getSpan(0), (Integer)gridEnvelope.getSpan(1), (Float)Float.valueOf((float)d), (Float)Float.valueOf((float)d2), (Float)Float.valueOf((float)d3), (Float)Float.valueOf((float)d4), (RenderingHints)this.hints);
        }
        this.setRenderedImage((RenderedImage)renderedOp);
    }

    public GridCoverage2D getGridCoverage2D() {
        if (this.coverage == null) {
            GridSampleDimension[] gridSampleDimensionArray;
            SampleDimension[] sampleDimensionArray = this.getSampleDimensions();
            if (sampleDimensionArray == null || sampleDimensionArray instanceof GridSampleDimension[]) {
                gridSampleDimensionArray = (GridSampleDimension[])sampleDimensionArray;
            } else {
                gridSampleDimensionArray = new GridSampleDimension[sampleDimensionArray.length];
                for (int i = 0; i < gridSampleDimensionArray.length; ++i) {
                    gridSampleDimensionArray[i] = GridSampleDimension.castOrCopy(sampleDimensionArray[i]);
                }
            }
            this.coverage = new GridCoverage2D(this.getName(), (RenderedImage)PlanarImage.wrapRenderedImage((RenderedImage)this.getRenderedImage()), GridGeometry2D.castOrCopy(this.getGridGeometry()), gridSampleDimensionArray, this.getSources(), this.getProperties(), this.hints);
        }
        return this.coverage;
    }

    public void setGridCoverage(GridCoverage gridCoverage) {
        this.setCoordinateReferenceSystem(gridCoverage.getCoordinateReferenceSystem());
        GridGeometry gridGeometry = gridCoverage.getGridGeometry();
        this.setGridGeometry(gridGeometry);
        SampleDimension[] sampleDimensionArray = new SampleDimension[gridCoverage.getNumSampleDimensions()];
        for (int i = 0; i < sampleDimensionArray.length; ++i) {
            sampleDimensionArray[i] = gridCoverage.getSampleDimension(i);
        }
        this.setSampleDimensions(sampleDimensionArray);
        List list = gridCoverage.getSources();
        if (list != null) {
            this.setSources(list.toArray(new GridCoverage[list.size()]));
        }
        if (gridCoverage instanceof PropertySource) {
            this.setProperties((PropertySource)gridCoverage);
        }
        if (gridCoverage instanceof GridCoverage2D) {
            GridCoverage2D gridCoverage2D = (GridCoverage2D)gridCoverage;
            this.setName((CharSequence)gridCoverage2D.getName());
            this.setRenderedImage(gridCoverage2D.getRenderedImage());
            this.coverage = gridCoverage2D;
        } else {
            Object object;
            int n = 0;
            int n2 = 1;
            if (gridGeometry instanceof GridGeometry2D) {
                object = (GridGeometry2D)gridGeometry;
                n = ((GridGeometry2D)object).gridDimensionX;
                n2 = ((GridGeometry2D)object).gridDimensionY;
            }
            if ((object = gridCoverage.getRenderableImage(n, n2)) != null) {
                this.setRenderedImage(object.createDefaultRendering());
            }
        }
        if (gridGeometry != null) {
            this.setExtent(gridGeometry.getExtent());
            this.setGridToCRS(gridGeometry.getGridToCRS());
            this.gridGeometry = null;
            this.cachedGridGeometry = gridGeometry;
        }
    }

    public GridCoverage[] getSources() {
        return this.sources;
    }

    public void setSources(GridCoverage ... gridCoverageArray) {
        if (gridCoverageArray != null && gridCoverageArray.length == 0) {
            gridCoverageArray = null;
        }
        this.sources = gridCoverageArray;
    }

    public Map<?, ?> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<?, ?> map) {
        this.properties = map;
    }

    public void setProperties(PropertySource propertySource) {
        String[] stringArray;
        LinkedHashMap<String, Object> linkedHashMap = null;
        if (propertySource != null && (stringArray = propertySource.getPropertyNames()) != null && stringArray.length != 0) {
            linkedHashMap = new LinkedHashMap<String, Object>();
            for (String string : stringArray) {
                linkedHashMap.put(string, propertySource.getProperty(string));
            }
        }
        this.setProperties(linkedHashMap);
    }

    public GridCoverage build() {
        return this.getGridCoverage2D();
    }

    public void reset() {
        this.name = null;
        this.crs = null;
        this.envelope = null;
        this.extent = null;
        this.gridToCRS = null;
        this.pixelAnchor = null;
        this.gridGeometry = null;
        this.cachedGridGeometry = null;
        this.sampleDimensions = null;
        this.raster = null;
        this.image = null;
        this.coverage = null;
        this.sources = null;
        this.properties = null;
        this.numBands = 0;
        if (this.variables != null) {
            Arrays.fill((Object[])this.variables, null);
        }
        if (this.tileLayout != null) {
            this.tileLayout.reset();
        }
    }

    public class Variable
    extends Builder<SampleDimension> {
        protected final int band;
        protected CharSequence name;
        protected Unit<?> unit;
        protected NumberRange<?> sampleRange;
        protected NumberRange<?> geophysicsRange;
        private Map<Integer, NoData> nodata;
        protected MathTransform1D sampleToUnit;
        protected Color[] colors;
        protected SampleDimension sampleDimension;
        private transient SampleDimension cached;

        protected Variable(int n) {
            this.band = n;
        }

        private void sampleDimensionsChanged() {
            this.cached = null;
            GridCoverageBuilder.this.sampleDimensionsChanged();
        }

        public CharSequence getName() {
            CharSequence charSequence = this.name;
            if (charSequence == null) {
                SampleDimension sampleDimension = this.sampleDimension;
                if (sampleDimension != null && (charSequence = sampleDimension.getDescription()) != null) {
                    return charSequence;
                }
                charSequence = GridCoverageBuilder.this.name;
            }
            return charSequence;
        }

        public void setName(CharSequence charSequence) {
            this.name = charSequence;
            this.sampleDimensionsChanged();
        }

        public Unit<?> getUnit() {
            SampleDimension sampleDimension;
            Unit unit = this.unit;
            if (unit == null && (sampleDimension = this.sampleDimension) != null) {
                unit = sampleDimension.getUnits();
            }
            return unit;
        }

        public void setUnit(Unit<?> unit) {
            this.unit = unit;
            this.sampleDimensionsChanged();
        }

        public void setUnit(String string) {
            this.setUnit(Units.valueOf((String)string));
        }

        public NumberRange<?> getSampleRange() {
            double[] dArray;
            double[] dArray2;
            SampleDimension sampleDimension;
            NumberRange numberRange = this.sampleRange;
            if (numberRange == null && (sampleDimension = this.sampleDimension) instanceof GridSampleDimension && (numberRange = ((GridSampleDimension)sampleDimension).getRange()) == null && (dArray2 = GridCoverageBuilder.this.getArrayProperty("minimum")) != null && dArray2.length > this.band && (dArray = GridCoverageBuilder.this.getArrayProperty("maximum")) != null && dArray.length > this.band) {
                numberRange = NumberRange.create((double)dArray2[this.band], (double)dArray[this.band]);
            }
            return numberRange;
        }

        public void setSampleRange(NumberRange<?> numberRange) {
            this.sampleRange = numberRange;
            this.sampleDimensionsChanged();
        }

        public void setSampleRange(int n, int n2) {
            this.setSampleRange(NumberRange.create((int)n, (boolean)true, (int)n2, (boolean)false));
        }

        public NumberRange<?> getGeophysicsRange() {
            SampleDimension sampleDimension;
            NumberRange<?> numberRange = this.geophysicsRange;
            if (numberRange == null && (sampleDimension = this.sampleDimension) instanceof GridSampleDimension) {
                numberRange = ((GridSampleDimension)sampleDimension).geophysics(true).getRange();
            }
            return numberRange;
        }

        public void setGeophysicsRange(NumberRange<?> numberRange) {
            this.geophysicsRange = numberRange;
            this.sampleDimensionsChanged();
        }

        public void setGeophysicsRange(double d, double d2) {
            this.setGeophysicsRange(NumberRange.create((double)d, (boolean)true, (double)d2, (boolean)false));
        }

        public MathTransform1D getSampleToUnit() {
            SampleDimension sampleDimension;
            MathTransform1D mathTransform1D = this.sampleToUnit;
            if (mathTransform1D == null && (sampleDimension = this.sampleDimension) != null) {
                mathTransform1D = sampleDimension.getSampleToGeophysics();
            }
            return mathTransform1D;
        }

        public void setSampleToUnit(MathTransform1D mathTransform1D) {
            this.sampleToUnit = mathTransform1D;
            this.sampleDimensionsChanged();
        }

        public void setLinearTransform(double d, double d2) {
            this.setSampleToUnit((MathTransform1D)LinearTransform1D.create((double)d, (double)d2));
        }

        public void setLogarithmicTransform(double d, double d2) {
            this.setSampleToUnit(LogarithmicTransform1D.create((double)d, (double)d2));
        }

        public void addNodataValue(CharSequence charSequence, int n, Color color) throws IllegalArgumentException {
            Integer n2;
            NoData noData;
            if (this.nodata == null) {
                this.nodata = new TreeMap<Integer, NoData>();
            }
            if ((noData = this.nodata.put(n2 = Integer.valueOf(n), new NoData(charSequence, color))) != null) {
                this.nodata.put(n2, noData);
                throw new IllegalArgumentException(Errors.format((int)245, (Object)n2));
            }
            this.sampleDimensionsChanged();
        }

        public Color[] getColors() {
            return this.colors;
        }

        public void setColors(Color ... colorArray) {
            if (colorArray != null && colorArray.length == 0) {
                colorArray = null;
            }
            this.colors = colorArray;
            this.sampleDimensionsChanged();
        }

        public void setColors(String string) {
            try {
                this.setColors(PaletteFactory.getDefault().getColors(string));
            }
            catch (IOException iOException) {
                throw new BackingStoreException((Throwable)iOException);
            }
        }

        /*
         * WARNING - void declaration
         */
        public SampleDimension getSampleDimension() {
            SampleDimension sampleDimension = this.sampleDimension;
            if (sampleDimension == null && (sampleDimension = this.cached) == null) {
                Category[] categoryArray;
                int n = 0;
                CharSequence charSequence = this.getName();
                NumberRange<?> numberRange = this.getSampleRange();
                Map<Integer, NoData> map = this.nodata;
                if (XCollections.isNullOrEmpty(map)) {
                    categoryArray = numberRange != null ? new Category[1] : null;
                } else {
                    categoryArray = new Category[map.size() + (numberRange != null ? 1 : 0)];
                    for (Map.Entry object : map.entrySet()) {
                        Object object2;
                        int n2 = (Integer)object.getKey();
                        if (numberRange != null && numberRange.contains((Comparable)(object2 = Integer.valueOf(n2)))) {
                            throw new IllegalStateException(Errors.format((int)245, (Object)object2));
                        }
                        object2 = (NoData)object.getValue();
                        categoryArray[n++] = new Category(((NoData)object2).name, ((NoData)object2).color, n2);
                    }
                }
                if (numberRange != null) {
                    void var8_11;
                    Color[] colorArray = this.getColors();
                    MathTransform1D mathTransform1D = this.getSampleToUnit();
                    if (mathTransform1D == null) {
                        NumberRange<?> numberRange2 = this.getGeophysicsRange();
                        if (numberRange2 == null) {
                            LinearTransform1D linearTransform1D = LinearTransform1D.IDENTITY;
                        } else {
                            categoryArray[n] = new Category(charSequence, colorArray, numberRange, numberRange2);
                        }
                    }
                    if (var8_11 != null) {
                        categoryArray[n] = new Category(charSequence, colorArray, numberRange, (MathTransform1D)var8_11);
                    }
                }
                if (categoryArray != null || this.name != null) {
                    this.cached = sampleDimension = new GridSampleDimension(charSequence, categoryArray, this.getUnit());
                }
            }
            return sampleDimension;
        }

        public void setSampleDimension(SampleDimension sampleDimension) {
            this.sampleDimension = sampleDimension;
            this.sampleDimensionsChanged();
        }

        public SampleDimension build() {
            return this.getSampleDimension();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName());
            stringBuilder.append('[');
            if (this.name != null) {
                stringBuilder.append('\"').append(this.name).append('\"');
                if (this.unit != null) {
                    stringBuilder.append(' ');
                }
            }
            if (this.unit != null) {
                stringBuilder.append('(').append(this.unit).append(')');
            }
            return stringBuilder.append(']').toString();
        }
    }

    private static final class NoData {
        final CharSequence name;
        final Color color;

        NoData(CharSequence charSequence, Color color) {
            this.name = charSequence;
            this.color = color;
        }
    }

    private static final class TileLayout
    extends Rectangle {
        private boolean hasOffset;

        TileLayout(Point point) {
            super(point);
            this.hasOffset = true;
        }

        TileLayout(Dimension dimension) {
            super(dimension);
        }

        public void reset() {
            this.x = 0;
            this.y = 0;
            this.width = 0;
            this.height = 0;
            this.hasOffset = false;
        }

        @Override
        public Point getLocation() {
            return this.hasOffset ? super.getLocation() : null;
        }

        @Override
        public void setLocation(Point point) {
            this.hasOffset = point != null;
            if (this.hasOffset) {
                super.setLocation(point);
            }
        }

        @Override
        public Dimension getSize() {
            return this.width > 0 && this.height > 0 ? super.getSize() : null;
        }

        @Override
        public void setSize(Dimension dimension) {
            if (dimension != null) {
                ArgumentChecks.ensureStrictlyPositive((String)"width", (int)dimension.width);
                ArgumentChecks.ensureStrictlyPositive((String)"height", (int)dimension.height);
                super.setSize(dimension);
            } else {
                this.width = 0;
                this.height = 0;
            }
        }
    }
}

