/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.util.ArgumentChecks;
import org.geotoolkit.coverage.grid.GeneralGridEnvelope;
import org.geotoolkit.coverage.grid.InvalidGridGeometryException;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.geometry.ImmutableEnvelope;
import org.geotoolkit.metadata.iso.spatial.PixelTranslation;
import org.geotoolkit.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

@Immutable
public class GeneralGridGeometry
implements GridGeometry,
Serializable {
    private static final long serialVersionUID = 670887173069270234L;
    private static final int ULP_TOLERANCE = 16;
    public static final int CRS = 1;
    public static final int ENVELOPE = 2;
    public static final int EXTENT = 4;
    public static final int GRID_TO_CRS = 8;
    protected final GridEnvelope extent;
    protected final ImmutableEnvelope envelope;
    protected final MathTransform gridToCRS;
    private MathTransform cornerToCRS;
    private transient double[] resolution;

    GeneralGridGeometry(GeneralGridGeometry generalGridGeometry, CoordinateReferenceSystem coordinateReferenceSystem) {
        this.extent = generalGridGeometry.extent;
        this.gridToCRS = generalGridGeometry.gridToCRS;
        this.cornerToCRS = generalGridGeometry.cornerToCRS;
        this.envelope = new ImmutableEnvelope(coordinateReferenceSystem, (Envelope)generalGridGeometry.envelope);
    }

    public GeneralGridGeometry(GridGeometry gridGeometry) {
        if (gridGeometry instanceof GeneralGridGeometry) {
            GeneralGridGeometry generalGridGeometry = (GeneralGridGeometry)gridGeometry;
            this.extent = generalGridGeometry.extent;
            this.gridToCRS = generalGridGeometry.gridToCRS;
            this.cornerToCRS = generalGridGeometry.cornerToCRS;
            this.envelope = generalGridGeometry.envelope;
        } else {
            GeneralEnvelope generalEnvelope = null;
            this.extent = gridGeometry.getExtent();
            this.gridToCRS = gridGeometry.getGridToCRS();
            if (this.extent != null && this.gridToCRS != null) {
                generalEnvelope = new GeneralEnvelope(this.extent, PixelInCell.CELL_CENTER, this.gridToCRS, null);
                generalEnvelope.roundIfAlmostInteger(360.0, 16);
            }
            this.envelope = generalEnvelope != null ? new ImmutableEnvelope(generalEnvelope) : null;
        }
    }

    public GeneralGridGeometry(GridEnvelope gridEnvelope, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException, IllegalArgumentException {
        this(gridEnvelope, PixelInCell.CELL_CENTER, mathTransform, coordinateReferenceSystem);
    }

    public GeneralGridGeometry(GridEnvelope gridEnvelope, PixelInCell pixelInCell, MathTransform mathTransform, CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException, IllegalArgumentException {
        if (mathTransform != null) {
            if (gridEnvelope != null) {
                GeneralGridGeometry.ensureDimensionMatch("extent", gridEnvelope.getDimension(), mathTransform.getSourceDimensions());
            }
            if (coordinateReferenceSystem != null) {
                GeneralGridGeometry.ensureDimensionMatch("crs", coordinateReferenceSystem.getCoordinateSystem().getDimension(), mathTransform.getTargetDimensions());
            }
        }
        this.extent = GeneralGridGeometry.clone(gridEnvelope);
        this.gridToCRS = PixelTranslation.translate((MathTransform)mathTransform, (PixelInCell)pixelInCell, (PixelInCell)PixelInCell.CELL_CENTER);
        if (PixelInCell.CELL_CORNER.equals((Object)pixelInCell)) {
            this.cornerToCRS = mathTransform;
        }
        GeneralEnvelope generalEnvelope = null;
        if (gridEnvelope != null && mathTransform != null) {
            generalEnvelope = new GeneralEnvelope(gridEnvelope, pixelInCell, mathTransform, coordinateReferenceSystem);
            generalEnvelope.roundIfAlmostInteger(360.0, 16);
        } else if (coordinateReferenceSystem != null) {
            generalEnvelope = new GeneralEnvelope(coordinateReferenceSystem);
            generalEnvelope.setToNull();
        }
        this.envelope = generalEnvelope != null ? new ImmutableEnvelope((Envelope)generalEnvelope) : null;
    }

    public GeneralGridGeometry(PixelInCell pixelInCell, MathTransform mathTransform, Envelope envelope) throws MismatchedDimensionException, IllegalArgumentException {
        GeneralEnvelope generalEnvelope;
        if (mathTransform != null && envelope != null) {
            GeneralGridGeometry.ensureDimensionMatch("envelope", envelope.getDimension(), mathTransform.getTargetDimensions());
        }
        this.gridToCRS = PixelTranslation.translate((MathTransform)mathTransform, (PixelInCell)pixelInCell, (PixelInCell)PixelInCell.CELL_CENTER);
        if (PixelInCell.CELL_CORNER.equals((Object)pixelInCell)) {
            this.cornerToCRS = mathTransform;
        }
        this.envelope = ImmutableEnvelope.castOrCopy((Envelope)envelope);
        if (envelope == null) {
            this.extent = null;
            return;
        }
        if (mathTransform == null) {
            this.extent = null;
            return;
        }
        try {
            generalEnvelope = Envelopes.transform((MathTransform)mathTransform.inverse(), (Envelope)envelope);
        }
        catch (TransformException transformException) {
            throw new IllegalArgumentException(Errors.format((int)16, mathTransform.getClass()), transformException);
        }
        this.extent = new GeneralGridEnvelope((Envelope)generalEnvelope, pixelInCell, false);
    }

    public GeneralGridGeometry(GridEnvelope gridEnvelope, Envelope envelope) throws MismatchedDimensionException {
        this(gridEnvelope, envelope, null, false, true);
    }

    GeneralGridGeometry(GridEnvelope gridEnvelope, Envelope envelope, boolean[] blArray, boolean bl, boolean bl2) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull((String)"extent", (Object)gridEnvelope);
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        this.extent = GeneralGridGeometry.clone(gridEnvelope);
        this.envelope = ImmutableEnvelope.castOrCopy((Envelope)envelope);
        GridToEnvelopeMapper gridToEnvelopeMapper = new GridToEnvelopeMapper(gridEnvelope, envelope);
        if (!bl2) {
            gridToEnvelopeMapper.setReverseAxis(blArray);
            gridToEnvelopeMapper.setSwapXY(bl);
        }
        this.gridToCRS = gridToEnvelopeMapper.createTransform();
    }

    private static GridEnvelope clone(GridEnvelope gridEnvelope) {
        if (gridEnvelope instanceof Cloneable) {
            gridEnvelope = (GridEnvelope)((Cloneable)gridEnvelope).clone();
        }
        return gridEnvelope;
    }

    static void ensureDimensionMatch(String string, int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((int)113, (Object)string, (Object)n, (Object)n2));
        }
    }

    public int getDimension() {
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        return this.extent.getDimension();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() throws InvalidGridGeometryException {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (this.envelope != null && (coordinateReferenceSystem = this.envelope.getCoordinateReferenceSystem()) != null) {
            assert (this.isDefined(1));
            return coordinateReferenceSystem;
        }
        assert (!this.isDefined(1));
        throw new InvalidGridGeometryException(234);
    }

    public Envelope getEnvelope() throws InvalidGridGeometryException {
        if (this.envelope != null && !this.envelope.isAllNaN()) {
            assert (this.isDefined(2));
            return this.envelope;
        }
        assert (!this.isDefined(2));
        throw new InvalidGridGeometryException(this.gridToCRS == null ? 236 : 235);
    }

    public GridEnvelope getExtent() throws InvalidGridGeometryException {
        return this.getGridRange();
    }

    @Deprecated
    public GridEnvelope getGridRange() throws InvalidGridGeometryException {
        if (this.extent != null) {
            assert (this.isDefined(4));
            return GeneralGridGeometry.clone(this.extent);
        }
        assert (!this.isDefined(4));
        throw new InvalidGridGeometryException(235);
    }

    public MathTransform getGridToCRS() throws InvalidGridGeometryException {
        if (this.gridToCRS != null) {
            assert (this.isDefined(8));
            return this.gridToCRS;
        }
        assert (!this.isDefined(8));
        throw new InvalidGridGeometryException(236);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransform getGridToCRS(PixelInCell pixelInCell) throws InvalidGridGeometryException {
        if (this.gridToCRS == null) {
            throw new InvalidGridGeometryException(236);
        }
        if (PixelInCell.CELL_CENTER.equals((Object)pixelInCell)) {
            return this.gridToCRS;
        }
        if (PixelInCell.CELL_CORNER.equals((Object)pixelInCell)) {
            GeneralGridGeometry generalGridGeometry = this;
            synchronized (generalGridGeometry) {
                if (this.cornerToCRS == null) {
                    this.cornerToCRS = PixelTranslation.translate((MathTransform)this.gridToCRS, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)pixelInCell);
                }
            }
            assert (!this.cornerToCRS.equals(this.gridToCRS)) : this.cornerToCRS;
            return this.cornerToCRS;
        }
        return PixelTranslation.translate((MathTransform)this.gridToCRS, (PixelInCell)PixelInCell.CELL_CENTER, (PixelInCell)pixelInCell);
    }

    public synchronized double[] getResolution() {
        double[] dArray = this.resolution;
        if (dArray == null && this.gridToCRS instanceof LinearTransform) {
            Matrix matrix = ((LinearTransform)this.gridToCRS).getMatrix();
            dArray = new double[matrix.getNumRow() - 1];
            double[] dArray2 = new double[matrix.getNumCol() - 1];
            for (int i = 0; i < dArray.length; ++i) {
                for (int j = 0; j < dArray2.length; ++j) {
                    dArray2[j] = matrix.getElement(i, j);
                }
                dArray[i] = MathFunctions.magnitude((double[])dArray2);
            }
            this.resolution = dArray;
        }
        return dArray != null ? (double[])dArray.clone() : null;
    }

    public boolean isDefined(int n) throws IllegalArgumentException {
        if ((n & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException(Errors.format((int)73, (Object)"bitmask", (Object)n));
        }
        return !((n & 1) != 0 && (this.envelope == null || this.envelope.getCoordinateReferenceSystem() == null) || (n & 2) != 0 && (this.envelope == null || this.envelope.isAllNaN()) || (n & 4) != 0 && this.extent == null || (n & 8) != 0 && this.gridToCRS == null);
    }

    public int hashCode() {
        int n = 1395191002;
        if (this.gridToCRS != null) {
            n += this.gridToCRS.hashCode();
        }
        if (this.extent != null) {
            n += this.extent.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            GeneralGridGeometry generalGridGeometry = (GeneralGridGeometry)object;
            return Utilities.equals((Object)this.extent, (Object)generalGridGeometry.extent) && Utilities.equals((Object)this.gridToCRS, (Object)generalGridGeometry.gridToCRS) && Utilities.equals((Object)this.envelope, (Object)generalGridGeometry.envelope);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.extent + ", " + this.gridToCRS + ']';
    }
}

