/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.converter.Classes;
import org.opengis.coverage.grid.GridCoordinates;

public class GeneralGridCoordinates
implements GridCoordinates,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8146318677770695383L;
    final int[] coordinates;

    public GeneralGridCoordinates(int n) {
        this.coordinates = new int[n];
    }

    public GeneralGridCoordinates(int[] nArray) {
        this.coordinates = (int[])nArray.clone();
    }

    public GeneralGridCoordinates(int[] nArray, int n, int n2) {
        this.coordinates = Arrays.copyOfRange(nArray, n, n2);
    }

    public GeneralGridCoordinates(GridCoordinates gridCoordinates) {
        this.coordinates = gridCoordinates.getCoordinateValues();
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public int[] getCoordinateValues() {
        return (int[])this.coordinates.clone();
    }

    public int getCoordinateValue(int n) throws ArrayIndexOutOfBoundsException {
        return this.coordinates[n];
    }

    public void setCoordinateValue(int n, int n2) throws ArrayIndexOutOfBoundsException, UnsupportedOperationException {
        this.coordinates[n] = n2;
    }

    static String toString(GridCoordinates gridCoordinates) {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName((Object)gridCoordinates));
        int n = gridCoordinates.getDimension();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(i == 0 ? (char)'[' : ',').append(gridCoordinates.getCoordinateValue(i));
        }
        return stringBuilder.append(']').toString();
    }

    public String toString() {
        return GeneralGridCoordinates.toString(this);
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) ^ 0x27A6F2D7;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GeneralGridCoordinates) {
            GeneralGridCoordinates generalGridCoordinates = (GeneralGridCoordinates)object;
            return Arrays.equals(this.coordinates, generalGridCoordinates.coordinates);
        }
        return false;
    }

    public GeneralGridCoordinates clone() {
        try {
            return (GeneralGridCoordinates)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static final class Immutable
    extends GeneralGridCoordinates {
        private static final long serialVersionUID = -7723383411061425866L;

        public Immutable(int[] nArray) {
            super(nArray);
        }

        public Immutable(int[] nArray, int n, int n2) {
            super(nArray, n, n2);
        }

        public Immutable(GridCoordinates gridCoordinates) {
            super(gridCoordinates);
        }

        final void decrement() {
            int n = 0;
            while (n < this.coordinates.length) {
                int n2 = n++;
                this.coordinates[n2] = this.coordinates[n2] - 1;
            }
        }

        @Override
        public void setCoordinateValue(int n, int n2) throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        public GeneralGridCoordinates clone() {
            return new GeneralGridCoordinates(this.coordinates);
        }
    }
}

