/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage.grid;

import java.awt.geom.Point2D;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.PropertySource;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.coverage.grid.GridNotEditableException;
import org.opengis.coverage.grid.GridPacking;
import org.opengis.coverage.grid.GridRange;
import org.opengis.coverage.grid.InvalidRangeException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractGridCoverage
extends AbstractCoverage
implements GridCoverage {
    private static final long serialVersionUID = 6476934258101450793L;
    public static final Logger LOGGER = Logging.getLogger(AbstractGridCoverage.class);
    private final transient List<GridCoverage> sources;

    protected AbstractGridCoverage(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, PropertySource propertySource, Map<?, ?> map) {
        super(charSequence, coordinateReferenceSystem, propertySource, map);
        this.sources = null;
    }

    protected AbstractGridCoverage(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, GridCoverage[] gridCoverageArray, PropertySource propertySource, Map<?, ?> map) {
        super(charSequence, coordinateReferenceSystem, propertySource, map);
        if (gridCoverageArray != null) {
            switch (gridCoverageArray.length) {
                case 0: {
                    this.sources = null;
                    break;
                }
                case 1: {
                    this.sources = Collections.singletonList(gridCoverageArray[0]);
                    break;
                }
                default: {
                    this.sources = UnmodifiableArrayList.wrap((Object[])((Object[])gridCoverageArray.clone()));
                    break;
                }
            }
        } else {
            this.sources = null;
        }
    }

    protected AbstractGridCoverage(CharSequence charSequence, GridCoverage gridCoverage) {
        super(charSequence, (Coverage)gridCoverage);
        this.sources = Collections.singletonList(gridCoverage);
    }

    public List<GridCoverage> getSources() {
        if (this.sources != null) {
            return this.sources;
        }
        return Collections.emptyList();
    }

    public boolean isDataEditable() {
        return false;
    }

    public int getNumOverviews() {
        return 0;
    }

    public GridGeometry getOverviewGridGeometry(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(this.indexOutOfBounds(n));
    }

    public GridCoverage getOverview(int n) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException(this.indexOutOfBounds(n));
    }

    @Deprecated
    public GridPacking getGridPacking() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public byte[] getPackedDataBlock(GridRange gridRange) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public boolean[] getDataBlock(GridRange gridRange, boolean[] blArray) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public byte[] getDataBlock(GridRange gridRange, byte[] byArray) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public short[] getDataBlock(GridRange gridRange, short[] sArray) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public int[] getDataBlock(GridRange gridRange, int[] nArray) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public float[] getDataBlock(GridRange gridRange, float[] fArray) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public double[] getDataBlock(GridRange gridRange, double[] dArray) throws InvalidRangeException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Deprecated
    public void setDataBlock(GridRange gridRange, boolean[] blArray) throws InvalidRangeException, GridNotEditableException {
        throw new GridNotEditableException();
    }

    @Deprecated
    public void setDataBlock(GridRange gridRange, byte[] byArray) throws InvalidRangeException, GridNotEditableException {
        throw new GridNotEditableException();
    }

    @Deprecated
    public void setDataBlock(GridRange gridRange, short[] sArray) throws InvalidRangeException, GridNotEditableException {
        throw new GridNotEditableException();
    }

    @Deprecated
    public void setDataBlock(GridRange gridRange, int[] nArray) throws InvalidRangeException, GridNotEditableException {
        throw new GridNotEditableException();
    }

    @Deprecated
    public void setDataBlock(GridRange gridRange, float[] fArray) throws InvalidRangeException, GridNotEditableException {
        throw new GridNotEditableException();
    }

    @Deprecated
    public void setDataBlock(GridRange gridRange, double[] dArray) throws InvalidRangeException, GridNotEditableException {
        throw new GridNotEditableException();
    }

    private String indexOutOfBounds(int n) {
        return Errors.getResources((Locale)this.getLocale()).getString(73, (Object)"index", (Object)n);
    }

    protected String formatEvaluateError(Point2D point2D, boolean bl) {
        return this.formatEvaluateError((DirectPosition)new DirectPosition2D(point2D), bl);
    }

    protected String formatEvaluateError(DirectPosition directPosition, boolean bl) {
        Locale locale = this.getLocale();
        return Errors.getResources((Locale)locale).getString(bl ? 185 : 28, (Object)AbstractGridCoverage.toString(directPosition, locale));
    }

    static String toString(Point2D point2D, Locale locale) {
        return AbstractGridCoverage.toString((DirectPosition)new DirectPosition2D(point2D), locale);
    }

    static String toString(DirectPosition directPosition, Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        FieldPosition fieldPosition = new FieldPosition(0);
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        int n = directPosition.getDimension();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            numberFormat.format(directPosition.getOrdinate(i), stringBuffer, fieldPosition);
        }
        return stringBuffer.toString();
    }
}

