/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.math.NumberSet;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.AbstractInternationalString;
import org.geotoolkit.util.NumberRange;
import org.geotoolkit.util.Range;
import org.geotoolkit.util.SimpleInternationalString;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.util.InternationalString;

public final class TypeMap
extends Static {
    private static final TypeMap[] MAP = new TypeMap[SampleDimensionType.values().length];
    private final SampleDimensionType code;
    private final int type;
    private final byte size;
    private final boolean signed;
    private final boolean real;
    private final NumberRange<?> range;
    private final NumberRange<?> positiveRange;
    private final InternationalString name = new AbstractInternationalString(){

        public String toString(Locale locale) {
            return Vocabulary.getResources((Locale)locale).getString(62, (Object)(TypeMap.this.real ? 2 : (TypeMap.this.signed ? 1 : 0)), (Object)TypeMap.this.size);
        }
    };

    private TypeMap(SampleDimensionType sampleDimensionType, int n, byte by, boolean bl, boolean bl2, Map<Number, Number> map) {
        this(sampleDimensionType, n, by, bl, bl2, null, null, map);
    }

    private TypeMap(SampleDimensionType sampleDimensionType, int n, byte n2, boolean bl, boolean bl2, Number number, Number number2, Map<Number, Number> map) {
        Number number3 = null;
        if (number == null) {
            long l;
            long l2 = (1L << (bl ? n2 - 1 : n2)) - 1L;
            long l3 = l = bl ? l2 ^ 0xFFFFFFFFFFFFFFFFL : 0L;
            if (l2 <= 127L) {
                number = (byte)l;
                number2 = (byte)l2;
                number3 = (byte)1;
            } else if (l2 <= 32767L) {
                number = (short)l;
                number2 = (short)l2;
                number3 = (short)1;
            } else if (l2 <= Integer.MAX_VALUE) {
                number = (int)l;
                number2 = (int)l2;
                number3 = 1;
            } else {
                number = l;
                number2 = l2;
                number3 = 1L;
            }
            number = TypeMap.unique(map, number);
            number2 = TypeMap.unique(map, number2);
            number3 = TypeMap.unique(map, number3);
            assert (number.longValue() == l);
            assert (number2.longValue() == l2);
        }
        assert (((Comparable)((Object)number)).compareTo(number2) < 0) : number2;
        Class<?> clazz = number2.getClass();
        this.code = sampleDimensionType;
        this.type = n;
        this.size = (byte)n2;
        this.signed = bl;
        this.real = bl2;
        this.range = new NumberRange(clazz, number, number2);
        this.positiveRange = bl ? null : new NumberRange(clazz, number3, number2);
        int n3 = sampleDimensionType.ordinal();
        assert (MAP[n3] == null) : sampleDimensionType;
        TypeMap.MAP[n3] = this;
        assert (sampleDimensionType.equals((Object)TypeMap.getSampleDimensionType(this.range))) : sampleDimensionType;
    }

    private static Number unique(Map<Number, Number> map, Number number) {
        Number number2 = map.put(number, number);
        if (number2 == null) {
            return number;
        }
        map.put(number2, number2);
        return number2;
    }

    public static SampleDimensionType getSampleDimensionType(Range<? extends Number> range) {
        Class clazz = range.getElementType();
        if (Double.class.isAssignableFrom(clazz)) {
            return SampleDimensionType.REAL_64BITS;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return SampleDimensionType.REAL_32BITS;
        }
        long l = ((Number)((Object)range.getMinValue())).longValue();
        long l2 = ((Number)((Object)range.getMaxValue())).longValue();
        if (!range.isMinIncluded()) {
            ++l;
        }
        if (!range.isMaxIncluded()) {
            --l2;
        }
        return TypeMap.getSampleDimensionType(l, l2);
    }

    public static SampleDimensionType getSampleDimensionType(double d, double d2) {
        long l;
        long l2 = (long)d;
        if ((double)l2 == d && (double)(l = (long)d2) == d2) {
            return TypeMap.getSampleDimensionType(l2, l);
        }
        if (Math.min(d = Math.abs(d), d2 = Math.abs(d2)) >= (double)1.4E-45f && Math.max(d, d2) <= 3.4028234663852886E38) {
            return SampleDimensionType.REAL_32BITS;
        }
        return SampleDimensionType.REAL_64BITS;
    }

    public static SampleDimensionType getSampleDimensionType(long l, long l2) {
        if (l >= 0L) {
            if (l2 < 2L) {
                return SampleDimensionType.UNSIGNED_1BIT;
            }
            if (l2 < 4L) {
                return SampleDimensionType.UNSIGNED_2BITS;
            }
            if (l2 < 16L) {
                return SampleDimensionType.UNSIGNED_4BITS;
            }
            if (l2 < 256L) {
                return SampleDimensionType.UNSIGNED_8BITS;
            }
            if (l2 < 65536L) {
                return SampleDimensionType.UNSIGNED_16BITS;
            }
            if (l2 < 0x100000000L) {
                return SampleDimensionType.UNSIGNED_32BITS;
            }
        } else {
            if (l >= -128L && l2 <= 127L) {
                return SampleDimensionType.SIGNED_8BITS;
            }
            if (l >= -32768L && l2 <= 32767L) {
                return SampleDimensionType.SIGNED_16BITS;
            }
            if (l >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
                return SampleDimensionType.SIGNED_32BITS;
            }
        }
        return SampleDimensionType.REAL_32BITS;
    }

    public static SampleDimensionType getSampleDimensionType(NumberSet numberSet, int n) {
        boolean bl = numberSet.ordinal() > NumberSet.INTEGER.ordinal();
        boolean bl2 = numberSet != NumberSet.NATURAL;
        for (TypeMap typeMap : MAP) {
            if (typeMap.size < n || typeMap.real != bl || typeMap.signed != bl2 && (bl2 || typeMap.size == n)) continue;
            return typeMap.code;
        }
        return null;
    }

    public static SampleDimensionType getSampleDimensionType(SampleModel sampleModel, int n) throws IllegalArgumentException {
        if (n < 0 || n >= sampleModel.getNumBands()) {
            throw new IllegalArgumentException(Errors.format((int)5, (Object)n));
        }
        boolean bl = true;
        switch (sampleModel.getDataType()) {
            case 5: {
                return SampleDimensionType.REAL_64BITS;
            }
            case 4: {
                return SampleDimensionType.REAL_32BITS;
            }
            case 0: 
            case 1: {
                bl = false;
            }
            case 2: 
            case 3: {
                switch (sampleModel.getSampleSize(n)) {
                    case 1: {
                        return SampleDimensionType.UNSIGNED_1BIT;
                    }
                    case 2: {
                        return SampleDimensionType.UNSIGNED_2BITS;
                    }
                    case 4: {
                        return SampleDimensionType.UNSIGNED_4BITS;
                    }
                    case 8: {
                        return bl ? SampleDimensionType.SIGNED_8BITS : SampleDimensionType.UNSIGNED_8BITS;
                    }
                    case 16: {
                        return bl ? SampleDimensionType.SIGNED_16BITS : SampleDimensionType.UNSIGNED_16BITS;
                    }
                    case 32: {
                        return bl ? SampleDimensionType.SIGNED_32BITS : SampleDimensionType.UNSIGNED_32BITS;
                    }
                }
            }
        }
        return null;
    }

    public static InternationalString getName(SampleDimensionType sampleDimensionType) {
        int n = sampleDimensionType.ordinal();
        if (n >= 0 && n < MAP.length) {
            return TypeMap.MAP[n].name;
        }
        return new SimpleInternationalString(sampleDimensionType.name());
    }

    public static int getDataBufferType(SampleDimensionType sampleDimensionType) {
        int n;
        if (sampleDimensionType != null && (n = sampleDimensionType.ordinal()) >= 0 && n < MAP.length) {
            return TypeMap.MAP[n].type;
        }
        return 32;
    }

    public static int getSize(SampleDimensionType sampleDimensionType) {
        return TypeMap.map((SampleDimensionType)sampleDimensionType).size;
    }

    public static boolean isSigned(SampleDimensionType sampleDimensionType) {
        return TypeMap.map((SampleDimensionType)sampleDimensionType).signed;
    }

    public static boolean isFloatingPoint(SampleDimensionType sampleDimensionType) {
        return TypeMap.map((SampleDimensionType)sampleDimensionType).real;
    }

    public static NumberRange<?> getRange(SampleDimensionType sampleDimensionType) {
        int n;
        if (sampleDimensionType != null && (n = sampleDimensionType.ordinal()) >= 0 && n < MAP.length) {
            return TypeMap.MAP[n].range;
        }
        return null;
    }

    public static NumberRange<?> getPositiveRange(SampleDimensionType sampleDimensionType) {
        int n;
        if (sampleDimensionType != null && (n = sampleDimensionType.ordinal()) >= 0 && n < MAP.length) {
            return TypeMap.MAP[n].positiveRange;
        }
        return null;
    }

    private static TypeMap map(SampleDimensionType sampleDimensionType) throws IllegalArgumentException {
        TypeMap typeMap;
        int n;
        if (sampleDimensionType != null && (n = sampleDimensionType.ordinal()) >= 0 && n < MAP.length && (typeMap = MAP[n]) != null) {
            return typeMap;
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"type", (Object)sampleDimensionType));
    }

    public static Number wrapSample(double d, SampleDimensionType sampleDimensionType, boolean bl) throws IllegalArgumentException {
        TypeMap typeMap = TypeMap.map(sampleDimensionType);
        int n = typeMap.size;
        if (typeMap.real) {
            n <<= 16;
        } else if (typeMap.signed) {
            n = -n;
        }
        switch (n) {
            case -8: 
            case 1: 
            case 2: 
            case 4: {
                byte by = (byte)d;
                if ((double)by == d) {
                    return by;
                }
                if (!bl) break;
            }
            case -16: 
            case 8: {
                short l = (short)d;
                if ((double)l == d) {
                    return l;
                }
                if (!bl) break;
            }
            case -32: 
            case 16: {
                int n2 = (int)d;
                if ((double)n2 == d) {
                    return n2;
                }
                if (!bl) break;
            }
            case 32: {
                long l = (long)d;
                if ((double)l == d) {
                    return l;
                }
                if (!bl) break;
            }
            case 0x200000: {
                if (!bl || Math.abs(d) <= 3.4028234663852886E38) {
                    return Float.valueOf((float)d);
                }
            }
            case 0x400000: {
                return d;
            }
            default: {
                throw new IllegalArgumentException(Errors.format((int)73, (Object)"type", (Object)sampleDimensionType));
            }
        }
        throw new IllegalArgumentException(Errors.format((int)73, (Object)"value", (Object)d));
    }

    public static ColorInterpretation getColorInterpretation(ColorModel colorModel, int n) throws IllegalArgumentException {
        if (n < 0 || n >= ColorUtilities.getNumBands(colorModel)) {
            throw new IllegalArgumentException(Errors.format((int)5, (Object)n));
        }
        if (colorModel instanceof IndexColorModel) {
            return ColorInterpretation.PALETTE_INDEX;
        }
        switch (colorModel.getColorSpace().getType()) {
            case 6: {
                switch (n) {
                    case 0: {
                        return ColorInterpretation.GRAY_INDEX;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
            case 5: {
                switch (n) {
                    case 0: {
                        return ColorInterpretation.RED_BAND;
                    }
                    case 1: {
                        return ColorInterpretation.GREEN_BAND;
                    }
                    case 2: {
                        return ColorInterpretation.BLUE_BAND;
                    }
                    case 3: {
                        return ColorInterpretation.ALPHA_BAND;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
            case 7: {
                switch (n) {
                    case 0: {
                        return ColorInterpretation.HUE_BAND;
                    }
                    case 1: {
                        return ColorInterpretation.SATURATION_BAND;
                    }
                    case 2: {
                        return ColorInterpretation.LIGHTNESS_BAND;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
            case 9: 
            case 11: {
                switch (n) {
                    case 0: {
                        return ColorInterpretation.CYAN_BAND;
                    }
                    case 1: {
                        return ColorInterpretation.MAGENTA_BAND;
                    }
                    case 2: {
                        return ColorInterpretation.YELLOW_BAND;
                    }
                    case 3: {
                        return ColorInterpretation.BLACK_BAND;
                    }
                }
                return ColorInterpretation.UNDEFINED;
            }
        }
        return ColorInterpretation.UNDEFINED;
    }

    static {
        HashMap<Number, Number> hashMap = new HashMap<Number, Number>(32);
        Float f = Float.valueOf(-3.4028235E38f);
        Float f2 = Float.valueOf(Float.MAX_VALUE);
        Double d = -1.7976931348623157E308;
        Double d2 = Double.MAX_VALUE;
        new TypeMap(SampleDimensionType.UNSIGNED_1BIT, 0, 1, false, false, hashMap);
        new TypeMap(SampleDimensionType.UNSIGNED_2BITS, 0, 2, false, false, hashMap);
        new TypeMap(SampleDimensionType.UNSIGNED_4BITS, 0, 4, false, false, hashMap);
        new TypeMap(SampleDimensionType.UNSIGNED_8BITS, 0, 8, false, false, hashMap);
        new TypeMap(SampleDimensionType.SIGNED_8BITS, 0, 8, true, false, hashMap);
        new TypeMap(SampleDimensionType.UNSIGNED_16BITS, 1, 16, false, false, hashMap);
        new TypeMap(SampleDimensionType.SIGNED_16BITS, 2, 16, true, false, hashMap);
        new TypeMap(SampleDimensionType.UNSIGNED_32BITS, 3, 32, false, false, hashMap);
        new TypeMap(SampleDimensionType.SIGNED_32BITS, 3, 32, true, false, hashMap);
        new TypeMap(SampleDimensionType.REAL_32BITS, 4, 32, true, true, f, f2, hashMap);
        new TypeMap(SampleDimensionType.REAL_64BITS, 5, 64, true, true, d, d2, hashMap);
    }
}

