/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Date;
import net.jcip.annotations.NotThreadSafe;
import org.geotoolkit.coverage.AbstractCoverage;
import org.geotoolkit.coverage.CoverageFactoryFinder;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.coverage.OrdinateOutsideCoverageException;
import org.geotoolkit.coverage.grid.GridCoverage2D;
import org.geotoolkit.coverage.grid.GridCoverageFactory;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.internal.referencing.CRSUtilities;
import org.geotoolkit.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.crs.DefaultTemporalCRS;
import org.geotoolkit.referencing.operation.MathTransforms;
import org.geotoolkit.referencing.operation.transform.LinearTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.DateRange;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.SampleDimension;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@NotThreadSafe
public class SpatioTemporalCoverage3D
extends AbstractCoverage {
    private static final long serialVersionUID = 2885506902340338431L;
    private static final Hints HINTS = null;
    private static final AxisDirection[] DIRECTIONS = new AxisDirection[]{AxisDirection.EAST, AxisDirection.NORTH, AxisDirection.DISPLAY_RIGHT, AxisDirection.DISPLAY_DOWN, AxisDirection.COLUMN_POSITIVE, AxisDirection.ROW_POSITIVE};
    protected final Coverage coverage;
    protected final DefaultTemporalCRS temporalCRS;
    protected final int temporalDimension;
    protected final int xDimension;
    protected final int yDimension;
    private transient GeographicBoundingBox boundingBox;
    private final GeneralDirectPosition coordinate;
    private transient GridCoverageFactory factory;

    public SpatioTemporalCoverage3D(CharSequence charSequence, Coverage coverage) throws IllegalArgumentException {
        super(charSequence, coverage);
        CoordinateSystem coordinateSystem = this.crs.getCoordinateSystem();
        int n = coordinateSystem.getDimension();
        if (n != 3) {
            throw new MismatchedDimensionException(Errors.format((int)112, (Object)3, (Object)n));
        }
        if (coverage instanceof SpatioTemporalCoverage3D) {
            SpatioTemporalCoverage3D spatioTemporalCoverage3D = (SpatioTemporalCoverage3D)coverage;
            this.coverage = spatioTemporalCoverage3D.coverage;
            this.temporalCRS = spatioTemporalCoverage3D.temporalCRS;
            this.temporalDimension = spatioTemporalCoverage3D.temporalDimension;
            this.xDimension = spatioTemporalCoverage3D.xDimension;
            this.yDimension = spatioTemporalCoverage3D.yDimension;
            this.boundingBox = spatioTemporalCoverage3D.boundingBox;
        } else {
            this.coverage = coverage;
            this.temporalCRS = DefaultTemporalCRS.castOrCopy((TemporalCRS)CRS.getTemporalCRS((CoordinateReferenceSystem)this.crs));
            if (this.temporalCRS == null) {
                throw new IllegalArgumentException(Errors.format((int)77));
            }
            this.temporalDimension = CRSUtilities.getDimensionOf((CoordinateReferenceSystem)this.crs, this.temporalCRS.getClass());
            int n2 = this.temporalDimension != 0 ? 0 : 1;
            int n3 = this.temporalDimension != 2 ? 2 : 1;
            Boolean bl = null;
            block0: for (int i = 0; i <= 1; ++i) {
                AxisDirection axisDirection = AxisDirections.absolute((AxisDirection)coordinateSystem.getAxis(i == 0 ? n2 : n3).getDirection());
                for (int j = 0; j < DIRECTIONS.length; ++j) {
                    boolean bl2;
                    if (!axisDirection.equals((Object)DIRECTIONS[j])) continue;
                    boolean bl3 = bl2 = (j & 1) != i;
                    if (bl == null) {
                        bl = bl2;
                        continue;
                    }
                    if (bl == bl2) continue;
                    bl = null;
                    break block0;
                }
            }
            if (bl != null && bl.booleanValue()) {
                this.xDimension = n3;
                this.yDimension = n2;
            } else {
                this.xDimension = n2;
                this.yDimension = n3;
            }
        }
        assert (this.temporalDimension >= 0 && this.temporalDimension < n) : this.temporalDimension;
        this.coordinate = new GeneralDirectPosition(n);
    }

    public Coverage getWrappedCoverage() {
        return this.coverage;
    }

    public int getNumSampleDimensions() {
        return this.coverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int n) throws IndexOutOfBoundsException {
        return this.coverage.getSampleDimension(n);
    }

    public GeographicBoundingBox getGeographicBoundingBox() throws TransformException {
        if (this.boundingBox == null) {
            DefaultGeographicBoundingBox defaultGeographicBoundingBox = new DefaultGeographicBoundingBox(this.getEnvelope());
            defaultGeographicBoundingBox.freeze();
            this.boundingBox = defaultGeographicBoundingBox;
        }
        return this.boundingBox;
    }

    public DateRange getTimeRange() {
        Envelope envelope = this.getEnvelope();
        return new DateRange(this.temporalCRS.toDate(envelope.getMinimum(this.temporalDimension)), this.temporalCRS.toDate(envelope.getMaximum(this.temporalDimension)));
    }

    public final int toSourceDimension(int n) {
        switch (n) {
            case 0: {
                return this.xDimension;
            }
            case 1: {
                return this.yDimension;
            }
            case 2: {
                return this.temporalDimension;
            }
        }
        throw new IllegalArgumentException();
    }

    public final DirectPosition toDirectPosition(Point2D point2D, Date date) {
        this.coordinate.ordinates[this.xDimension] = point2D.getX();
        this.coordinate.ordinates[this.yDimension] = point2D.getY();
        this.coordinate.ordinates[this.temporalDimension] = this.temporalCRS.toValue(date);
        return this.coordinate;
    }

    public final Date toDate(DirectPosition directPosition) {
        return this.temporalCRS.toDate(directPosition.getOrdinate(this.temporalDimension));
    }

    public final Point2D toPoint2D(DirectPosition directPosition) {
        return new Point2D.Double(directPosition.getOrdinate(this.xDimension), directPosition.getOrdinate(this.yDimension));
    }

    public final boolean[] evaluate(Point2D point2D, Date date, boolean[] blArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point2D, date), blArray);
        }
        catch (OrdinateOutsideCoverageException ordinateOutsideCoverageException) {
            OrdinateOutsideCoverageException ordinateOutsideCoverageException2;
            if (ordinateOutsideCoverageException.getOutOfBoundsDimension() == this.temporalDimension) {
                ordinateOutsideCoverageException2 = new OrdinateOutsideCoverageException(ordinateOutsideCoverageException, date);
            }
            throw ordinateOutsideCoverageException2;
        }
    }

    public final byte[] evaluate(Point2D point2D, Date date, byte[] byArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point2D, date), byArray);
        }
        catch (OrdinateOutsideCoverageException ordinateOutsideCoverageException) {
            OrdinateOutsideCoverageException ordinateOutsideCoverageException2;
            if (ordinateOutsideCoverageException.getOutOfBoundsDimension() == this.temporalDimension) {
                ordinateOutsideCoverageException2 = new OrdinateOutsideCoverageException(ordinateOutsideCoverageException, date);
            }
            throw ordinateOutsideCoverageException2;
        }
    }

    public final int[] evaluate(Point2D point2D, Date date, int[] nArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point2D, date), nArray);
        }
        catch (OrdinateOutsideCoverageException ordinateOutsideCoverageException) {
            OrdinateOutsideCoverageException ordinateOutsideCoverageException2;
            if (ordinateOutsideCoverageException.getOutOfBoundsDimension() == this.temporalDimension) {
                ordinateOutsideCoverageException2 = new OrdinateOutsideCoverageException(ordinateOutsideCoverageException, date);
            }
            throw ordinateOutsideCoverageException2;
        }
    }

    public final float[] evaluate(Point2D point2D, Date date, float[] fArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point2D, date), fArray);
        }
        catch (OrdinateOutsideCoverageException ordinateOutsideCoverageException) {
            OrdinateOutsideCoverageException ordinateOutsideCoverageException2;
            if (ordinateOutsideCoverageException.getOutOfBoundsDimension() == this.temporalDimension) {
                ordinateOutsideCoverageException2 = new OrdinateOutsideCoverageException(ordinateOutsideCoverageException, date);
            }
            throw ordinateOutsideCoverageException2;
        }
    }

    public final double[] evaluate(Point2D point2D, Date date, double[] dArray) throws PointOutsideCoverageException, CannotEvaluateException {
        try {
            return this.evaluate(this.toDirectPosition(point2D, date), dArray);
        }
        catch (OrdinateOutsideCoverageException ordinateOutsideCoverageException) {
            OrdinateOutsideCoverageException ordinateOutsideCoverageException2;
            if (ordinateOutsideCoverageException.getOutOfBoundsDimension() == this.temporalDimension) {
                ordinateOutsideCoverageException2 = new OrdinateOutsideCoverageException(ordinateOutsideCoverageException, date);
            }
            throw ordinateOutsideCoverageException2;
        }
    }

    public final Object evaluate(DirectPosition directPosition) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.coverage.evaluate(directPosition);
    }

    @Override
    public final boolean[] evaluate(DirectPosition directPosition, boolean[] blArray) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.coverage.evaluate(directPosition, blArray);
    }

    @Override
    public final byte[] evaluate(DirectPosition directPosition, byte[] byArray) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.coverage.evaluate(directPosition, byArray);
    }

    @Override
    public final int[] evaluate(DirectPosition directPosition, int[] nArray) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.coverage.evaluate(directPosition, nArray);
    }

    @Override
    public final float[] evaluate(DirectPosition directPosition, float[] fArray) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.coverage.evaluate(directPosition, fArray);
    }

    @Override
    public final double[] evaluate(DirectPosition directPosition, double[] dArray) throws PointOutsideCoverageException, CannotEvaluateException {
        return this.coverage.evaluate(directPosition, dArray);
    }

    public GridCoverage2D getGridCoverage2D(Date date) throws CannotEvaluateException {
        InternationalString internationalString = this.getName();
        SingleCRS singleCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.crs);
        if (singleCRS == null) {
            throw new CannotEvaluateException(Errors.format((int)38, (Object)this.crs.getName()));
        }
        RenderedImage renderedImage = this.getRenderableImage(date).createDefaultRendering();
        GridSampleDimension[] gridSampleDimensionArray = new GridSampleDimension[this.getNumSampleDimensions()];
        for (int i = 0; i < this.getNumSampleDimensions(); ++i) {
            gridSampleDimensionArray[i] = GridSampleDimension.castOrCopy(this.getSampleDimension(i));
        }
        LinearTransform linearTransform = MathTransforms.linear((AffineTransform)((AffineTransform)renderedImage.getProperty("gridToCRS")));
        if (this.factory == null) {
            this.factory = CoverageFactoryFinder.getGridCoverageFactory(HINTS);
        }
        return this.factory.create((CharSequence)internationalString, renderedImage, (CoordinateReferenceSystem)singleCRS, (MathTransform)linearTransform, gridSampleDimensionArray, null, null);
    }

    public RenderableImage getRenderableImage(Date date) {
        return new Renderable(date);
    }

    protected Dimension2D getDefaultPixelSize() {
        return null;
    }

    private final class Renderable
    extends AbstractCoverage.Renderable {
        private static final long serialVersionUID = 2541951932891099034L;

        public Renderable(Date date) {
            super(SpatioTemporalCoverage3D.this.xDimension, SpatioTemporalCoverage3D.this.yDimension);
            this.coordinate.ordinates[SpatioTemporalCoverage3D.this.temporalDimension] = SpatioTemporalCoverage3D.this.temporalCRS.toValue(date);
        }

        @Override
        public RenderedImage createDefaultRendering() {
            Dimension2D dimension2D = SpatioTemporalCoverage3D.this.getDefaultPixelSize();
            if (dimension2D == null) {
                return super.createDefaultRendering();
            }
            return this.createScaledRendering((int)Math.round((double)this.getWidth() / dimension2D.getWidth()), (int)Math.round((double)this.getHeight() / dimension2D.getHeight()), null);
        }
    }
}

