/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.NullArgumentException;
import org.opengis.coverage.Coverage;

@ThreadSafe
public class CoverageReferences {
    public static final CoverageReferences DEFAULT = new CoverageReferences();
    private final ConcurrentMap<Ref, Ref> pool = new ConcurrentHashMap<Ref, Ref>();

    protected CoverageReferences() {
    }

    public Reference<Coverage> reference(Coverage coverage) {
        Ref ref;
        if (coverage == null) {
            throw new NullArgumentException(Errors.format((int)172, (Object)"coverage"));
        }
        Ref ref2 = (Ref)this.pool.get(new Lookup(coverage));
        if (ref2 == null && (ref = this.pool.putIfAbsent(ref2 = new Ref(coverage), ref2)) != null) {
            ref2 = ref;
        }
        assert (ref2.get() == coverage);
        return ref2;
    }

    private final class Ref
    extends WeakReference<Coverage>
    implements Disposable {
        private final int hash;

        Ref(Coverage coverage) {
            super(coverage, ReferenceQueueConsumer.DEFAULT.queue);
            this.hash = System.identityHashCode(coverage);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            Coverage coverage;
            if (object instanceof Lookup) {
                return ((Lookup)object).coverage == this.get();
            }
            if (object instanceof Ref && (coverage = (Coverage)this.get()) != null) {
                return coverage == ((Ref)object).get();
            }
            return super.equals(object);
        }

        @Override
        public void clear() {
            this.dispose();
        }

        public void dispose() {
            if (this.get() == null) {
                Ref ref = (Ref)CoverageReferences.this.pool.remove(this);
                assert (ref == this || ref == null);
            }
        }
    }

    private static final class Lookup {
        private final Coverage coverage;

        Lookup(Coverage coverage) {
            this.coverage = coverage;
        }

        public int hashCode() {
            return System.identityHashCode(this.coverage);
        }

        public boolean equals(Object object) {
            if (object instanceof Ref) {
                return this.coverage == ((Ref)object).get();
            }
            if (object instanceof Lookup) {
                return this.coverage == ((Lookup)object).coverage;
            }
            return super.equals(object);
        }
    }
}

