/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.util.Arrays;
import java.util.Map;
import org.geotoolkit.coverage.Category;
import org.geotoolkit.internal.image.ColorUtilities;
import org.geotoolkit.internal.image.ScaledColorSpace;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.WeakValueHashMap;

final class ColorModelFactory
extends Static {
    private static final Map<ColorModelFactory, ColorModel> colors = new WeakValueHashMap();
    private final Category[] categories;
    private final int visibleBand;
    private final int numBands;
    private final int type;

    private ColorModelFactory(Category[] categoryArray, int n, int n2, int n3) {
        this.categories = categoryArray;
        this.visibleBand = n2;
        this.numBands = n3;
        this.type = n;
        if (n2 < 0 || n2 >= n3) {
            throw new IllegalArgumentException(Errors.format((int)5, (Object)n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorModel getColorModel(Category[] categoryArray, int n, int n2, int n3) {
        Map<ColorModelFactory, ColorModel> map = colors;
        synchronized (map) {
            ColorModelFactory colorModelFactory = new ColorModelFactory(categoryArray, n, n2, n3);
            ColorModel colorModel = colors.get((Object)colorModelFactory);
            if (colorModel == null) {
                colorModel = colorModelFactory.getColorModel();
                colors.put(colorModelFactory, colorModel);
            }
            return colorModel;
        }
    }

    private ColorModel getColorModel() {
        int n;
        double d = 0.0;
        double d2 = 1.0;
        int n2 = this.categories.length;
        if (n2 != 0) {
            d = this.categories[0].minimum;
            n = n2;
            while (--n >= 0) {
                double d3 = this.categories[n].maximum;
                if (Double.isNaN(d3)) continue;
                d2 = d3;
                break;
            }
        }
        if (this.type != 0 && this.type != 1) {
            ScaledColorSpace scaledColorSpace = new ScaledColorSpace(this.numBands, this.visibleBand, d, d2);
            return new ComponentColorModel(scaledColorSpace, false, false, 1, this.type);
        }
        if (this.numBands == 1 && n2 == 0) {
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            int[] nArray = new int[]{DataBuffer.getDataTypeSize(this.type)};
            return new ComponentColorModel(colorSpace, nArray, false, true, 1, this.type);
        }
        n = (int)Math.round(d2) + 1;
        int[] nArray = new int[n];
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            Category category = this.categories[i];
            Color[] colorArray = category.getColors();
            if (n3 < 0 && ColorModelFactory.isTransparent(colorArray) && (double)(n3 = (int)category.minimum) != category.minimum) {
                n3 = -1;
            }
            ColorUtilities.expand(colorArray, nArray, (int)Math.round(category.minimum), (int)Math.round(category.maximum) + 1);
        }
        return ColorUtilities.getIndexColorModel(nArray, this.numBands, this.visibleBand, n3);
    }

    private static boolean isTransparent(Color[] colorArray) {
        for (Color color : colorArray) {
            if (color.getAlpha() == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.categories.length;
        int n2 = 962745549 + (this.numBands * 31 + this.visibleBand) * 31 + n;
        for (int i = 0; i < n; ++i) {
            n2 += this.categories[i].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ColorModelFactory) {
            ColorModelFactory colorModelFactory = (ColorModelFactory)((Object)object);
            return this.numBands == colorModelFactory.numBands && this.visibleBand == colorModelFactory.visibleBand && Arrays.equals(this.categories, colorModelFactory.categories);
        }
        return false;
    }
}

