/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.coverage;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.ImageFunction;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import javax.media.jai.operator.ImageFunctionDescriptor;
import javax.media.jai.widget.ScrollingImagePanel;
import org.geotoolkit.coverage.GridSampleDimension;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.image.ImageUtilities;
import org.geotoolkit.internal.referencing.AxisDirections;
import org.geotoolkit.io.LineWriter;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.matrix.GeneralMatrix;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Localized;
import org.geotoolkit.util.SimpleInternationalString;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.coverage.AttributeValues;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.CommonPointRule;
import org.opengis.coverage.Coverage;
import org.opengis.coverage.DomainObject;
import org.opengis.coverage.GeometryValuePair;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.temporal.Period;
import org.opengis.util.InternationalString;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public abstract class AbstractCoverage
extends PropertySourceImpl
implements Coverage,
Localized {
    private static final long serialVersionUID = -2989320942499746295L;
    private static final int VISIBLE_BAND = 0;
    private final InternationalString name;
    protected final CoordinateReferenceSystem crs;

    protected AbstractCoverage(CharSequence charSequence, CoordinateReferenceSystem coordinateReferenceSystem, PropertySource propertySource, Map<?, ?> map) {
        super(map, propertySource);
        this.name = SimpleInternationalString.wrap((CharSequence)charSequence);
        this.crs = coordinateReferenceSystem;
    }

    protected AbstractCoverage(CharSequence charSequence, Coverage coverage) {
        super(null, coverage instanceof PropertySource ? (PropertySource)coverage : null);
        InternationalString internationalString = SimpleInternationalString.wrap((CharSequence)charSequence);
        if (coverage instanceof AbstractCoverage) {
            AbstractCoverage abstractCoverage = (AbstractCoverage)coverage;
            this.name = internationalString != null ? internationalString : abstractCoverage.name;
            this.crs = abstractCoverage.crs;
        } else {
            this.name = internationalString != null ? internationalString : new SimpleInternationalString(coverage.toString());
            this.crs = coverage.getCoordinateReferenceSystem();
        }
    }

    public InternationalString getName() {
        return this.name;
    }

    public final int getDimension() {
        return this.crs.getCoordinateSystem().getDimension();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public Envelope getEnvelope() {
        return CRS.getEnvelope((CoordinateReferenceSystem)this.crs);
    }

    public Set<Extent> getDomainExtents() {
        throw AbstractCoverage.unsupported();
    }

    public Set<? extends DomainObject<?>> getDomainElements() {
        throw AbstractCoverage.unsupported();
    }

    public Set<AttributeValues> getRangeElements() {
        throw AbstractCoverage.unsupported();
    }

    public RecordType getRangeType() {
        throw AbstractCoverage.unsupported();
    }

    public CommonPointRule getCommonPointRule() {
        throw AbstractCoverage.unsupported();
    }

    public Set<? extends GeometryValuePair> list() {
        throw AbstractCoverage.unsupported();
    }

    public Set<? extends GeometryValuePair> select(Geometry geometry, Period period) {
        throw AbstractCoverage.unsupported();
    }

    public List<? extends GeometryValuePair> find(DirectPosition directPosition, int n) {
        throw AbstractCoverage.unsupported();
    }

    public GeometryValuePair find(DirectPosition directPosition) {
        List<? extends GeometryValuePair> list = this.find(directPosition, 1);
        return list.isEmpty() ? null : list.get(0);
    }

    private static UnsupportedOperationException unsupported() {
        throw new UnsupportedOperationException("This method is currently not implemented. It may be implemented by next version of coverage module.");
    }

    private static String formatErrorMessage(Object object) {
        Class<?> clazz = null;
        if (object != null && (clazz = object.getClass()).isArray()) {
            clazz = clazz.getComponentType();
        }
        return Errors.format((int)24, clazz);
    }

    public Set<Record> evaluate(DirectPosition directPosition, Collection<String> collection) {
        throw AbstractCoverage.unsupported();
    }

    public boolean[] evaluate(DirectPosition directPosition, boolean[] blArray) throws PointOutsideCoverageException, CannotEvaluateException {
        Object object = this.evaluate(directPosition);
        try {
            int n = Array.getLength(object);
            if (blArray == null) {
                blArray = new boolean[n];
            }
            for (int i = 0; i < n; ++i) {
                blArray[i] = Array.getBoolean(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(object), (Throwable)illegalArgumentException);
        }
        return blArray;
    }

    public byte[] evaluate(DirectPosition directPosition, byte[] byArray) throws PointOutsideCoverageException, CannotEvaluateException {
        Object object = this.evaluate(directPosition);
        try {
            int n = Array.getLength(object);
            if (byArray == null) {
                byArray = new byte[n];
            }
            for (int i = 0; i < n; ++i) {
                byArray[i] = Array.getByte(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(object), (Throwable)illegalArgumentException);
        }
        return byArray;
    }

    public int[] evaluate(DirectPosition directPosition, int[] nArray) throws PointOutsideCoverageException, CannotEvaluateException {
        Object object = this.evaluate(directPosition);
        try {
            int n = Array.getLength(object);
            if (nArray == null) {
                nArray = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                nArray[i] = Array.getInt(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(object), (Throwable)illegalArgumentException);
        }
        return nArray;
    }

    public float[] evaluate(DirectPosition directPosition, float[] fArray) throws PointOutsideCoverageException, CannotEvaluateException {
        Object object = this.evaluate(directPosition);
        try {
            int n = Array.getLength(object);
            if (fArray == null) {
                fArray = new float[n];
            }
            for (int i = 0; i < n; ++i) {
                fArray[i] = Array.getFloat(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(object), (Throwable)illegalArgumentException);
        }
        return fArray;
    }

    public double[] evaluate(DirectPosition directPosition, double[] dArray) throws PointOutsideCoverageException, CannotEvaluateException {
        Object object = this.evaluate(directPosition);
        try {
            int n = Array.getLength(object);
            if (dArray == null) {
                dArray = new double[n];
            }
            for (int i = 0; i < n; ++i) {
                dArray[i] = Array.getDouble(object, i);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CannotEvaluateException(AbstractCoverage.formatErrorMessage(object), (Throwable)illegalArgumentException);
        }
        return dArray;
    }

    public Set<? extends DomainObject<?>> evaluateInverse(Record record) {
        throw AbstractCoverage.unsupported();
    }

    public RenderableImage getRenderableImage(int n, int n2) {
        return new Renderable(n, n2);
    }

    public void show(String string, int n, int n2) {
        if (string == null || (string = string.trim()).isEmpty()) {
            string = String.valueOf(this.getName());
        }
        new Viewer(string, this.getRenderableImage(n, n2).createDefaultRendering());
    }

    public void show(String string) {
        this.show(string, 0, 1);
    }

    public void show() {
        this.show(null);
    }

    public List<? extends Coverage> getSources() {
        return Collections.emptyList();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Classes.getShortClassName((Object)((Object)this)));
        stringWriter.write("[\"");
        stringWriter.write(String.valueOf(this.getName()));
        stringWriter.write(34);
        Envelope envelope = this.getEnvelope();
        if (envelope != null) {
            stringWriter.write(", ");
            stringWriter.write(envelope.toString());
        }
        if (this.crs != null) {
            stringWriter.write(", ");
            stringWriter.write(Classes.getShortClassName((Object)this.crs));
            stringWriter.write("[\"");
            stringWriter.write(this.crs.getName().getCode());
            stringWriter.write("\"]");
        }
        stringWriter.write(93);
        String string = System.getProperty("line.separator", "\n");
        LineWriter lineWriter = new LineWriter((Writer)stringWriter, string + "\u2502   ");
        int n = this.getNumSampleDimensions();
        try {
            lineWriter.write(string);
            for (int i = 0; i < n; ++i) {
                lineWriter.write(this.getSampleDimension(i).toString());
            }
            lineWriter.flush();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        StringBuffer stringBuffer = stringWriter.getBuffer();
        stringBuffer.setLength(stringBuffer.lastIndexOf(string) + string.length());
        return stringBuffer.toString();
    }

    public boolean dispose(boolean bl) {
        return true;
    }

    private static final class Viewer
    extends WindowAdapter
    implements Runnable {
        private final Frame frame;

        public Viewer(String string, RenderedImage renderedImage) {
            int n = Math.max(Math.min(renderedImage.getWidth(), 800), 24);
            int n2 = Math.max(Math.min(renderedImage.getHeight(), 600), 24);
            this.frame = new Frame(string);
            this.frame.add((Component)new ScrollingImagePanel(renderedImage, n, n2));
            this.frame.addWindowListener(this);
            EventQueue.invokeLater(this);
        }

        @Override
        public void run() {
            this.frame.pack();
            this.frame.setLocationByPlatform(true);
            this.frame.setVisible(true);
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.frame.removeWindowListener(this);
            this.frame.dispose();
        }
    }

    protected class Renderable
    extends PropertySourceImpl
    implements RenderableImage,
    ImageFunction {
        private static final long serialVersionUID = -6661389795161502552L;
        private final Rectangle2D bounds;
        protected final int xAxis;
        protected final int yAxis;
        protected final GeneralDirectPosition coordinate;

        public Renderable(int n, int n2) {
            super(null, (PropertySource)AbstractCoverage.this);
            this.coordinate = new GeneralDirectPosition(AbstractCoverage.this.getDimension());
            this.xAxis = n;
            this.yAxis = n2;
            Envelope envelope = AbstractCoverage.this.getEnvelope();
            this.bounds = new Rectangle2D.Double(envelope.getMinimum(n), envelope.getMinimum(n2), envelope.getSpan(n), envelope.getSpan(n2));
        }

        @Override
        public Vector<RenderableImage> getSources() {
            return null;
        }

        @Override
        public boolean isDynamic() {
            return false;
        }

        public boolean isComplex() {
            return false;
        }

        @Override
        public float getWidth() {
            return (float)this.bounds.getWidth();
        }

        @Override
        public float getHeight() {
            return (float)this.bounds.getHeight();
        }

        @Override
        public float getMinX() {
            return (float)this.bounds.getX();
        }

        @Override
        public float getMinY() {
            return (float)this.bounds.getY();
        }

        @Override
        public RenderedImage createDefaultRendering() {
            return this.createScaledRendering(512, 0, null);
        }

        @Override
        public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
            double d = this.bounds.getWidth();
            double d2 = this.bounds.getHeight();
            if (n <= 0) {
                if (n2 <= 0) {
                    throw new IllegalArgumentException(Errors.format((int)235));
                }
                n = (int)Math.round((double)n2 * (d / d2));
            } else if (n2 <= 0) {
                n2 = (int)Math.round((double)n * (d2 / d));
            }
            return this.createRendering(this.createRenderContext(new Rectangle(0, 0, n, n2), renderingHints));
        }

        @Override
        public RenderedImage createRendering(RenderContext renderContext) {
            TiledImage tiledImage;
            AffineTransform affineTransform = renderContext.getTransform();
            Shape shape = renderContext.getAreaOfInterest();
            Cloneable cloneable = XAffineTransform.transform((AffineTransform)affineTransform, (Rectangle2D)(shape != null ? shape.getBounds2D() : this.bounds), null);
            int n = (int)Math.round(cloneable.getMinX());
            int n2 = (int)Math.round(cloneable.getMinY());
            int n3 = (int)Math.round(cloneable.getMaxX());
            int n4 = (int)Math.round(cloneable.getMaxY());
            Rectangle rectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
            cloneable = ImageUtilities.toTileSize(rectangle.getSize());
            GridSampleDimension gridSampleDimension = GridSampleDimension.castOrCopy(AbstractCoverage.this.getSampleDimension(0));
            ColorModel colorModel = gridSampleDimension.getColorModel(0, AbstractCoverage.this.getNumSampleDimensions());
            SampleModel sampleModel = colorModel.createCompatibleSampleModel(((Dimension)cloneable).width, ((Dimension)cloneable).height);
            if ((shape == null || shape instanceof Rectangle2D) && affineTransform.getShearX() == 0.0 && affineTransform.getShearY() == 0.0) {
                tiledImage = ImageFunctionDescriptor.create((ImageFunction)this, (Integer)rectangle.width, (Integer)rectangle.height, (Float)Float.valueOf((float)(1.0 / affineTransform.getScaleX())), (Float)Float.valueOf((float)(1.0 / affineTransform.getScaleY())), (Float)Float.valueOf((float)affineTransform.getTranslateX()), (Float)Float.valueOf((float)affineTransform.getTranslateY()), (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, new ImageLayout().setMinX(rectangle.x).setMinY(rectangle.y).setTileWidth(((Dimension)cloneable).width).setTileHeight(((Dimension)cloneable).height).setSampleModel(sampleModel).setColorModel(colorModel)));
            } else {
                GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition((DirectPosition)this.coordinate);
                TiledImage tiledImage2 = new TiledImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, sampleModel, colorModel);
                Point2D.Double double_ = new Point2D.Double();
                int n5 = tiledImage2.getNumBands();
                double[] dArray = new double[n5];
                double[] dArray2 = new double[n5];
                Arrays.fill(dArray2, Double.NaN);
                WritableRectIter writableRectIter = RectIterFactory.createWritable((WritableRenderedImage)tiledImage2, (Rectangle)rectangle);
                if (!writableRectIter.finishedLines()) {
                    try {
                        int n6 = rectangle.y;
                        do {
                            writableRectIter.startPixels();
                            if (writableRectIter.finishedPixels()) continue;
                            int n7 = rectangle.x;
                            do {
                                double_.x = n7;
                                double_.y = n6;
                                affineTransform.inverseTransform(double_, double_);
                                if (shape == null || shape.contains(double_)) {
                                    generalDirectPosition.ordinates[this.xAxis] = double_.x;
                                    generalDirectPosition.ordinates[this.yAxis] = double_.y;
                                    writableRectIter.setPixel(AbstractCoverage.this.evaluate((DirectPosition)generalDirectPosition, dArray));
                                } else {
                                    writableRectIter.setPixel(dArray2);
                                }
                                ++n7;
                            } while (!writableRectIter.nextPixelDone());
                            assert (n7 == rectangle.x + rectangle.width);
                            ++n6;
                        } while (!writableRectIter.nextLineDone());
                        assert (n6 == rectangle.y + rectangle.height);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        throw new IllegalArgumentException(Errors.format((int)72, (Object)"context"), noninvertibleTransformException);
                    }
                }
                tiledImage = tiledImage2;
            }
            try {
                tiledImage.setProperty("gridToCRS", (Object)affineTransform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                Logging.unexpectedException(Renderable.class, (String)"createRendering", (Throwable)noninvertibleTransformException);
            }
            return tiledImage;
        }

        protected RenderContext createRenderContext(Rectangle2D rectangle2D, RenderingHints renderingHints) {
            GeneralMatrix generalMatrix;
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(this.bounds);
            GeneralEnvelope generalEnvelope2 = new GeneralEnvelope(rectangle2D);
            if (AbstractCoverage.this.crs != null) {
                CoordinateSystem coordinateSystem = AbstractCoverage.this.crs.getCoordinateSystem();
                AxisDirection[] axisDirectionArray = new AxisDirection[]{coordinateSystem.getAxis(this.xAxis).getDirection(), coordinateSystem.getAxis(this.yAxis).getDirection()};
                AxisDirection[] axisDirectionArray2 = (AxisDirection[])axisDirectionArray.clone();
                axisDirectionArray2[1] = AxisDirections.opposite((AxisDirection)axisDirectionArray2[1]);
                generalMatrix = new GeneralMatrix((Envelope)generalEnvelope, axisDirectionArray, (Envelope)generalEnvelope2, axisDirectionArray2);
            } else {
                generalMatrix = new GeneralMatrix((Envelope)generalEnvelope, (Envelope)generalEnvelope2);
            }
            return new RenderContext(generalMatrix.toAffineTransform2D(), renderingHints);
        }

        public int getNumElements() {
            return AbstractCoverage.this.getNumSampleDimensions();
        }

        public void getElements(float f, float f2, float f3, float f4, int n, int n2, int n3, float[] fArray, float[] fArray2) {
            int n4 = 0;
            float[] fArray3 = null;
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition((DirectPosition)this.coordinate);
            generalDirectPosition.ordinates[1] = f2;
            for (int i = 0; i < n2; ++i) {
                generalDirectPosition.ordinates[0] = f;
                for (int j = 0; j < n; ++j) {
                    fArray3 = AbstractCoverage.this.evaluate((DirectPosition)generalDirectPosition, fArray3);
                    fArray[n4++] = fArray3[n3];
                    generalDirectPosition.ordinates[0] = generalDirectPosition.ordinates[0] + (double)f3;
                }
                generalDirectPosition.ordinates[1] = generalDirectPosition.ordinates[1] + (double)f4;
            }
        }

        public void getElements(double d, double d2, double d3, double d4, int n, int n2, int n3, double[] dArray, double[] dArray2) {
            int n4 = 0;
            double[] dArray3 = null;
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition((DirectPosition)this.coordinate);
            generalDirectPosition.ordinates[1] = d2;
            for (int i = 0; i < n2; ++i) {
                generalDirectPosition.ordinates[0] = d;
                for (int j = 0; j < n; ++j) {
                    dArray3 = AbstractCoverage.this.evaluate((DirectPosition)generalDirectPosition, dArray3);
                    dArray[n4++] = dArray3[n3];
                    generalDirectPosition.ordinates[0] = generalDirectPosition.ordinates[0] + d3;
                }
                generalDirectPosition.ordinates[1] = generalDirectPosition.ordinates[1] + d4;
            }
        }
    }
}

