/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.sql.Connection;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.responses.map.kml.CachedHierarchyRegionatingStrategy;

public class RandomRegionatingStrategy
extends CachedHierarchyRegionatingStrategy {
    public FeatureIterator getSortedFeatures(ReferencedEnvelope env, Connection cacheConn) throws Exception {
        FeatureSource fs = this.typeInfo.getFeatureSource();
        GeometryDescriptor geom = fs.getSchema().getGeometryDescriptor();
        CoordinateReferenceSystem nativeCrs = geom.getCoordinateReferenceSystem();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        if (!CRS.equalsIgnoreMetadata((Object)WGS84, (Object)nativeCrs)) {
            env = env.transform(nativeCrs, true);
        }
        BBOX filter = ff.bbox(geom.getLocalName(), env.getMinX(), env.getMinY(), env.getMaxX(), env.getMaxY(), null);
        DefaultQuery q = new DefaultQuery();
        q.setFilter((Filter)filter);
        q.setPropertyNames(new String[]{geom.getLocalName()});
        return fs.getFeatures((Query)q).features();
    }
}

