/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.feature.type.DateUtil;
import org.geotools.map.MapLayer;
import org.geotools.renderer.style.LineStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.PolygonStyle2D;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.Translator;
import org.geotools.xs.bindings.XSDateTimeBinding;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.expression.Expression;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTimeTemplate;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLUtils;
import org.xml.sax.ContentHandler;

public abstract class KMLMapTransformer
extends KMLTransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    protected double scaleDenominator = 1.0;
    NumberRange scaleRange = new NumberRange(this.scaleDenominator, this.scaleDenominator);
    SLDStyleFactory styleFactory = new SLDStyleFactory();
    FeatureTemplate template = new FeatureTemplate();
    protected WMSMapContext mapContext;
    protected final MapLayer mapLayer;
    static List dtformats = new ArrayList();
    static List dformats = new ArrayList();
    static List tformats = new ArrayList();

    static void addFormats(List formats, String pattern) {
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "-")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", "/")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ".")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", " ")));
        formats.add(new SimpleDateFormat(pattern.replaceAll("%", ",")));
    }

    public KMLMapTransformer(WMSMapContext mapContext, MapLayer mapLayer) {
        this.mapContext = mapContext;
        this.mapLayer = mapLayer;
    }

    static {
        dtformats.add(DateFormat.getDateTimeInstance());
        dtformats.add(FeatureTemplate.DATETIME_FORMAT);
        KMLMapTransformer.addFormats(dtformats, "dd%MM%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "MM%dd%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "dd%MMM%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "MMM%dd%yy hh:mm:ss");
        KMLMapTransformer.addFormats(dtformats, "dd%MM%yy hh:mm");
        KMLMapTransformer.addFormats(dtformats, "MM%dd%yy hh:mm");
        KMLMapTransformer.addFormats(dtformats, "dd%MMM%yy hh:mm");
        KMLMapTransformer.addFormats(dtformats, "MMM%dd%yy hh:mm");
        dformats.add(DateFormat.getDateInstance());
        dformats.add(FeatureTemplate.DATE_FORMAT);
        KMLMapTransformer.addFormats(dformats, "dd%MM%yy");
        KMLMapTransformer.addFormats(dformats, "MM%dd%yy");
        KMLMapTransformer.addFormats(dformats, "dd%MMM%yy");
        KMLMapTransformer.addFormats(dformats, "MMM%dd%yy");
        tformats.add(DateFormat.getTimeInstance());
        tformats.add(FeatureTemplate.TIME_FORMAT);
    }

    public abstract class KMLMapTranslatorSupport
    extends KMLTransformerBase.KMLTranslatorSupport {
        Translator geometryTranslator;

        public KMLMapTranslatorSupport(ContentHandler contentHandler) {
            super(KMLMapTransformer.this, contentHandler);
        }

        protected void encodePlacemarkName(SimpleFeature feature, FeatureTypeStyle[] styles) throws IOException {
            String title = KMLMapTransformer.this.template.title(feature);
            boolean trySLD = false;
            if (title == null || "".equals(title)) {
                title = feature.getID();
            }
            if (title.equals(feature.getID())) {
                trySLD = true;
            }
            if (trySLD) {
                StringBuffer label = new StringBuffer();
                for (int i = 0; i < styles.length; ++i) {
                    Rule[] rules = KMLUtils.filterRules(styles[i], feature, KMLMapTransformer.this.scaleDenominator);
                    for (int j = 0; j < rules.length; ++j) {
                        Symbolizer[] syms = rules[j].getSymbolizers();
                        for (int k = 0; k < syms.length; ++k) {
                            if (!(syms[k] instanceof TextSymbolizer)) continue;
                            Expression e = SLD.textLabel((TextSymbolizer)((TextSymbolizer)syms[k]));
                            Object object = null;
                            if (e != null) {
                                object = e.evaluate((Object)feature);
                            }
                            String value = null;
                            if (object instanceof String) {
                                value = (String)object;
                            } else if (object != null) {
                                value = object.toString();
                            }
                            if (value == null || "".equals(value.trim())) continue;
                            label.append(value);
                        }
                    }
                }
                if (label.length() > 0) {
                    title = label.toString();
                }
            }
            this.start("name");
            this.cdata(title);
            this.end("name");
        }

        protected void encodePlacemarkSnippet(SimpleFeature feature, FeatureTypeStyle[] styles) {
        }

        protected void encodePlacemarkDescription(SimpleFeature feature, FeatureTypeStyle[] styles) throws IOException {
            String description = KMLMapTransformer.this.template.description(feature);
            if (description != null) {
                this.start("description");
                this.cdata(description);
                this.end("description");
            }
        }

        protected void encodePlacemarkLookAt(Coordinate centroid) {
            this.start("LookAt");
            this.element("longitude", Double.toString(centroid.x));
            this.element("latitude", Double.toString(centroid.y));
            this.element("heading", "10.0");
            this.element("tilt", "10.0");
            this.element("range", "700");
            this.end("LookAt");
        }

        protected boolean encodeStyle(SimpleFeature feature, FeatureTypeStyle[] styles) {
            return this.encodeStyle(feature, styles, false);
        }

        protected boolean encodeStyle(SimpleFeature feature, FeatureTypeStyle[] styles, boolean isVector) {
            ArrayList<Symbolizer> symbolizerList = new ArrayList<Symbolizer>();
            for (int j = 0; j < styles.length; ++j) {
                Rule[] rules = isVector ? KMLUtils.filterRules(styles[j], feature, 0.0) : KMLUtils.filterRules(styles[j], feature, KMLMapTransformer.this.scaleDenominator);
                for (int i = 0; i < rules.length; ++i) {
                    symbolizerList.addAll(Arrays.asList(rules[i].getSymbolizers()));
                }
            }
            if (!symbolizerList.isEmpty()) {
                this.start("Style", KMLUtils.attributes(new String[]{"id", "GeoServerStyle" + feature.getID()}));
                Symbolizer[] symbolizers = symbolizerList.toArray(new Symbolizer[symbolizerList.size()]);
                this.encodeStyle(feature, symbolizers);
                this.end("Style");
                return true;
            }
            return false;
        }

        protected void encodeDefaultIconStyle(SimpleFeature feature) {
            boolean poly;
            boolean line = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof LineString || feature.getDefaultGeometry() instanceof MultiLineString);
            boolean bl = poly = feature.getDefaultGeometry() != null && (feature.getDefaultGeometry() instanceof Polygon || feature.getDefaultGeometry() instanceof MultiPolygon);
            if (!line && !poly) {
                LOGGER.log(Level.FINER, "Unexpectedly entered encodeDefaultIconStyle() with something that does not have a multipoint geometry.");
                return;
            }
            this.start("IconStyle");
            if (!KMLMapTransformer.this.mapContext.getRequest().getKMattr()) {
                this.encodeColor("00ffffff");
            }
            if (line || poly) {
                this.element("scale", "0.4");
            }
            this.start("Icon");
            String imageURL = "http://icons.opengeo.org/markers/icon-" + (poly ? "poly.1" : "line.1") + ".png";
            this.element("href", imageURL);
            this.end("Icon");
            this.end("IconStyle");
        }

        protected void encodeDefaultTextStyle() {
            this.start("LabelStyle");
            this.encodeColor("00ffffff");
            this.end("LabelStyle");
        }

        protected void encodeStyle(SimpleFeature feature, Symbolizer[] symbolizers) {
            boolean forceOutline = false;
            for (int i = 0; i < symbolizers.length; ++i) {
                if (!(symbolizers[i] instanceof LineSymbolizer)) continue;
                forceOutline = true;
                break;
            }
            boolean lacksPointSymbolizer = true;
            boolean lacksTextSymbolizer = true;
            Symbolizer multiPointSymbolizer = null;
            try {
                for (int i = 0; i < symbolizers.length; ++i) {
                    Symbolizer symbolizer = symbolizers[i];
                    LOGGER.finer(new StringBuffer("Applying symbolizer ").append(symbolizer).toString());
                    Style2D style = null;
                    try {
                        KMLMapTransformer.this.styleFactory.createStyle((Object)feature, symbolizer, (Range)KMLMapTransformer.this.scaleRange);
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                    if (symbolizer instanceof TextSymbolizer) {
                        this.encodeTextStyle((TextStyle2D)style, (TextSymbolizer)symbolizer);
                        lacksTextSymbolizer = false;
                    }
                    if (symbolizer instanceof PolygonSymbolizer) {
                        this.encodePolygonStyle((PolygonStyle2D)style, (PolygonSymbolizer)symbolizer, forceOutline);
                        multiPointSymbolizer = symbolizer;
                    }
                    if (symbolizer instanceof LineSymbolizer) {
                        this.encodeLineStyle((LineStyle2D)style, (LineSymbolizer)symbolizer);
                        multiPointSymbolizer = symbolizer;
                    }
                    if (!(symbolizer instanceof PointSymbolizer)) continue;
                    this.encodePointStyle(style, (PointSymbolizer)symbolizer);
                    lacksPointSymbolizer = false;
                }
                if (lacksTextSymbolizer) {
                    this.encodeDefaultTextStyle();
                }
                if (multiPointSymbolizer != null && lacksPointSymbolizer) {
                    this.encodeDefaultIconStyle(feature);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error occurred during style encoding", e);
            }
        }

        protected void encodePolygonStyle(PolygonStyle2D style, PolygonSymbolizer symbolizer, boolean forceOutline) {
            double opacity;
            this.start("PolyStyle");
            if (symbolizer.getFill() != null) {
                opacity = SLD.opacity((Fill)symbolizer.getFill());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor(SLD.color((Fill)symbolizer.getFill()), opacity);
            } else {
                this.encodeColor("00aaaaaa");
            }
            if (symbolizer.getStroke() != null || forceOutline) {
                this.element("outline", "1");
            } else {
                this.element("outline", "0");
            }
            this.end("PolyStyle");
            if (symbolizer.getStroke() != null) {
                int width;
                this.start("LineStyle");
                opacity = SLD.opacity((Stroke)symbolizer.getStroke());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                if (style != null) {
                    this.encodeColor(KMLUtils.colorToHex((Color)style.getContour(), opacity));
                }
                if ((width = SLD.width((Stroke)symbolizer.getStroke())) != -1) {
                    this.element("width", Integer.toString(width));
                }
                this.end("LineStyle");
            }
        }

        protected void encodeLineStyle(LineStyle2D style, LineSymbolizer symbolizer) {
            this.start("LineStyle");
            if (symbolizer.getStroke() != null) {
                double opacity = SLD.opacity((Stroke)symbolizer.getStroke());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                if (symbolizer.getStroke().getColor() != null) {
                    this.encodeW3CColor(symbolizer.getStroke().getColor().toString(), "ff");
                } else if (style != null) {
                    this.encodeColor((Color)style.getContour(), opacity);
                }
                int width = SLD.width((Stroke)symbolizer.getStroke());
                if (width != -1) {
                    this.element("width", Integer.toString(width));
                }
            } else {
                this.encodeColor("ffaaaaaa");
                this.element("width", "1");
            }
            this.end("LineStyle");
        }

        protected void encodePointStyle(Style2D style, PointSymbolizer symbolizer) {
            Mark mark;
            this.start("IconStyle");
            if (style instanceof MarkStyle2D && (mark = SLD.mark((PointSymbolizer)symbolizer)) != null) {
                double opacity = SLD.opacity((Fill)mark.getFill());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                if (mark.getFill() != null) {
                    Color color = SLD.color((Fill)mark.getFill());
                    this.encodeColor(color, opacity);
                }
            }
            this.element("colorMode", "normal");
            String iconHref = null;
            if (symbolizer.getGraphic() != null && symbolizer.getGraphic().getExternalGraphics() != null && symbolizer.getGraphic().getExternalGraphics().length > 0) {
                ExternalGraphic graphic = symbolizer.getGraphic().getExternalGraphics()[0];
                try {
                    if ("file".equals(graphic.getLocation().getProtocol())) {
                        File file = new File(graphic.getLocation().getFile());
                        iconHref = RequestUtils.baseURL((HttpServletRequest)KMLMapTransformer.this.mapContext.getRequest().getHttpServletRequest()) + "styles/" + file.getName();
                    } else if ("http".equals(graphic.getLocation().getProtocol())) {
                        iconHref = graphic.getLocation().toString();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error processing external graphic:" + graphic, e);
                }
            }
            if (iconHref == null) {
                iconHref = "http://maps.google.com/mapfiles/kml/pal4/icon25.png";
            }
            this.start("Icon");
            this.element("href", iconHref);
            this.end("Icon");
            this.end("IconStyle");
        }

        protected void encodeTextStyle(TextStyle2D style, TextSymbolizer symbolizer) {
            this.start("LabelStyle");
            if (symbolizer.getFill() != null) {
                double opacity = SLD.opacity((Fill)symbolizer.getFill());
                if (Double.isNaN(opacity)) {
                    opacity = 1.0;
                }
                this.encodeColor(SLD.color((Fill)symbolizer.getFill()), opacity);
            } else {
                this.encodeColor("ffffffff");
            }
            this.end("LabelStyle");
        }

        void encodeColor(Color color, double opacity) {
            this.encodeColor(KMLUtils.colorToHex(color, opacity));
        }

        void encodeColor(String hex) {
            this.element("color", hex);
        }

        void encodeW3CColor(String w3cHex, String opacity) {
            this.element("color", opacity + w3cHex.substring(5, 7) + w3cHex.substring(3, 5) + w3cHex.substring(1, 3));
        }

        Coordinate geometryCentroid(Geometry g) {
            if (g instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)g;
                if (gc.getNumGeometries() == 1) {
                    g = gc.getGeometryN(0);
                } else {
                    double maxAreaSoFar = gc.getGeometryN(0).getArea();
                    Coordinate centroidToReturn = gc.getGeometryN(0).getCentroid().getCoordinate();
                    for (int t = 0; t < gc.getNumGeometries(); ++t) {
                        double area = gc.getGeometryN(t).getArea();
                        if (!(area > maxAreaSoFar)) continue;
                        maxAreaSoFar = area;
                        centroidToReturn = gc.getGeometryN(t).getCentroid().getCoordinate();
                    }
                    return centroidToReturn;
                }
            }
            if (g instanceof Point) {
                return g.getCoordinate();
            }
            if (g instanceof LineString) {
                double tol = 1.0E-6;
                double mid = g.getLength() / 2.0;
                Coordinate[] coords = g.getCoordinates();
                double len = 0.0;
                for (int i = 1; i < coords.length; ++i) {
                    LineSegment line = new LineSegment(coords[i - 1], coords[i]);
                    if (Math.abs((len += line.getLength()) - mid) < tol) {
                        return line.getCoordinate(1);
                    }
                    if (!(len > mid)) continue;
                    return line.pointAlong(1.0 - (len - mid) / line.getLength());
                }
                return g.getCentroid().getCoordinate();
            }
            return g.getCentroid().getCoordinate();
        }

        protected void encodePlacemark(SimpleFeature feature, FeatureTypeStyle[] styles) {
            this.encodePlacemark(feature, styles, null);
        }

        protected void encodePlacemark(SimpleFeature feature, FeatureTypeStyle[] styles, Geometry markGeometry) {
            String selfLinks;
            Geometry geometry = this.featureGeometry(feature);
            Coordinate centroid = this.geometryCentroid(geometry);
            this.start("Placemark", KMLUtils.attributes(new String[]{"id", feature.getID()}));
            if (KMLMapTransformer.this.mapContext.getRequest().getKMattr()) {
                String msg;
                try {
                    this.encodePlacemarkName(feature, styles);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'title' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
                try {
                    this.encodePlacemarkSnippet(feature, styles);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'description' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
                try {
                    this.encodePlacemarkDescription(feature, styles);
                }
                catch (Exception e) {
                    msg = "Error occured processing 'description' template.";
                    LOGGER.log(Level.WARNING, msg, e);
                }
            }
            if ((selfLinks = (String)KMLMapTransformer.this.mapContext.getRequest().getFormatOptions().get("selfLinks")) != null && selfLinks.equalsIgnoreCase("true")) {
                GetMapRequest request = KMLMapTransformer.this.mapContext.getRequest();
                String link = "";
                try {
                    link = this.getFeatureTypeURL();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                String[] id = feature.getID().split("\\.");
                link = link + "/" + id[1] + ".kml";
                this.element("atom:link", null, KMLUtils.attributes(new String[]{"rel", "self", "href", link}));
            }
            this.encodePlacemarkLookAt(centroid);
            try {
                this.encodePlacemarkTime(feature, styles);
            }
            catch (Exception e) {
                String msg = "Error occured processing 'time' template: " + e.getMessage();
                LOGGER.log(Level.WARNING, msg);
                LOGGER.log(Level.FINE, "", e);
            }
            this.element("styleUrl", "#GeoServerStyle" + feature.getID());
            this.encodeExtendedData(feature);
            if (markGeometry == null) {
                this.encodePlacemarkGeometry(geometry, centroid, styles);
            } else {
                Coordinate markCentroid = markGeometry.getCoordinate();
                this.start("Point");
                if (!Double.isNaN(markCentroid.z)) {
                    this.element("coordinates", markCentroid.x + "," + markCentroid.y + "," + markCentroid.z);
                } else {
                    this.element("coordinates", markCentroid.x + "," + markCentroid.y);
                }
                this.end("Point");
            }
            this.end("Placemark");
        }

        protected void encodeExtendedData(SimpleFeature feature) {
        }

        protected String getFeatureTypeURL() throws IOException {
            String nsUri = KMLMapTransformer.this.mapLayer.getFeatureSource().getSchema().getName().getNamespaceURI();
            NameSpaceInfo ns = KMLMapTransformer.this.mapContext.getRequest().getWMS().getData().getNameSpaceFromURI(nsUri);
            String featureTypeName = KMLMapTransformer.this.mapLayer.getFeatureSource().getSchema().getName().getLocalPart();
            GetMapRequest request = KMLMapTransformer.this.mapContext.getRequest();
            String baseUrl = request.getHttpServletRequest().getRequestURL().toString();
            int searchIdx = baseUrl.indexOf("rest/geosearch");
            if (searchIdx >= 0) {
                baseUrl = baseUrl.substring(0, searchIdx);
            }
            baseUrl = RequestUtils.proxifiedBaseURL((String)baseUrl, (String)request.getGeoServer().getProxyBaseUrl());
            return baseUrl + "rest/geosearch/" + ns.getPrefix() + "/" + featureTypeName;
        }

        protected void encodePlacemarkTime(SimpleFeature feature, FeatureTypeStyle[] styles) throws IOException {
            try {
                String[] time = new FeatureTimeTemplate(KMLMapTransformer.this.template).execute(feature);
                if (time.length == 0) {
                    return;
                }
                if (time.length == 1) {
                    this.encodeKmlTimeStamp(this.parseDateTime(time[0]));
                } else {
                    this.encodeKmlTimeSpan(this.parseDateTime(time[0]), this.parseDateTime(time[1]));
                }
            }
            catch (Exception e) {
                throw (IOException)new IOException().initCause(e);
            }
        }

        protected void encodeKmlTimeSpan(Date from, Date to) throws Exception {
            String begin = this.encodeDateTime(from);
            String end = this.encodeDateTime(to);
            if (begin != null || end != null) {
                this.start("TimeSpan");
                if (begin != null) {
                    this.element("begin", begin);
                }
                if (end != null) {
                    this.element("end", end);
                }
                this.end("TimeSpan");
            }
        }

        protected void encodeKmlTimeStamp(Date time) throws Exception {
            String datetime = this.encodeDateTime(time);
            if (datetime != null) {
                this.start("TimeStamp");
                this.element("when", datetime);
                this.end("TimeStamp");
            }
        }

        protected String encodeDateTime(Date date) {
            if (date != null) {
                Calendar c = Calendar.getInstance();
                c.setTime(date);
                return new XSDateTimeBinding().encode((Object)c, null);
            }
            return null;
        }

        protected Date parseDateTime(String date) throws Exception {
            Date d = this.parseDate(dtformats, date);
            if (d == null) {
                d = this.parseDate(dformats, date);
            }
            if (d == null) {
                d = this.parseDate(tformats, date);
            }
            if (d == null) {
                try {
                    d = DateUtil.deserializeDateTime((String)date);
                }
                catch (Exception e1) {
                    try {
                        d = DateUtil.deserializeDate((String)date);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
            }
            if (d != null) {
                return d;
            }
            LOGGER.warning("Could not parse date: " + date);
            return null;
        }

        protected Date parseDate(List formats, String date) {
            for (SimpleDateFormat format : formats) {
                Date d = null;
                try {
                    d = format.parse(date);
                }
                catch (ParseException e) {
                    // empty catch block
                }
                if (d == null) continue;
                return d;
            }
            return null;
        }

        protected void encodePlacemarkGeometry(Geometry geometry, Coordinate centroid, FeatureTypeStyle[] styles) {
            if (geometry instanceof Point || geometry instanceof MultiPoint && ((MultiPoint)geometry).getNumPoints() == 1) {
                this.start("Point");
                if (!Double.isNaN(centroid.z)) {
                    this.element("coordinates", centroid.x + "," + centroid.y + "," + centroid.z);
                } else {
                    this.element("coordinates", centroid.x + "," + centroid.y);
                }
                this.end("Point");
            } else {
                this.start("MultiGeometry");
                this.start("Point");
                if (!Double.isNaN(centroid.z)) {
                    this.element("coordinates", centroid.x + "," + centroid.y + "," + centroid.z);
                } else {
                    this.element("coordinates", centroid.x + "," + centroid.y);
                }
                this.end("Point");
                this.encodeGeometry(geometry, styles);
                this.end("MultiGeometry");
            }
        }

        protected void encodeGeometry(Geometry geometry, FeatureTypeStyle[] styles) {
            if (geometry instanceof GeometryCollection) {
                GeometryCollection collection = (GeometryCollection)geometry;
                for (int i = 0; i < collection.getNumGeometries(); ++i) {
                    this.encodeGeometry(collection.getGeometryN(i), styles);
                }
            } else {
                this.geometryTranslator.encode((Object)geometry);
            }
        }

        String featureId(SimpleFeature feature) {
            String id = feature.getID();
            id = id.replaceAll("&", "");
            id = id.replaceAll(">", "");
            id = id.replaceAll("<", "");
            id = id.replaceAll("%", "");
            return id;
        }

        Geometry featureGeometry(SimpleFeature f) {
            Geometry geom = (Geometry)f.getDefaultGeometry();
            return geom;
        }
    }
}

