/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geoserver.platform.ServiceException;
import org.geotools.map.MapLayer;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformer;

public class KMLMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.kml");
    public static final String MIME_TYPE = "application/vnd.google-earth.kml+xml";
    public static final String[] OUTPUT_FORMATS = new String[]{"application/vnd.google-earth.kml+xml", "application/vnd.google-earth.kml", "kml", "application/vnd.google-earth.kml xml"};
    protected KMLTransformer transformer;
    private List<String> aliases = new ArrayList<String>();

    public KMLMapProducer() {
        super(MIME_TYPE, OUTPUT_FORMATS);
    }

    public void abort(Service gs) {
        if (this.transformer != null) {
            // empty if block
        }
    }

    public void abort() {
        LOGGER.fine("aborting KML map response");
        if (this.transformer != null) {
            LOGGER.info("aborting KML encoder");
        }
    }

    public void produceMap() throws WmsException {
        this.transformer = new KMLTransformer();
        this.transformer.setIndentation(3);
        GetMapRequest request = this.mapContext.getRequest();
        WMS wms = request.getWMS();
        Charset encoding = wms.getCharSet();
        this.transformer.setEncoding(encoding);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            this.transformer.transform((Object)this.mapContext, out);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String getContentDisposition() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mapContext.getLayerCount(); ++i) {
            MapLayer layer = this.mapContext.getLayer(i);
            String title = layer.getFeatureSource().getSchema().getName().getLocalPart();
            if (title == null || title.equals("")) continue;
            sb.append(title).append("_");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return "attachment; filename=" + sb.toString() + ".kml";
        }
        return "attachment; filename=geoserver.kml";
    }
}

