/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.map.kml.CachedHierarchyRegionatingStrategy;

public class ExternalSortRegionatingStrategy
extends CachedHierarchyRegionatingStrategy {
    static final SimpleFeatureType IDX_FEATURE_TYPE;
    static Map<Class<?>, String> CLASS_MAPPINGS;
    String attribute;
    FeatureSource fs;
    String h2Type;

    protected final String getDatabaseName(WMSMapContext con, MapLayer layer) throws Exception {
        this.fs = layer.getFeatureSource();
        SimpleFeatureType ft = (SimpleFeatureType)this.fs.getSchema();
        this.checkAttribute(con, ft);
        return super.getDatabaseName(con, layer) + "_" + this.attribute;
    }

    protected void checkAttribute(WMSMapContext con, SimpleFeatureType ft) {
        Map options = con.getRequest().getFormatOptions();
        this.attribute = (String)options.get("regionateAttr");
        if (this.attribute == null) {
            this.attribute = this.typeInfo.getRegionateAttribute();
        }
        if (this.attribute == null) {
            throw new WmsException("Regionating attribute has not been specified");
        }
        AttributeDescriptor ad = ft.getDescriptor(this.attribute);
        if (ad == null) {
            throw new WmsException("Could not find regionating attribute " + this.attribute + " in layer " + this.typeInfo.getName());
        }
        this.h2Type = this.getH2DataType(ad);
        if (this.h2Type == null) {
            throw new WmsException("Attribute type " + ad.getType() + " is not " + "supported for external sorting on " + this.typeInfo.getName() + "#" + this.attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeatureIterator getSortedFeatures(ReferencedEnvelope envelope, Connection cacheConn) throws Exception {
        Statement st = null;
        try {
            st = cacheConn.createStatement();
            try {
                st.executeQuery("SELECT * FROM FEATUREIDX LIMIT 1");
            }
            catch (SQLException e) {
                this.buildIndex(cacheConn);
            }
        }
        finally {
            JDBCUtils.close((Statement)st);
        }
        return new IndexFeatureIterator(cacheConn, envelope);
    }

    protected String getH2DataType(AttributeDescriptor ad) {
        if (String.class.equals((Object)ad.getType().getBinding())) {
            int length = FeatureTypes.getFieldLength((AttributeDescriptor)ad);
            if (length <= 0) {
                length = 255;
            }
            return "VARCHAR(" + length + ")";
        }
        return CLASS_MAPPINGS.get(ad.getType().getBinding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildIndex(Connection conn) throws Exception {
        Statement st = null;
        PreparedStatement ps = null;
        FeatureIterator fi = null;
        try {
            st = conn.createStatement();
            st.execute("CREATE TABLE FEATUREIDX(X NUMBER, Y NUMBER, FID VARCHAR(64), ORDER_FIELD " + this.h2Type + ")");
            st.execute("CREATE INDEX FEATUREIDX_COORDS ON FEATUREIDX(X, Y)");
            st.execute("CREATE INDEX FEATUREIDX_ORDER_FIELD ON FEATUREIDX(ORDER_FIELD)");
            ps = conn.prepareStatement("INSERT INTO FEATUREIDX(X, Y, FID, ORDER_FIELD) VALUES (?, ?, ?, ?)");
            GeometryDescriptor geom = this.fs.getSchema().getGeometryDescriptor();
            CoordinateReferenceSystem nativeCrs = geom.getCoordinateReferenceSystem();
            DefaultQuery q = new DefaultQuery();
            q.setPropertyNames(new String[]{this.attribute, geom.getLocalName()});
            MathTransform tx = null;
            double[] coords = new double[2];
            if (!CRS.equalsIgnoreMetadata((Object)nativeCrs, (Object)WGS84)) {
                tx = CRS.findMathTransform((CoordinateReferenceSystem)nativeCrs, (CoordinateReferenceSystem)WGS84);
            }
            conn.setAutoCommit(false);
            fi = this.fs.getFeatures().features();
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                Geometry g = (Geometry)f.getDefaultGeometry();
                Point centroid = g.getCentroid();
                coords[0] = centroid.getX();
                coords[1] = centroid.getY();
                if (tx != null) {
                    tx.transform(coords, 0, coords, 0, 1);
                }
                ps.setDouble(1, coords[0]);
                ps.setDouble(2, coords[1]);
                ps.setString(3, f.getID());
                ps.setObject(4, this.getSortAttributeValue(f));
                ps.execute();
            }
            conn.commit();
        }
        catch (Throwable throwable) {
            conn.setAutoCommit(true);
            JDBCUtils.close((Statement)st);
            JDBCUtils.close(ps);
            if (fi != null) {
                fi.close();
            }
            throw throwable;
        }
        conn.setAutoCommit(true);
        JDBCUtils.close((Statement)st);
        JDBCUtils.close((Statement)ps);
        if (fi != null) {
            fi.close();
        }
    }

    protected Object getSortAttributeValue(SimpleFeature f) {
        return f.getAttribute(this.attribute);
    }

    static {
        CLASS_MAPPINGS = new LinkedHashMap();
        CLASS_MAPPINGS.put(Boolean.class, "BOOLEAN");
        CLASS_MAPPINGS.put(Byte.class, "TINYINT");
        CLASS_MAPPINGS.put(Short.class, "SMALLINT");
        CLASS_MAPPINGS.put(Character.class, "CHAR");
        CLASS_MAPPINGS.put(Integer.class, "INT");
        CLASS_MAPPINGS.put(Long.class, "BIGINT");
        CLASS_MAPPINGS.put(BigInteger.class, "BIGINT");
        CLASS_MAPPINGS.put(BigDecimal.class, "DECIMAL");
        CLASS_MAPPINGS.put(Float.class, "REAL");
        CLASS_MAPPINGS.put(Double.class, "DOUBLE");
        CLASS_MAPPINGS.put(java.util.Date.class, "DATE");
        CLASS_MAPPINGS.put(Date.class, "DATE");
        CLASS_MAPPINGS.put(Time.class, "TIME");
        CLASS_MAPPINGS.put(Timestamp.class, "TIMESTAMP");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.crs(WGS84);
        tb.add("point", Point.class);
        tb.setName("FeatureCentroids");
        IDX_FEATURE_TYPE = tb.buildFeatureType();
    }

    public static class IndexFeatureIterator
    implements FeatureIterator {
        SimpleFeatureBuilder builder;
        GeometryFactory gf;
        Statement st;
        ResultSet rs;
        boolean nextCalled;
        boolean next;

        public IndexFeatureIterator(Connection cacheConn, ReferencedEnvelope envelope) throws Exception {
            try {
                this.st = cacheConn.createStatement();
                String sql = "SELECT X, Y, FID \nFROM FEATUREIDX\nWHERE X >= " + envelope.getMinX() + "\n" + "AND X <= " + envelope.getMaxX() + "\n" + "AND Y >= " + envelope.getMinY() + "\n" + "AND Y <= " + envelope.getMaxY() + "\n" + "ORDER BY ORDER_FIELD DESC";
                this.rs = this.st.executeQuery(sql);
            }
            catch (SQLException e) {
                this.close();
            }
            this.builder = new SimpleFeatureBuilder(IDX_FEATURE_TYPE);
            this.gf = new GeometryFactory();
        }

        public void close() {
            JDBCUtils.close((ResultSet)this.rs);
            JDBCUtils.close((Statement)this.st);
        }

        public boolean hasNext() {
            if (!this.nextCalled) {
                try {
                    this.next = this.rs.next();
                    this.nextCalled = true;
                }
                catch (SQLException e) {
                    this.close();
                    throw new RuntimeException("Error while accessing next db record", e);
                }
            }
            return this.next;
        }

        public Feature next() throws NoSuchElementException {
            if (!this.nextCalled) {
                this.hasNext();
            }
            this.nextCalled = false;
            try {
                double x = this.rs.getDouble(1);
                double y = this.rs.getDouble(2);
                this.builder.add((Object)this.gf.createPoint(new Coordinate(x, y)));
                return this.builder.buildFeature(this.rs.getString(3));
            }
            catch (SQLException e) {
                this.close();
                throw new RuntimeException("Problems reading the geometry index");
            }
        }
    }
}

