/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.AtomUtils;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class RSSGeoRSSTransformer
extends GeoRSSTransformerBase {
    public Translator createTranslator(ContentHandler handler) {
        return new RSSGeoRSSTranslator(handler);
    }

    class RSSGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        public RSSGeoRSSTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
            this.nsSupport.declarePrefix("georss", "http://www.georss.org/georss");
            this.nsSupport.declarePrefix("atom", "http://www.w3.org/2005/Atom");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "version", "version", null, "2.0");
            this.start("rss", atts);
            this.start("channel");
            this.element("title", AtomUtils.getFeedTitle(map));
            this.element("description", "Feed auto-generated by GeoServer");
            this.start("link");
            this.cdata(AtomUtils.getFeedURL(map));
            this.end("link");
            atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, AtomUtils.getFeedURL(map));
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("atom:link", null, atts);
            try {
                this.encodeItems(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("channel");
            this.end("rss");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeItems(WMSMapContext map) throws IOException {
            List featureCollections = this.loadFeatureCollections(map);
            for (FeatureCollection features : featureCollections) {
                FeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        try {
                            this.encodeItem(feature, map);
                        }
                        catch (Exception e) {
                            GeoRSSTransformerBase.LOGGER.warning("Encoding failed for feature: " + feature.getID());
                            GeoRSSTransformerBase.LOGGER.log(Level.FINE, "", e);
                        }
                    }
                }
                finally {
                    if (iterator == null) continue;
                    features.close(iterator);
                }
            }
        }

        void encodeItem(SimpleFeature feature, WMSMapContext map) throws IOException {
            String msg;
            this.start("item");
            try {
                this.element("title", AtomUtils.getFeatureTitle(feature));
            }
            catch (Exception e) {
                msg = "Error occured executing title template for: " + feature.getID();
                GeoRSSTransformerBase.LOGGER.log(Level.WARNING, msg, e);
            }
            this.start("link");
            this.cdata(AtomUtils.getEntryURL(feature, map));
            this.end("link");
            this.start("guid");
            this.cdata(AtomUtils.getEntryURL(feature, map));
            this.end("guid");
            try {
                this.start("description");
                this.cdata(AtomUtils.getFeatureDescription(feature));
                this.end("description");
            }
            catch (Exception e) {
                msg = "Error occured executing description template for: " + feature.getID();
                GeoRSSTransformerBase.LOGGER.log(Level.WARNING, msg, e);
            }
            this.encodeGeometry(feature);
            this.end("item");
        }
    }
}

