/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.IOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.wms.util.WMSRequests;
import org.geotools.map.MapLayer;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.NameSpaceInfo;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.featureInfo.FeatureTemplate;

public final class AtomUtils {
    private static DateFormat rfc3339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static NumberFormat doubleDigit = new DecimalFormat("00");
    private static FeatureTemplate featureTemplate = new FeatureTemplate();

    private AtomUtils() {
    }

    public static String dateToRFC3339(Date d) {
        StringBuilder result = new StringBuilder(rfc3339.format(d));
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        ((Calendar)cal).setTimeZone(TimeZone.getDefault());
        int offset_millis = cal.get(15) + cal.get(16);
        int offset_hours = Math.abs(offset_millis / 3600000);
        int offset_minutes = Math.abs(offset_millis / 60000 % 60);
        if (offset_millis == 0) {
            result.append("Z");
        } else {
            result.append(offset_millis > 0 ? "+" : "-").append(doubleDigit.format(offset_hours)).append(":").append(doubleDigit.format(offset_minutes));
        }
        return result.toString();
    }

    public static String getEntryURL(SimpleFeature feature, WMSMapContext context) {
        String nsUri = feature.getType().getName().getNamespaceURI();
        NameSpaceInfo ns = context.getRequest().getWMS().getData().getNameSpaceFromURI(nsUri);
        return Requests.getBaseUrl((HttpServletRequest)context.getRequest().getHttpServletRequest(), (GeoServer)context.getRequest().getGeoServer()) + "wms/reflect?format=application/atom+xml&layers=" + ns.getPrefix() + ":" + feature.getType().getTypeName() + "&fid=" + feature.getID();
    }

    public static String getEntryURI(SimpleFeature feature, WMSMapContext context) {
        return AtomUtils.getEntryURL(feature, context);
    }

    public static String getFeatureTitle(SimpleFeature feature) {
        try {
            return featureTemplate.title(feature);
        }
        catch (IOException ioe) {
            return feature.getID();
        }
    }

    public static String getFeatureDescription(SimpleFeature feature) {
        try {
            return featureTemplate.description(feature);
        }
        catch (IOException ioe) {
            return feature.getID();
        }
    }

    public static String getFeedURL(WMSMapContext context) {
        return WMSRequests.getGetMapUrl(context.getRequest(), null, 0, null, null).replace(' ', '+');
    }

    public static String getFeedURI(WMSMapContext context) {
        return AtomUtils.getFeedURL(context);
    }

    public static String getFeedTitle(WMSMapContext context) {
        StringBuffer title = new StringBuffer();
        for (int i = 0; i < context.getLayerCount(); ++i) {
            MapLayer layer = context.getLayer(i);
            title.append(layer.getTitle()).append(",");
        }
        title.setLength(title.length() - 1);
        return title.toString();
    }

    private static String commaSeparatedLayers(WMSMapContext con) {
        StringBuilder layers = new StringBuilder();
        MapLayer[] mapLayers = con.getLayers();
        for (int i = 0; i < mapLayers.length; ++i) {
            layers.append(mapLayers[i].getTitle());
            if (i >= mapLayers.length - 1) continue;
            layers.append(",");
        }
        return layers.toString();
    }
}

