/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.georss;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.georss.AtomUtils;
import org.vfny.geoserver.wms.responses.map.georss.GeoRSSTransformerBase;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class AtomGeoRSSTransformer
extends GeoRSSTransformerBase {
    public Translator createTranslator(ContentHandler handler) {
        return new AtomGeoRSSTranslator(handler);
    }

    public class AtomGeoRSSTranslator
    extends GeoRSSTransformerBase.GeoRSSTranslatorSupport {
        public AtomGeoRSSTranslator(ContentHandler contentHandler) {
            super(AtomGeoRSSTransformer.this, contentHandler, null, "http://www.w3.org/2005/Atom");
            this.nsSupport.declarePrefix("georss", "http://www.georss.org/georss");
        }

        public void encode(Object o) throws IllegalArgumentException {
            WMSMapContext map = (WMSMapContext)((Object)o);
            this.start("feed");
            this.element("title", AtomUtils.getFeedTitle(map));
            this.element("id", AtomUtils.getFeedURI(map));
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, AtomUtils.getFeedURL(map));
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("link", null, atts);
            this.element("updated", AtomUtils.dateToRFC3339(new Date()));
            try {
                this.encodeEntries(map);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.end("feed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void encodeEntries(WMSMapContext map) throws IOException {
            List featureCollections = this.loadFeatureCollections(map);
            for (FeatureCollection features : featureCollections) {
                FeatureIterator iterator = null;
                try {
                    iterator = features.features();
                    while (iterator.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        try {
                            this.encodeEntry(feature, map);
                        }
                        catch (Exception e) {
                            GeoRSSTransformerBase.LOGGER.warning("Encoding failed for feature: " + feature.getID());
                            GeoRSSTransformerBase.LOGGER.log(Level.FINE, "", e);
                        }
                    }
                }
                finally {
                    if (iterator == null) continue;
                    features.close(iterator);
                }
            }
        }

        void encodeEntry(SimpleFeature feature, WMSMapContext map) {
            this.start("entry");
            this.element("title", feature.getID());
            this.start("author");
            this.element("name", map.getRequest().getGeoServer().getContactPerson());
            this.end("author");
            this.element("id", AtomUtils.getEntryURI(feature, map));
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute(null, "href", "href", null, AtomUtils.getEntryURL(feature, map));
            atts.addAttribute(null, "rel", "rel", null, "self");
            this.element("link", null, atts);
            this.element("updated", AtomUtils.dateToRFC3339(new Date()));
            atts = new AttributesImpl();
            atts.addAttribute(null, "type", "type", null, "html");
            this.element("content", AtomUtils.getFeatureDescription(feature), atts);
            this.start("georss:where");
            this.encodeGeometry(feature);
            this.end("georss:where");
            this.end("entry");
        }
    }
}

