/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.helpers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.xalan.transformer.TransformerIdentityImpl;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.FeatureTypeInfoTitleComparator;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.LegendURL;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.helpers.LayerTree;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSCapsTransformer
extends TransformerBase {
    public static final String WMS_CAPS_MIME = "application/vnd.ogc.wms_xml";
    private String baseUrl;
    private Set<String> formats;
    private ApplicationContext applicationContext;

    public WMSCapsTransformer(String baseUrl, Set<String> formats, ApplicationContext applicationContext) {
        this.formats = formats;
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        this.baseUrl = baseUrl;
        this.setNamespaceDeclarationEnabled(false);
        this.applicationContext = applicationContext;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CapabilitiesTranslator(handler, this.formats, this.applicationContext);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        GeoServer gs = (GeoServer)GeoServerExtensions.extensions(GeoServer.class, (ApplicationContext)this.applicationContext).get(0);
        String dtdUrl = RequestUtils.proxifiedBaseURL((String)this.baseUrl, (String)gs.getProxyBaseUrl()) + "schemas/wms/1.1.1/WMS_MS_Capabilities.dtd";
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private static class CapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTranslator.class.getPackage().getName());
        private static final String EPSG = "EPSG:";
        private static AttributesImpl wmsVersion = new AttributesImpl();
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        private CapabilitiesRequest request;
        private Set formats;
        private ApplicationContext applicationContext;

        public CapabilitiesTranslator(ContentHandler handler, Set formats, ApplicationContext applicationContext) {
            super(handler, null, null);
            this.formats = formats;
            this.applicationContext = applicationContext;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof CapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (CapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append(this.request).toString());
            }
            WMS wms = (WMS)this.request.getServiceConfig();
            AttributesImpl rootAtts = new AttributesImpl(wmsVersion);
            rootAtts.addAttribute("", "updateSequence", "updateSequence", "", wms.getGeoServer().getUpdateSequence() + "");
            this.start("WMT_MS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMT_MS_Capabilities");
        }

        private void handleService() {
            WMS wms = (WMS)this.request.getServiceConfig();
            this.start("Service");
            this.element("Name", "OGC:WMS");
            this.element("Title", wms.getTitle());
            this.element("Abstract", wms.getAbstract());
            this.handleKeywordList(wms.getKeywords());
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)wms.getGeoServer().getProxyBaseUrl()) + "wms");
            this.element("OnlineResource", null, orAtts);
            this.handleContactInfo(wms.getGeoServer());
            this.element("Fees", wms.getFees());
            this.element("AccessConstraints", wms.getAccessConstraints());
            this.end("Service");
        }

        public void handleContactInfo(GeoServer geoServer) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", geoServer.getContactPerson());
            this.element("ContactOrganization", geoServer.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", geoServer.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", geoServer.getAddressType());
            this.element("Address", geoServer.getAddress());
            this.element("City", geoServer.getAddressCity());
            this.element("StateOrProvince", geoServer.getAddressState());
            this.element("PostCode", geoServer.getAddressPostalCode());
            this.element("Country", geoServer.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", geoServer.getContactVoice());
            this.element("ContactFacsimileTelephone", geoServer.getContactFacsimile());
            this.element("ContactElectronicMailAddress", geoServer.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                Iterator it = keywords.iterator();
                while (it.hasNext()) {
                    this.element("Keyword", String.valueOf(it.next()));
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(List metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetaDataLink link : metadataURLs) {
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", link.getContent());
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleSLD();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", WMSCapsTransformer.WMS_CAPS_MIME);
            String serviceUrl = RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)this.request.getServiceConfig().getGeoServer().getProxyBaseUrl()) + "wms?SERVICE=WMS&";
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            ArrayList<String> sortedFormats = new ArrayList<String>(this.formats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            Iterator it = sortedFormats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            it = GetFeatureInfoResponse.getFormats().iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetFeatureInfo");
            this.start("DescribeLayer");
            this.element("Format", WMSCapsTransformer.WMS_CAPS_MIME);
            this.handleDcpType(serviceUrl, null);
            this.end("DescribeLayer");
            this.start("GetLegendGraphic");
            it = GetLegendGraphicResponse.getFormats(this.applicationContext).iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetLegendGraphic");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(2, "", "xlink:href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            WMS wms = (WMS)this.request.getServiceConfig();
            Iterator<String> it = Arrays.asList(wms.getExceptionFormats()).iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.end("Exception");
        }

        private void handleSLD() {
            AttributesImpl sldAtts = new AttributesImpl();
            WMS config = (WMS)this.request.getServiceConfig();
            String supportsSLD = config.supportsSLD() ? "1" : "0";
            String supportsUserLayer = config.supportsUserLayer() ? "1" : "0";
            String supportsUserStyle = config.supportsUserStyle() ? "1" : "0";
            String supportsRemoteWFS = config.supportsRemoteWFS() ? "1" : "0";
            sldAtts.addAttribute("", "SupportSLD", "SupportSLD", "", supportsSLD);
            sldAtts.addAttribute("", "UserLayer", "UserLayer", "", supportsUserLayer);
            sldAtts.addAttribute("", "UserStyle", "UserStyle", "", supportsUserStyle);
            sldAtts.addAttribute("", "RemoteWFS", "RemoteWFS", "", supportsRemoteWFS);
            this.start("UserDefinedSymbolization", sldAtts);
            this.end("UserDefinedSymbolization");
        }

        private void handleLayers() {
            WMS wms = (WMS)this.request.getServiceConfig();
            this.start("Layer");
            Data catalog = wms.getData();
            Collection ftypes = catalog.getFeatureTypeInfos().values();
            Collection coverages = catalog.getCoverageInfos().values();
            this.element("Title", wms.getTitle());
            this.element("Abstract", wms.getAbstract());
            this.handleRootCrsList(wms.getCapabilitiesCrsList());
            ArrayList layers = new ArrayList(ftypes.size() + coverages.size());
            layers.addAll(ftypes);
            layers.addAll(coverages);
            this.handleRootBbox(layers);
            LayerTree featuresLayerTree = new LayerTree(ftypes);
            this.handleFeaturesTree(featuresLayerTree);
            LayerTree coveragesLayerTree = new LayerTree(coverages);
            this.handleCoveragesTree(coveragesLayerTree);
            try {
                this.handleLayerGroups(wms.getBaseMapLayers(), wms.getBaseMapStyles(), wms.getBaseMapEnvelopes());
            }
            catch (FactoryException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            catch (TransformException e) {
                throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
            }
            this.end("Layer");
        }

        private void handleRootCrsList(Set epsgCodes) {
            TreeSet capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = CRS.getSupportedCodes((String)"EPSG");
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new TreeSet(epsgCodes);
            }
            try {
                Iterator it = capabilitiesCrsIdentifiers.iterator();
                while (it.hasNext()) {
                    String currentSRS = it.next().toString();
                    if (currentSRS.indexOf(58) == -1) {
                        currentSRS = EPSG + currentSRS;
                    }
                    this.element("SRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private void handleRootBbox(Collection ftypes) {
            Envelope latlonBbox = new Envelope();
            Envelope layerBbox = null;
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (Object layer : ftypes) {
                if (layer instanceof FeatureTypeInfo) {
                    FeatureTypeInfo vectorLayer = (FeatureTypeInfo)layer;
                    if (!vectorLayer.isEnabled()) continue;
                    try {
                        layerBbox = vectorLayer.getLatLongBoundingBox();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Can't obtain latLonBBox of " + vectorLayer.getName() + ": " + e.getMessage(), e);
                    }
                } else {
                    CoverageInfo rasterLayer = (CoverageInfo)layer;
                    if (!rasterLayer.isEnabled()) continue;
                    GeneralEnvelope bbox = rasterLayer.getWGS84LonLatEnvelope();
                    if (bbox != null) {
                        layerBbox = new Envelope(bbox.getLowerCorner().getOrdinate(0), bbox.getUpperCorner().getOrdinate(0), bbox.getLowerCorner().getOrdinate(1), bbox.getUpperCorner().getOrdinate(1));
                    }
                }
                latlonBbox.expandToInclude(layerBbox);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleLatLonBBox(latlonBbox);
        }

        private void handleFeaturesTree(LayerTree featuresLayerTree) {
            ArrayList data = new ArrayList(featuresLayerTree.getData());
            Collection childrens = featuresLayerTree.getChildrens();
            Collections.sort(data, new FeatureTypeInfoTitleComparator());
            for (FeatureTypeInfo fLayer : data) {
                try {
                    if (!fLayer.isEnabled() || fLayer.isGeometryless()) continue;
                    this.handleFeatureType(fLayer);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) continue;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            for (LayerTree layerTree : childrens) {
                this.start("Layer");
                this.element("Name", layerTree.getName());
                this.element("Title", layerTree.getName());
                this.handleFeaturesTree(layerTree);
                this.end("Layer");
            }
        }

        protected void handleFeatureType(FeatureTypeInfo ftype) {
            block5: {
                AttributesImpl qatts = new AttributesImpl();
                qatts.addAttribute("", "queryable", "queryable", "", "1");
                this.start("Layer", qatts);
                this.element("Name", ftype.getName());
                this.element("Title", ftype.getTitle());
                this.element("Abstract", ftype.getAbstract());
                this.handleKeywordList(ftype.getKeywords());
                this.element("SRS", EPSG + ftype.getSRS());
                try {
                    CoordinateReferenceSystem crs = CRS.decode((String)(EPSG + ftype.getSRS()));
                    String desc = "WKT definition of this CRS:\n" + crs;
                    this.comment(desc);
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block5;
                    LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
                }
            }
            ReferencedEnvelope bbox = null;
            Envelope llbbox = null;
            try {
                bbox = ftype.getBoundingBox();
                llbbox = ftype.getLatLongBoundingBox();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't obtain latLongBBox of " + ftype.getName() + ": " + ex.getMessage(), ex);
            }
            this.handleLatLonBBox(llbbox);
            this.handleBBox((Envelope)bbox, EPSG + ftype.getSRS());
            this.handleMetadataList(ftype.getMetadataLinks());
            this.start("Style");
            Style ftStyle2 = ftype.getDefaultStyle();
            this.element("Name", ftStyle2.getName());
            this.element("Title", ftStyle2.getTitle());
            this.element("Abstract", ftStyle2.getAbstract());
            this.handleLegendURL(ftype);
            this.end("Style");
            ArrayList styles = ftype.getStyles();
            for (Style ftStyle2 : styles) {
                this.start("Style");
                this.element("Name", ftStyle2.getName());
                this.element("Title", ftStyle2.getTitle());
                this.element("Abstract", ftStyle2.getAbstract());
                this.handleLegendURL(ftype);
                this.end("Style");
            }
            this.end("Layer");
        }

        private void handleCoveragesTree(LayerTree coveragesLayerTree) {
            ArrayList data = new ArrayList(coveragesLayerTree.getData());
            Collection childrens = coveragesLayerTree.getChildrens();
            Collections.sort(data, new CoverageInfoLabelComparator());
            for (CoverageInfo cLayer : data) {
                if (!cLayer.isEnabled()) continue;
                this.handleCoverage(cLayer);
            }
            for (LayerTree layerTree : childrens) {
                this.start("Layer");
                this.element("Name", layerTree.getName());
                this.element("Title", layerTree.getName());
                this.handleCoveragesTree(layerTree);
                this.end("Layer");
            }
        }

        protected void handleCoverage(CoverageInfo coverage) {
            String desc;
            AttributesImpl qatts = new AttributesImpl();
            qatts.addAttribute("", "queryable", "queryable", "", "1");
            this.start("Layer", qatts);
            this.element("Name", coverage.getName());
            this.element("Title", coverage.getLabel());
            this.element("Abstract", coverage.getDescription());
            this.handleKeywordList(coverage.getKeywords());
            CoordinateReferenceSystem crs = coverage.getCrs();
            try {
                String publishedCoverageCrsWKT = crs.toWKT();
                desc = "WKT definition of this CRS:\n" + publishedCoverageCrsWKT;
            }
            catch (UnformattableObjectException e) {
                desc = "Unable to get the WKT representation for the coverage crs: " + coverage.getSrsName();
            }
            this.comment(desc);
            String authority = coverage.getSrsName();
            this.element("SRS", authority);
            GeneralEnvelope bounds = null;
            GeneralEnvelope llBounds = null;
            GeneralEnvelope latLonEnvelope = coverage.getWGS84LonLatEnvelope();
            bounds = coverage.getEnvelope();
            llBounds = latLonEnvelope;
            Envelope bbox = new Envelope(bounds.getLowerCorner().getOrdinate(0), bounds.getUpperCorner().getOrdinate(0), bounds.getLowerCorner().getOrdinate(1), bounds.getUpperCorner().getOrdinate(1));
            Envelope llBbox = new Envelope(llBounds.getLowerCorner().getOrdinate(0), llBounds.getUpperCorner().getOrdinate(0), llBounds.getLowerCorner().getOrdinate(1), llBounds.getUpperCorner().getOrdinate(1));
            this.handleLatLonBBox(llBbox);
            this.handleBBox(bbox, authority);
            this.start("Style");
            Style cvStyle2 = coverage.getDefaultStyle();
            this.element("Name", cvStyle2.getName());
            this.element("Title", cvStyle2.getTitle());
            this.element("Abstract", cvStyle2.getAbstract());
            this.handleLegendURL(coverage);
            this.end("Style");
            ArrayList styles = coverage.getStyles();
            for (Style cvStyle2 : styles) {
                this.start("Style");
                this.element("Name", cvStyle2.getName());
                this.element("Title", cvStyle2.getTitle());
                this.element("Abstract", cvStyle2.getAbstract());
                this.handleLegendURL(coverage);
                this.end("Style");
            }
            this.end("Layer");
        }

        protected void handleLayerGroups(Map baseMapLayers, Map baseMapStyles, Map baseMapEnvelopes) throws FactoryException, TransformException {
            if (baseMapLayers == null) {
                return;
            }
            ArrayList names = new ArrayList(baseMapLayers.keySet());
            Collections.sort(names);
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            for (String layerName : names) {
                AttributesImpl qatts = new AttributesImpl();
                qatts.addAttribute("", "queryable", "queryable", "", "0");
                this.start("Layer", qatts);
                this.element("Name", layerName);
                this.element("Title", layerName);
                this.element("Abstract", "Layer-Group type layer: " + layerName);
                GeneralEnvelope bounds = (GeneralEnvelope)baseMapEnvelopes.get(layerName);
                GeneralEnvelope llBounds = null;
                String authority = bounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
                this.element("SRS", authority);
                if (CRS.equalsIgnoreMetadata((Object)wgs84, (Object)bounds.getCoordinateReferenceSystem())) {
                    llBounds = bounds;
                } else {
                    try {
                        MathTransform srcCRStoWGS84 = CRS.findMathTransform((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)wgs84, (boolean)true);
                        GeneralEnvelope latLonEnvelope = CRS.transform((MathTransform)srcCRStoWGS84, (org.opengis.geometry.Envelope)bounds);
                        latLonEnvelope.setCoordinateReferenceSystem(wgs84);
                        llBounds = latLonEnvelope;
                    }
                    catch (TransformException e) {
                        throw new WmsException("Cannot transform envelope to WGS84 for layer group " + layerName, "TransformException", (Exception)((Object)e));
                    }
                }
                Envelope bbox = new Envelope(bounds.getLowerCorner().getOrdinate(0), bounds.getUpperCorner().getOrdinate(0), bounds.getLowerCorner().getOrdinate(1), bounds.getUpperCorner().getOrdinate(1));
                Envelope llBbox = new Envelope(llBounds.getLowerCorner().getOrdinate(0), llBounds.getUpperCorner().getOrdinate(0), llBounds.getLowerCorner().getOrdinate(1), llBounds.getUpperCorner().getOrdinate(1));
                this.handleLatLonBBox(llBbox);
                this.handleBBox(bbox, authority);
                this.end("Layer");
            }
        }

        protected void handleLegendURL(Object layer) {
            LegendURL legend = null;
            String layerName = null;
            if (layer instanceof FeatureTypeInfo) {
                legend = ((FeatureTypeInfo)layer).getLegendURL();
                layerName = ((FeatureTypeInfo)layer).getName();
            } else if (layer instanceof CoverageInfo) {
                layerName = ((CoverageInfo)layer).getName();
            }
            if (legend != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(legend.getWidth()));
                attrs.addAttribute("", "height", "height", "", String.valueOf(legend.getHeight()));
                this.start("LegendURL", attrs);
                this.element("Format", legend.getFormat());
                attrs.clear();
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", legend.getOnlineResource());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            } else {
                String defaultFormat = "image/png";
                if (!GetLegendGraphicResponse.supportsFormat(defaultFormat, this.applicationContext)) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                    }
                    return;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", "width", "width", "", String.valueOf(20));
                attrs.addAttribute("", "height", "height", "", String.valueOf(20));
                this.start("LegendURL", attrs);
                this.element("Format", defaultFormat);
                attrs.clear();
                StringBuffer onlineResource = new StringBuffer(RequestUtils.proxifiedBaseURL((String)this.request.getBaseUrl(), (String)this.request.getServiceConfig().getGeoServer().getProxyBaseUrl()));
                onlineResource.append("wms/GetLegendGraphic?VERSION=");
                onlineResource.append("1.0.0");
                onlineResource.append("&FORMAT=");
                onlineResource.append(defaultFormat);
                onlineResource.append("&WIDTH=");
                onlineResource.append(20);
                onlineResource.append("&HEIGHT=");
                onlineResource.append(20);
                onlineResource.append("&LAYER=");
                onlineResource.append(layerName);
                attrs.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                attrs.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                attrs.addAttribute(XLINK_NS, "href", "xlink:href", "", onlineResource.toString());
                this.element("OnlineResource", null, attrs);
                this.end("LegendURL");
            }
        }

        private void handleLatLonBBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLonBoundingBox", null, bboxAtts);
        }

        public void comment(String comment) {
            if (this.contentHandler instanceof TransformerIdentityImpl) {
                try {
                    TransformerIdentityImpl ch = (TransformerIdentityImpl)this.contentHandler;
                    ch.comment(comment.toCharArray(), 0, comment.length());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void handleBBox(Envelope bbox, String SRS) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "SRS", "SRS", "", SRS);
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }

        static {
            wmsVersion.addAttribute("", "version", "version", "", "1.1.1");
        }
    }
}

