/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.geotools.util.SoftValueHashMap;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.requests.GetMapRequest;

public class WatermarkPainter {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.wms.responses");
    public static final Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final int TRANSPARENT_CODE = 0xFFFFFF;
    private static final Map<URL, LogoCacheEntry> logoCache = new SoftValueHashMap();
    protected GetMapRequest request;

    public WatermarkPainter(GetMapRequest request) {
        this.request = request;
    }

    public void paint(Graphics2D g2D, Rectangle paintArea) throws MalformedURLException, ClassCastException, IOException {
        BufferedImage logo = this.getLogo();
        if (logo != null) {
            WMS wms = this.request.getWMS();
            this.paintLogo(g2D, logo, paintArea, wms.getWatermarkTransparency(), wms.getWatermarkPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintLogo(Graphics2D graphics, BufferedImage logo, Rectangle tile, int watermarkTransparency, int watermarkPosition) {
        int logoWidth = logo.getWidth();
        int logoHeight = logo.getHeight();
        Composite oldComposite = graphics.getComposite();
        try {
            float alpha = (float)((100.0 - (double)watermarkTransparency) / 100.0);
            graphics.setComposite(AlphaComposite.getInstance(3, alpha));
            double tx = tile.getMinX();
            double ty = tile.getMinY();
            if (watermarkPosition == WMS.WATERMARK_UC) {
                tx += (tile.getWidth() - (double)logo.getWidth()) / 2.0;
            } else if (watermarkPosition == WMS.WATERMARK_UR) {
                tx += tile.getWidth() - (double)logo.getWidth();
            } else if (watermarkPosition == WMS.WATERMARK_CL) {
                ty += (tile.getHeight() - (double)logo.getHeight()) / 2.0;
            } else if (watermarkPosition == WMS.WATERMARK_CC) {
                ty += (tile.getHeight() - (double)logo.getHeight()) / 2.0;
                tx += (tile.getWidth() - (double)logo.getWidth()) / 2.0;
            } else if (watermarkPosition == WMS.WATERMARK_CR) {
                ty += (tile.getHeight() - (double)logo.getHeight()) / 2.0;
                tx += tile.getWidth() - (double)logo.getWidth();
            } else if (watermarkPosition == WMS.WATERMARK_LL) {
                ty += tile.getHeight() - (double)logo.getHeight();
            } else if (watermarkPosition == WMS.WATERMARK_LC) {
                ty += tile.getHeight() - (double)logo.getHeight();
                tx += (tile.getWidth() - (double)logo.getWidth()) / 2.0;
            } else if (watermarkPosition == WMS.WATERMARK_LR) {
                ty += tile.getHeight() - (double)logo.getHeight();
                tx += tile.getWidth() - (double)logo.getWidth();
            }
            graphics.drawRenderedImage(logo, AffineTransform.getTranslateInstance(tx, ty));
        }
        finally {
            graphics.setComposite(oldComposite);
        }
    }

    protected BufferedImage getLogo() throws IOException {
        BufferedImage logo = null;
        if (this.request.getWMS().isGlobalWatermarking()) {
            URL url = null;
            try {
                File file;
                String globalWatermarkingURL = this.request.getWMS().getGlobalWatermarkingURL();
                url = new URL(globalWatermarkingURL);
                if ((url.getProtocol() == null || url.getProtocol().equals("file")) && (file = GeoserverDataDirectory.findDataFile((String)globalWatermarkingURL)).exists()) {
                    url = file.toURL();
                }
            }
            catch (MalformedURLException e) {
                url = null;
            }
            if (url == null) {
                return null;
            }
            LogoCacheEntry entry = logoCache.get(url);
            if (entry == null || entry.isExpired()) {
                logo = ImageIO.read(url);
                if (url.getProtocol().equals("file")) {
                    entry = new LogoCacheEntry(logo, new File(url.getFile()));
                    logoCache.put(url, entry);
                }
            } else {
                logo = entry.getLogo();
            }
        }
        return logo;
    }

    private static class LogoCacheEntry {
        private BufferedImage logo;
        private long lastModified;
        private File file;

        public LogoCacheEntry(BufferedImage logo, File file) {
            this.logo = logo;
            this.file = file;
            this.lastModified = file.lastModified();
        }

        public boolean isExpired() {
            return this.file.lastModified() > this.lastModified;
        }

        public BufferedImage getLogo() {
            return this.logo;
        }
    }
}

