/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.operator.LookupDescriptor;
import org.geoserver.platform.ServiceException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractRasterMapProducer;
import org.vfny.geoserver.wms.responses.ImageUtils;
import org.vfny.geoserver.wms.responses.PaletteExtractor;
import org.vfny.geoserver.wms.responses.WatermarkPainter;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileMapProducer;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public abstract class DefaultRasterMapProducer
extends AbstractRasterMapProducer
implements RasterMapProducer {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    private static LookupTableJAI IDENTITY_TABLE = new LookupTableJAI(DefaultRasterMapProducer.getTable());
    private WMS wms;
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map");
    private static final String DEFAULT_MAP_FORMAT = "image/png";
    private WatermarkPainter wmPainter;

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public DefaultRasterMapProducer() {
        this(DEFAULT_MAP_FORMAT, (WMS)null);
    }

    public DefaultRasterMapProducer(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public DefaultRasterMapProducer(String mime, WMS wms) {
        super(mime);
        this.wms = wms;
    }

    public DefaultRasterMapProducer(String mime, String[] outputFormats, WMS wms) {
        super(mime, outputFormats);
        this.wms = wms;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.formatImageOutputStream(this.image, out);
    }

    public void produceMap() throws WmsException {
        GetMapRequest request;
        String antialias;
        int width = this.mapContext.getMapWidth();
        int height = this.mapContext.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(new StringBuffer("setting up ").append(width).append("x").append(height).append(" image").toString());
        }
        if ((antialias = (String)(request = this.mapContext.getRequest()).getFormatOptions().get("antialias")) != null) {
            antialias = antialias.toUpperCase();
        }
        IndexColorModel palette = null;
        InverseColorMapOp paletteInverter = this.mapContext.getPaletteInverter();
        boolean transparent = this.mapContext.isTransparent();
        Color bgColor = this.mapContext.getBgColor();
        if (paletteInverter != null && AA_NONE.equals(antialias)) {
            palette = paletteInverter.getIcm();
        } else if (AA_NONE.equals(antialias)) {
            PaletteExtractor pe = new PaletteExtractor(transparent ? null : bgColor);
            MapLayer[] layers = this.mapContext.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                pe.visit(layers[i].getStyle());
                if (!pe.canComputePalette()) break;
            }
            if (pe.canComputePalette()) {
                palette = pe.getPalette();
            }
        }
        boolean useAlpha = transparent || MetatileMapProducer.isRequestTiled(request, this);
        RenderedImage preparedImage = this.prepareImage(width, height, palette, useAlpha);
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        Graphics2D graphic = ImageUtils.prepareTransparency(transparent, bgColor, preparedImage, hintsMap);
        if (AA_NONE.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (preparedImage.getColorModel() instanceof IndexColorModel) {
                hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
        } else if (AA_TEXT.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            if (antialias != null && !AA_FULL.equals(antialias)) {
                LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + AA_SETTINGS);
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.wms != null && "Nearest".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
            hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        } else if (this.wms != null && "Bilinear".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
            hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        } else if (this.wms != null && "Bicubic".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
            hintsMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        }
        hintsMap.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphic.setRenderingHints(hintsMap);
        Rectangle paintArea = new Rectangle(width, height);
        RenderingHints hints = new RenderingHints(hintsMap);
        this.renderer = new ShapefileRenderer();
        this.renderer.setContext((MapContext)this.mapContext);
        this.renderer.setJava2DHints(hints);
        if (this.renderer instanceof ShapefileRenderer && LOGGER.isLoggable(Level.FINE)) {
            this.renderer.addRenderListener(new RenderListener(){

                public void featureRenderer(SimpleFeature feature) {
                }

                public void errorOccurred(Exception e) {
                    LOGGER.log(Level.FINE, "Rendering error occurred", e);
                }
            });
        }
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
        rendererParams.put("maxFiltersToSendToDatastore", new Integer(20));
        rendererParams.put("scaleComputationMethod", "OGC");
        if (AA_NONE.equals(antialias)) {
            rendererParams.put("textRenderingMethod", "STRING");
        } else {
            rendererParams.put("textRenderingMethod", "OUTLINE");
        }
        boolean kmplacemark = false;
        if (this.mapContext.getRequest().getFormatOptions().get("kmplacemark") != null) {
            kmplacemark = (Boolean)this.mapContext.getRequest().getFormatOptions().get("kmplacemark");
        }
        if (kmplacemark) {
            DuplicatingStyleVisitor dupVisitor = new DuplicatingStyleVisitor(){

                public void visit(PointSymbolizer ps) {
                    this.pages.push(null);
                }

                public void visit(TextSymbolizer ts) {
                    this.pages.push(null);
                }
            };
            MapLayer[] layers = this.mapContext.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                Style style = layers[i].getStyle();
                style.accept((StyleVisitor)dupVisitor);
                Style copy = (Style)dupVisitor.getCopy();
                layers[i].setStyle(copy);
            }
        }
        this.renderer.setRendererHints(rendererParams);
        if (this.abortRequested) {
            graphic.dispose();
            return;
        }
        ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
        this.renderer.paint(graphic, paintArea, dataArea);
        try {
            if (this.wmPainter != null) {
                this.wmPainter.paint(graphic, paintArea);
            }
        }
        catch (Exception e) {
            throw new WmsException("Problem occurred while trying to watermark data", "", e);
        }
        graphic.dispose();
        if (!this.abortRequested) {
            this.image = palette != null && palette.getMapSize() < 256 ? this.optimizeSampleModel(preparedImage) : preparedImage;
        }
    }

    public void setWmPainter(WatermarkPainter wmPainter) {
        this.wmPainter = wmPainter;
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        return ImageUtils.createImage(width, height, palette, transparent);
    }

    protected RenderedImage forceIndexed8Bitmask(RenderedImage originalImage) {
        return ImageUtils.forceIndexed8Bitmask(originalImage, this.mapContext.getPaletteInverter());
    }

    private RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)IDENTITY_TABLE, (RenderingHints)hints);
    }
}

