/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.renderer.GTRenderer;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WMSMapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGetMapProducer
implements GetMapProducer {
    protected WMSMapContext mapContext;
    protected boolean abortRequested;
    protected GTRenderer renderer;
    private String requestedOutputFormat;
    private final String mime;
    private final Set<String> outputFormatNames;

    protected AbstractGetMapProducer(String mime, String outputFormat) {
        this(mime, new String[]{outputFormat});
    }

    protected AbstractGetMapProducer(String mime, String[] outputFormats) {
        this.mime = mime;
        if (outputFormats == null) {
            this.outputFormatNames = Collections.emptySet();
        } else {
            TreeSet<String> names = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            names.addAll(Arrays.asList(outputFormats));
            this.outputFormatNames = Collections.unmodifiableSet(names);
        }
    }

    protected AbstractGetMapProducer() {
        this(null, (String[])null);
    }

    @Override
    public void setMapContext(WMSMapContext mapContext) {
        this.mapContext = mapContext;
    }

    @Override
    public WMSMapContext getMapContext() {
        return this.mapContext;
    }

    @Override
    public void abort() {
        this.abortRequested = true;
        if (this.renderer != null) {
            this.renderer.stopRendering();
        }
    }

    public String getContentEncoding() {
        return null;
    }

    @Override
    public String getContentType() {
        return this.mime;
    }

    @Override
    public String getOutputFormat() {
        return this.requestedOutputFormat == null ? this.getContentType() : this.requestedOutputFormat;
    }

    @Override
    public void setOutputFormat(String outputFormat) {
        if (!this.outputFormatNames.contains(outputFormat)) {
            throw new IllegalArgumentException(outputFormat + " is not a recognized output " + "format for " + this.getClass().getSimpleName());
        }
        this.requestedOutputFormat = outputFormat;
    }

    @Override
    public String getContentDisposition() {
        return null;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.outputFormatNames;
    }
}

