/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geoserver.ows.util.CaseInsensitiveMap;
import org.geotools.styling.Style;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.requests.WMSRequest;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public class GetMapRequest
extends WMSRequest {
    static final Color DEFAULT_BG = Color.white;
    public static final String SE_XML = "SE_XML";
    private static final String TRANSACTION_REQUEST_TYPE = "GetMap";
    private MandatoryParameters mandatoryParams = new MandatoryParameters();
    private OptionalParameters optionalParams = new OptionalParameters();
    private Map formatOptions = new CaseInsensitiveMap(new HashMap());
    private Map rawKvp;

    public GetMapRequest(WMS wms) {
        super(TRANSACTION_REQUEST_TYPE, wms);
    }

    public Envelope getBbox() {
        return this.mandatoryParams.bbox;
    }

    public Color getBgColor() {
        return this.optionalParams.bgColor;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.optionalParams.crs;
    }

    public String getSRS() {
        return this.optionalParams.srs;
    }

    public String getExceptions() {
        return this.optionalParams.exceptions;
    }

    public String getFormat() {
        return this.mandatoryParams.format;
    }

    public Map getFormatOptions() {
        return this.formatOptions;
    }

    public int getHeight() {
        return this.mandatoryParams.height;
    }

    public MapLayerInfo[] getLayers() {
        return this.mandatoryParams.layers;
    }

    public List getStyles() {
        return this.mandatoryParams.styles;
    }

    public URL getSld() {
        return this.optionalParams.sld;
    }

    public String getSldBody() {
        return this.optionalParams.sldBody;
    }

    public Boolean getValidateSchema() {
        return this.optionalParams.validateSLD;
    }

    public List getFilters() {
        return this.optionalParams.filters;
    }

    public List getFilter() {
        return this.optionalParams.filters;
    }

    public List getCQLFilter() {
        return this.optionalParams.cqlFilters;
    }

    public List getFeatureId() {
        return this.optionalParams.featureIds;
    }

    public boolean isTransparent() {
        return this.optionalParams.transparent;
    }

    public boolean isTiled() {
        return this.optionalParams.tiled;
    }

    public Point2D getTilesOrigin() {
        return this.optionalParams.tilesOrigin;
    }

    public int getBuffer() {
        return this.optionalParams.buffer;
    }

    public InverseColorMapOp getPalette() {
        return this.optionalParams.paletteInverter;
    }

    public int getWidth() {
        return this.mandatoryParams.width;
    }

    public int getKMScore() {
        Integer kmscore = (Integer)this.getFormatOptions().get("kmscore");
        if (kmscore != null) {
            return kmscore;
        }
        return 40;
    }

    public boolean getKMattr() {
        Boolean kmattr = (Boolean)this.getFormatOptions().get("kmattr");
        if (kmattr != null) {
            return kmattr;
        }
        return true;
    }

    public boolean getSuperOverlay() {
        Boolean superOverlay = (Boolean)this.getFormatOptions().get("superoverlay");
        if (superOverlay != null) {
            return superOverlay;
        }
        return false;
    }

    public boolean getLegend() {
        Boolean legend = (Boolean)this.getFormatOptions().get("legend");
        if (legend != null) {
            return legend;
        }
        return false;
    }

    public List getTime() {
        return this.optionalParams.time;
    }

    public Integer getElevation() {
        return this.optionalParams.elevation;
    }

    public String getFeatureVersion() {
        return this.optionalParams.featureVersion;
    }

    public String getRemoteOwsType() {
        return this.optionalParams.remoteOwsType;
    }

    public URL getRemoteOwsURL() {
        return this.optionalParams.remoteOwsURL;
    }

    public Map getRawKvp() {
        return this.rawKvp;
    }

    public void setBbox(Envelope bbox) {
        this.mandatoryParams.bbox = bbox;
    }

    public void setBgColor(Color bgColor) {
        this.optionalParams.bgColor = bgColor;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.optionalParams.crs = crs;
    }

    public void setSRS(String srs) {
        this.optionalParams.srs = srs;
    }

    public void setExceptions(String exceptions) {
        this.optionalParams.exceptions = exceptions;
    }

    public void setFormat(String format) {
        this.mandatoryParams.format = format;
    }

    public void setFormatOptions(Map formatOptions) {
        this.formatOptions = formatOptions;
    }

    public void setHeight(int height) {
        this.mandatoryParams.height = height;
    }

    public void setHeight(Integer height) {
        this.mandatoryParams.height = height;
    }

    public void setLayers(MapLayerInfo[] layers) {
        this.mandatoryParams.layers = layers;
    }

    public void setLayers(List layers) {
        this.mandatoryParams.layers = layers.toArray(new MapLayerInfo[layers.size()]);
    }

    public void setStyles(List styles) {
        this.mandatoryParams.styles = styles;
    }

    public void setSld(URL sld) {
        this.optionalParams.sld = sld;
    }

    public void setSldBody(String sldBody) {
        this.optionalParams.sldBody = sldBody;
    }

    public void setValidateSchema(Boolean validateSLD) {
        this.optionalParams.validateSLD = validateSLD;
    }

    public void setFilters(List filters) {
        this.setFilter(filters);
    }

    public void setFilter(List filters) {
        this.optionalParams.filters = filters;
    }

    public void setCQLFilter(List cqlFilters) {
        this.optionalParams.cqlFilters = cqlFilters;
    }

    public void setFeatureId(List featureIds) {
        this.optionalParams.featureIds = featureIds;
    }

    public void setTransparent(boolean transparent) {
        this.optionalParams.transparent = transparent;
    }

    public void setTransparent(Boolean transparent) {
        this.optionalParams.transparent = transparent != null ? transparent : false;
    }

    public void setBuffer(int buffer) {
        this.optionalParams.buffer = buffer;
    }

    public void setPalette(InverseColorMapOp paletteInverter) {
        this.optionalParams.paletteInverter = paletteInverter;
    }

    public void setBuffer(Integer buffer) {
        this.optionalParams.buffer = buffer != null ? buffer : 0;
    }

    public void setTiled(boolean tiled) {
        this.optionalParams.tiled = tiled;
    }

    public void setTiled(Boolean tiled) {
        this.optionalParams.tiled = tiled != null ? tiled : false;
    }

    public void setTilesOrigin(Point2D origin) {
        this.optionalParams.tilesOrigin = origin;
    }

    public void setWidth(int width) {
        this.mandatoryParams.width = width;
    }

    public void setWidth(Integer width) {
        this.mandatoryParams.width = width;
    }

    public void setKMScore(int score) {
        this.getFormatOptions().put("kmscore", new Integer(score));
    }

    public void setKMattr(boolean on) {
        this.getFormatOptions().put("kmattr", new Boolean(on));
    }

    public void setSuperOverlay(boolean superOverlay) {
        this.getFormatOptions().put("superoverlay", new Boolean(superOverlay));
    }

    public void setLegend(boolean legend) {
        this.getFormatOptions().put("legend", new Boolean(legend));
    }

    public void setTime(List time) {
        this.optionalParams.time = time;
    }

    public void setElevation(Integer elevation) {
        this.optionalParams.elevation = elevation;
    }

    public void setFeatureVersion(String featureVersion) {
        this.optionalParams.featureVersion = featureVersion;
    }

    public void setRemoteOwsType(String remoteOwsType) {
        this.optionalParams.remoteOwsType = remoteOwsType;
    }

    public void setRemoteOwsURL(URL remoteOwsURL) {
        this.optionalParams.remoteOwsURL = remoteOwsURL;
    }

    public void setMaxFeatures(Integer maxFeatures) {
        this.optionalParams.maxFeatures = maxFeatures;
    }

    public Integer getMaxFeatures() {
        return this.optionalParams.maxFeatures;
    }

    public void setStartIndex(Integer startIndex) {
        this.optionalParams.startIndex = startIndex;
    }

    public Integer getStartIndex() {
        return this.optionalParams.startIndex;
    }

    public void setRawKvp(Map rawKvp) {
        this.rawKvp = rawKvp;
    }

    private static final Color decodeColor(String hexColor) {
        return Color.decode(hexColor);
    }

    public String toString() {
        StringBuffer returnString = new StringBuffer("\nGetMap Request");
        returnString.append("\n version: " + this.version);
        returnString.append("\n output format: " + this.mandatoryParams.format);
        returnString.append("\n width height: " + this.mandatoryParams.height + "," + this.mandatoryParams.width);
        returnString.append("\n bbox: " + this.mandatoryParams.bbox);
        returnString.append("\n layers: ");
        for (int i = 0; i < this.mandatoryParams.layers.length; ++i) {
            returnString.append(this.mandatoryParams.layers[i].getName());
            if (i >= this.mandatoryParams.layers.length - 1) continue;
            returnString.append(",");
        }
        returnString.append("\n styles: ");
        Iterator it = this.mandatoryParams.styles.iterator();
        while (it.hasNext()) {
            Style s = (Style)it.next();
            returnString.append(s.getName());
            if (!it.hasNext()) continue;
            returnString.append(",");
        }
        return returnString.toString();
    }

    private class OptionalParameters {
        Color bgColor = DEFAULT_BG;
        CoordinateReferenceSystem crs;
        String srs;
        List filters;
        List cqlFilters;
        List featureIds;
        String exceptions = "SE_XML";
        boolean transparent = false;
        boolean tiled;
        public Point2D tilesOrigin;
        int buffer;
        InverseColorMapOp paletteInverter;
        List time;
        Integer elevation;
        URL sld;
        String sldBody;
        Boolean validateSLD = Boolean.FALSE;
        String featureVersion;
        String remoteOwsType;
        URL remoteOwsURL;
        Integer maxFeatures;
        Integer startIndex;

        private OptionalParameters() {
        }
    }

    private class MandatoryParameters {
        MapLayerInfo[] layers;
        List styles;
        Envelope bbox;
        int width;
        int height;
        String format;

        private MandatoryParameters() {
        }
    }
}

