/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.WFS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.geometry.Envelope;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.dto.ServiceDTO;
import org.vfny.geoserver.global.dto.WMSDTO;

public class WMS
extends Service {
    private static final String WMS_VERSION = "1.1.1";
    private static final String FIXED_SERVICE_NAME = "OGC:WMS";
    private static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml"};
    public static final String WEB_CONTAINER_KEY = "WMS";
    public static final int WATERMARK_UL = WatermarkInfo.Position.TOP_LEFT.getCode();
    public static final int WATERMARK_UC = WatermarkInfo.Position.TOP_CENTER.getCode();
    public static final int WATERMARK_UR = WatermarkInfo.Position.TOP_RIGHT.getCode();
    public static final int WATERMARK_CL = WatermarkInfo.Position.MID_LEFT.getCode();
    public static final int WATERMARK_CC = WatermarkInfo.Position.MID_CENTER.getCode();
    public static final int WATERMARK_CR = WatermarkInfo.Position.MID_RIGHT.getCode();
    public static final int WATERMARK_LL = WatermarkInfo.Position.BOT_LEFT.getCode();
    public static final int WATERMARK_LC = WatermarkInfo.Position.BOT_CENTER.getCode();
    public static final int WATERMARK_LR = WatermarkInfo.Position.BOT_RIGHT.getCode();
    WMSInfo wms;

    public WMS(GeoServer gs) {
        super(gs.getService(WMSInfo.class), gs);
        this.init();
    }

    public void init() {
        this.wms = (WMSInfo)this.gs.getService(WMSInfo.class);
        this.service = this.wms;
    }

    public WFS getWFS() {
        return new WFS(this.gs);
    }

    public void load(WMSDTO config) {
        super.load(config.getService());
        this.setSvgRenderer(config.getSvgRenderer());
        this.setSvgAntiAlias(config.getSvgAntiAlias());
        this.setGlobalWatermarking(config.getGlobalWatermarking());
        this.setGlobalWatermarkingURL(config.getGlobalWatermarkingURL());
        this.setWatermarkTransparency(config.getWatermarkTransparency());
        this.setWatermarkPosition(config.getWatermarkPosition());
        this.setAllowInterpolation(config.getAllowInterpolation());
        this.setBaseMapLayers(config.getBaseMapLayers());
        this.setBaseMapStyles(config.getBaseMapStyles());
        this.setBaseMapEnvelopes(config.getBaseMapEnvelopes());
        this.setCapabilitiesCrsList(config.getCapabilitiesCrs());
    }

    public WMSDTO toDTO() {
        WMSDTO w = new WMSDTO();
        w.setService((ServiceDTO)super.toDTO());
        w.setSvgRenderer(this.getSvgRenderer());
        w.setSvgAntiAlias(this.isSvgAntiAlias());
        w.setGlobalWatermarking(this.isGlobalWatermarking());
        w.setGlobalWatermarkingURL(this.getGlobalWatermarkingURL());
        w.setWatermarkTransparency(this.getWatermarkTransparency());
        w.setWatermarkPosition(this.getWatermarkPosition());
        w.setAllowInterpolation(this.getAllowInterpolation());
        w.setBaseMapLayers(this.getBaseMapLayers());
        w.setBaseMapStyles(this.getBaseMapStyles());
        w.setBaseMapEnvelopes(this.getBaseMapEnvelopes());
        w.setCapabilitiesCrs(this.getCapabilitiesCrsList());
        return w;
    }

    public String[] getExceptionFormats() {
        return EXCEPTION_FORMATS;
    }

    public static String getVersion() {
        return WMS_VERSION;
    }

    public boolean supportsSLD() {
        return true;
    }

    public boolean supportsUserLayer() {
        return true;
    }

    public boolean supportsUserStyle() {
        return true;
    }

    public boolean supportsRemoteWFS() {
        return true;
    }

    public String getSvgRenderer() {
        return (String)this.wms.getMetadata().get("svgRenderer");
    }

    public void setSvgRenderer(String svgRenderer) {
        this.wms.getMetadata().put("svgRenderer", svgRenderer);
    }

    public boolean isSvgAntiAlias() {
        Boolean svgAntiAlias = (Boolean)this.wms.getMetadata().get("svgAntiAlias");
        return svgAntiAlias != null ? svgAntiAlias : true;
    }

    public void setSvgAntiAlias(boolean svgAntiAlias) {
        this.wms.getMetadata().put("svgAntiAlias", svgAntiAlias);
    }

    public String getAllowInterpolation() {
        return this.wms.getInterpolation();
    }

    public void setAllowInterpolation(String allowInterpolation) {
        this.wms.setInterpolation(allowInterpolation);
    }

    public Map getBaseMapLayers() {
        HashMap<String, String> baseLayers = new HashMap<String, String>();
        for (LayerGroupInfo map : this.gs.getCatalog().getLayerGroups()) {
            StringBuffer layers = new StringBuffer();
            for (LayerInfo l : map.getLayers()) {
                layers.append(l.getName()).append(",");
            }
            layers.setLength(layers.length() - 1);
            baseLayers.put(map.getName(), layers.toString());
        }
        return baseLayers;
    }

    public void setBaseMapLayers(Map layers) {
        HashMap baseLayers = new HashMap();
        for (LayerGroupInfo map : this.gs.getCatalog().getLayerGroups()) {
            this.gs.getCatalog().remove(map);
        }
        for (Map.Entry entry : layers.entrySet()) {
            String name = (String)entry.getKey();
            String[] layerNames = ((String)entry.getValue()).split(",");
            LayerGroupInfo baseMap = this.gs.getCatalog().getFactory().createLayerGroup();
            baseMap.setName(name);
            for (String layerName : layerNames) {
                ResourceInfo resource = null;
                resource = layerName.contains(":") ? this.gs.getCatalog().getResourceByName(layerName.split(":")[0], layerName.split(":")[1], ResourceInfo.class) : this.gs.getCatalog().getResourceByName(layerName, ResourceInfo.class);
                if (resource == null) {
                    throw new RuntimeException("No such layer: " + layerName);
                }
                LayerInfo layer = (LayerInfo)this.gs.getCatalog().getLayers(resource).get(0);
                if (layer == null) {
                    throw new RuntimeException("No such layer: " + layerName);
                }
                baseMap.getLayers().add(layer);
            }
            this.gs.getCatalog().add(baseMap);
        }
    }

    public Map getBaseMapStyles() {
        HashMap<String, String> baseMapStyles = new HashMap<String, String>();
        for (LayerGroupInfo map : this.gs.getCatalog().getLayerGroups()) {
            String rawStyleList = (String)map.getMetadata().get("rawStyleList");
            if (rawStyleList != null) {
                baseMapStyles.put(map.getName(), rawStyleList);
                continue;
            }
            StringBuffer styles = new StringBuffer();
            for (StyleInfo s : map.getStyles()) {
                styles.append(s.getName()).append(",");
            }
            styles.setLength(styles.length() - 1);
            baseMapStyles.put(map.getName(), styles.toString());
        }
        return baseMapStyles;
    }

    public void setBaseMapStyles(Map styles) {
        for (Map.Entry entry : styles.entrySet()) {
            int i;
            String name = (String)entry.getKey();
            String styleNamesRaw = ((String)entry.getValue()).trim();
            ArrayList<Object> styleNames = null;
            styleNames = "".equals(styleNamesRaw) ? new ArrayList() : new ArrayList<String>(Arrays.asList(styleNamesRaw.split(",")));
            LayerGroupInfo map = this.gs.getCatalog().getLayerGroupByName(name);
            map.getMetadata().put("rawStyleList", styleNamesRaw);
            for (i = styleNames.size(); i < map.getLayers().size(); ++i) {
                styleNames.add("");
            }
            map.getStyles().clear();
            for (i = 0; i < styleNames.size(); ++i) {
                String styleName = (String)styleNames.get(i);
                StyleInfo style = null;
                style = "".equals(styleName) ? ((LayerInfo)map.getLayers().get(i)).getDefaultStyle() : this.gs.getCatalog().getStyleByName(styleName);
                if (style == null) {
                    throw new RuntimeException("No such style: " + styleName);
                }
                map.getStyles().add(style);
            }
            this.gs.getCatalog().save(map);
        }
    }

    public Map getBaseMapEnvelopes() {
        HashMap<String, GeneralEnvelope> baseMapEnvelopes = new HashMap<String, GeneralEnvelope>();
        for (LayerGroupInfo map : this.gs.getCatalog().getLayerGroups()) {
            baseMapEnvelopes.put(map.getName(), new GeneralEnvelope((Envelope)map.getBounds()));
        }
        return baseMapEnvelopes;
    }

    public void getBaseMapEnvelopes(Map envelopes) {
        this.setBaseMapEnvelopes(envelopes);
    }

    public void setBaseMapEnvelopes(Map envelopes) {
        for (Map.Entry entry : envelopes.entrySet()) {
            String name = (String)entry.getKey();
            GeneralEnvelope env = (GeneralEnvelope)entry.getValue();
            LayerGroupInfo map = this.gs.getCatalog().getLayerGroupByName(name);
            map.setBounds(new ReferencedEnvelope((Envelope)env));
            this.gs.getCatalog().save(map);
        }
    }

    public boolean isGlobalWatermarking() {
        return this.wms.getWatermark().isEnabled();
    }

    public void setGlobalWatermarking(boolean globalWatermarking) {
        this.wms.getWatermark().setEnabled(globalWatermarking);
    }

    public String getGlobalWatermarkingURL() {
        return this.wms.getWatermark().getURL();
    }

    public void setGlobalWatermarkingURL(String globalWatermarkingURL) {
        this.wms.getWatermark().setURL(globalWatermarkingURL);
    }

    public int getWatermarkTransparency() {
        return this.wms.getWatermark().getTransparency();
    }

    public void setWatermarkTransparency(int watermarkTransparency) {
        this.wms.getWatermark().setTransparency(watermarkTransparency);
    }

    public int getWatermarkPosition() {
        return this.wms.getWatermark().getPosition().getCode();
    }

    public void setWatermarkPosition(int watermarkPosition) {
        WatermarkInfo.Position p = WatermarkInfo.Position.get(watermarkPosition);
        this.wms.getWatermark().setPosition(p);
    }

    public Set getCapabilitiesCrsList() {
        return new TreeSet<String>(this.wms.getSRS());
    }

    public void setCapabilitiesCrsList(Set epsgCodes) {
        this.wms.getSRS().clear();
        if (epsgCodes != null) {
            this.wms.getSRS().addAll(epsgCodes);
        }
    }
}

