/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.kvp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.HttpServletRequestAware;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Style;
import org.geotools.styling.StyleAttributeExtractor;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.UserLayer;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.TemporaryFeatureTypeInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.util.SLDValidator;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;

public class GetMapKvpRequestReader
extends KvpRequestReader
implements HttpServletRequestAware {
    HttpServletRequest httpRequest;
    StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    boolean styleRequired;
    WMS wms;
    Data catalog;
    boolean laxStyleMatchAllowed = true;

    public GetMapKvpRequestReader(WMS wms) {
        super(GetMapRequest.class);
        this.wms = wms;
        this.catalog = wms.getData();
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setStyleFactory(StyleFactory styleFactory) {
        this.styleFactory = styleFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public boolean isStyleRequired() {
        return this.styleRequired;
    }

    public void setStyleRequired(boolean styleRequired) {
        this.styleRequired = styleRequired;
    }

    public Object createRequest() throws Exception {
        GetMapRequest request = new GetMapRequest(this.wms);
        request.setHttpServletRequest(this.httpRequest);
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(Object request, Map kvp, Map rawKvp) throws Exception {
        String remoteOwsType;
        GetMapRequest getMap = (GetMapRequest)((Object)super.read(request, kvp, rawKvp));
        String epsgCode = getMap.getSRS();
        if (epsgCode != null) {
            try {
                CoordinateReferenceSystem mapcrs = CRS.decode((String)epsgCode);
                getMap.setCrs(mapcrs);
            }
            catch (Exception e) {
                throw new WmsException("Error occurred decoding the espg code " + epsgCode, "InvalidSRS", e);
            }
        }
        String string = remoteOwsType = (remoteOwsType = getMap.getRemoteOwsType()) != null ? remoteOwsType.toUpperCase() : null;
        if (remoteOwsType != null && !"WFS".equals(remoteOwsType)) {
            throw new WmsException("Unsupported remote OWS type '" + remoteOwsType + "'");
        }
        URL remoteOwsUrl = getMap.getRemoteOwsURL();
        if (remoteOwsUrl != null && remoteOwsType == null) {
            throw new WmsException("REMOTE_OWS_URL specified, but REMOTE_OWS_TYPE is missing");
        }
        String layerParam = (String)kvp.get("LAYERS");
        if (layerParam != null) {
            getMap.setLayers(this.parseLayers(KvpUtils.readFlat((String)layerParam), remoteOwsUrl, remoteOwsType));
        }
        String stylesParam = (String)kvp.get("STYLES");
        List styleNameList = Collections.EMPTY_LIST;
        if (stylesParam != null) {
            styleNameList = KvpUtils.readFlat((String)stylesParam);
        }
        if (getMap.getSldBody() != null) {
            List errors;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from SLD_BODY");
            }
            if (getMap.getValidateSchema().booleanValue() && (errors = this.validateSld(new ByteArrayInputStream(getMap.getSldBody().getBytes()))).size() != 0) {
                throw new WmsException(SLDValidator.getErrorMessage((InputStream)new ByteArrayInputStream(getMap.getSldBody().getBytes()), (List)errors));
            }
            StyledLayerDescriptor sld = this.parseSld(new ByteArrayInputStream(getMap.getSldBody().getBytes()));
            this.processSld(getMap, sld, styleNameList);
        } else {
            MapLayerInfo[] layers;
            if (getMap.getSld() != null) {
                InputStream input;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Getting layers and styles from reomte SLD");
                }
                URL sldUrl = getMap.getSld();
                if (getMap.getValidateSchema().booleanValue()) {
                    input = Requests.getInputStream((URL)sldUrl);
                    List errors = null;
                    try {
                        errors = this.validateSld(input);
                    }
                    finally {
                        input.close();
                    }
                    if (errors != null && errors.size() != 0) {
                        input = Requests.getInputStream((URL)sldUrl);
                        try {
                            throw new WmsException(SLDValidator.getErrorMessage((InputStream)input, (List)errors));
                        }
                        catch (Throwable throwable) {
                            input.close();
                            throw throwable;
                        }
                    }
                }
                input = Requests.getInputStream((URL)sldUrl);
                try {
                    StyledLayerDescriptor sld = this.parseSld(input);
                    this.processSld(getMap, sld, styleNameList);
                }
                finally {
                    input.close();
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Getting layers and styles from LAYERS and STYLES");
            }
            if (styleNameList.size() > 0) {
                getMap.setStyles(this.parseStyles(styleNameList));
            }
            if (getMap.getLayers() != null) {
                ArrayList<MapLayerInfo> oldLayers = new ArrayList<MapLayerInfo>(Arrays.asList(getMap.getLayers()));
                ArrayList oldStyles = getMap.getStyles() != null ? new ArrayList(getMap.getStyles()) : new ArrayList();
                ArrayList<MapLayerInfo> newLayers = new ArrayList<MapLayerInfo>();
                ArrayList<Style> newStyles = new ArrayList<Style>();
                for (int i = 0; i < oldLayers.size(); ++i) {
                    Style style;
                    MapLayerInfo info = (MapLayerInfo)oldLayers.get(i);
                    Style style2 = style = oldStyles.isEmpty() ? null : (Style)oldStyles.get(i);
                    if (info.getType() == MapLayerInfo.TYPE_BASEMAP) {
                        List subLayers = info.getSubLayers();
                        newLayers.addAll(subLayers);
                        List currStyles = info.getStyles();
                        for (int j = 0; j < subLayers.size(); ++j) {
                            Style currStyle;
                            MapLayerInfo currLayer = (MapLayerInfo)subLayers.get(j);
                            Style style3 = currStyle = currStyles.isEmpty() ? null : (Style)currStyles.get(j);
                            if (currStyle != null) {
                                newStyles.add(currStyle);
                                continue;
                            }
                            newStyles.add(currLayer.getDefaultStyle());
                        }
                        continue;
                    }
                    newLayers.add(info);
                    if (style != null) {
                        newStyles.add(style);
                        continue;
                    }
                    newStyles.add(info.getDefaultStyle());
                }
                getMap.setLayers(newLayers);
                getMap.setStyles(newStyles);
            }
            if ((layers = getMap.getLayers()) != null && layers.length > 0) {
                List styles = getMap.getStyles();
                if (layers.length != styles.size()) {
                    String msg = layers.length + " layers requested, but found " + styles.size() + " styles specified. ";
                    throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
                }
                for (int i = 0; i < getMap.getStyles().size(); ++i) {
                    Style currStyle = (Style)getMap.getStyles().get(i);
                    if (currStyle == null) {
                        throw new WmsException("Could not find a style for layer " + getMap.getLayers()[i].getName() + ", either none was specified or no default style is available for it", "NoDefaultStyle");
                    }
                    GetMapKvpRequestReader.checkStyle(currStyle, layers[i]);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.fine(new StringBuffer("establishing ").append(currStyle.getName()).append(" style for ").append(layers[i].getName()).toString());
                }
            }
        }
        if (getMap.getLayers() != null && getMap.getLayers().length > 0) {
            List featureId;
            List<Id> filters = getMap.getFilter() != null ? getMap.getFilter() : Collections.EMPTY_LIST;
            List cqlFilters = getMap.getCQLFilter() != null ? getMap.getCQLFilter() : Collections.EMPTY_LIST;
            List list = featureId = getMap.getFeatureId() != null ? getMap.getFeatureId() : Collections.EMPTY_LIST;
            if (!featureId.isEmpty()) {
                if (!filters.isEmpty()) {
                    throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId);
                }
                HashSet<FeatureId> ids = new HashSet<FeatureId>();
                Iterator i = featureId.iterator();
                while (i.hasNext()) {
                    ids.add(this.filterFactory.featureId((String)i.next()));
                }
                filters = Collections.singletonList(this.filterFactory.id(ids));
            }
            if (!cqlFilters.isEmpty()) {
                if (!filters.isEmpty()) {
                    throw new WmsException("GetMap KVP request contained conflicting filters.  Filter: " + filters + ", fid: " + featureId + ", cql: " + cqlFilters);
                }
                filters = cqlFilters;
            }
            int numLayers = getMap.getLayers().length;
            if (!filters.isEmpty() && numLayers != filters.size()) {
                if (filters.size() == 1) {
                    Filter f = (Filter)filters.get(0);
                    filters = new ArrayList<Id>(numLayers);
                    for (int i = 0; i < numLayers; ++i) {
                        filters.add((Id)f);
                    }
                } else {
                    String msg = numLayers + " layers requested, but found " + filters.size() + " filters specified. " + "When you specify the FILTER parameter, you must provide just one, \n" + " that will be applied to all layers, or exactly one for each requested layer";
                    throw new WmsException(msg, ((Object)((Object)this)).getClass().getName());
                }
            }
            getMap.setFilter(filters);
        }
        getMap.setRawKvp(rawKvp);
        return getMap;
    }

    private List validateSld(InputStream input) {
        SLDValidator validator = new SLDValidator();
        return validator.validateSLD(input, this.httpRequest.getSession().getServletContext());
    }

    private StyledLayerDescriptor parseSld(InputStream input) {
        SLDParser parser = new SLDParser(this.styleFactory, input);
        return parser.parseSLD();
    }

    public void processSld(GetMapRequest request, StyledLayerDescriptor sld, List styleNames) throws WmsException {
        if (request.getLayers() == null || request.getLayers().length == 0) {
            GetMapKvpRequestReader.processStandaloneSld(request, sld);
        } else {
            this.processLibrarySld(request, sld, styleNames);
        }
    }

    private void processLibrarySld(GetMapRequest request, StyledLayerDescriptor sld, List styleNames) {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo[] libraryModeLayers = request.getLayers();
        MapLayerInfo currLayer = null;
        Object currStyle = null;
        String styleName = null;
        for (int i = 0; i < libraryModeLayers.length; ++i) {
            currLayer = libraryModeLayers[i];
            if (styleNames != null && styleNames.size() > 0) {
                styleName = (String)styleNames.get(i);
            }
            if (currLayer.getType() == MapLayerInfo.TYPE_BASEMAP) {
                List subLayers = currLayer.getSubLayers();
                layers.addAll(subLayers);
                List currStyles = currLayer.getStyles();
                for (int j = 0; j < subLayers.size(); ++j) {
                    Style s;
                    MapLayerInfo l = (MapLayerInfo)subLayers.get(j);
                    Style style = s = currStyles.isEmpty() ? null : (Style)currStyles.get(j);
                    if (s != null) {
                        styles.add((Style)currStyle);
                        continue;
                    }
                    styles.add(currLayer.getDefaultStyle());
                }
                continue;
            }
            layers.add(currLayer);
            styles.add(this.findStyleOf(request, currLayer, styleName, styledLayers));
        }
        request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        request.setStyles(styles);
    }

    public static void processStandaloneSld(GetMapRequest request, StyledLayerDescriptor sld) {
        StyledLayer[] styledLayers = sld.getStyledLayers();
        int slCount = styledLayers.length;
        if (slCount == 0) {
            throw new WmsException("SLD document contains no layers");
        }
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        ArrayList<Style> styles = new ArrayList<Style>();
        MapLayerInfo currLayer = null;
        Style currStyle = null;
        StyledLayer sl = null;
        for (int i = 0; i < slCount; ++i) {
            UserLayer ul;
            sl = styledLayers[i];
            String layerName = sl.getName();
            if (null == layerName) {
                throw new WmsException("A UserLayer without layer name was passed");
            }
            if (sl instanceof UserLayer && ((UserLayer)sl).getRemoteOWS() != null) {
                ul = (UserLayer)sl;
                try {
                    GetMapKvpRequestReader.addRemoteLayersFromUserLayer(request, ul, layers, styles);
                    continue;
                }
                catch (IOException e) {
                    throw new WmsException("Error accessing remote layers", "RemoteAccessFailed", e);
                }
            }
            currLayer = new MapLayerInfo();
            if (sl instanceof UserLayer && ((UserLayer)sl).getInlineFeatureDatastore() != null) {
                ul = (UserLayer)sl;
                try {
                    GetMapKvpRequestReader.initializeInlineFeatureLayer(request, ul, currLayer);
                }
                catch (Exception e) {
                    throw new WmsException(e);
                }
            }
            try {
                currLayer.setFeature(GetMapKvpReader.findFeatureLayer(request, layerName));
            }
            catch (WmsException e) {
                currLayer.setCoverage(GetMapKvpReader.findCoverageLayer(request, layerName));
            }
            if (currLayer.getType() == MapLayerInfo.TYPE_VECTOR) {
                GetMapKvpRequestReader.addStyles(request, currLayer, styledLayers[i], layers, styles);
                continue;
            }
            if (currLayer.getType() != MapLayerInfo.TYPE_RASTER) continue;
            try {
                GetMapKvpRequestReader.addStyles(request, currLayer, styledLayers[i], layers, styles);
                continue;
            }
            catch (WmsException wm) {
                currStyle = GetMapKvpRequestReader.findStyle(request, "raster");
                if (currStyle == null) {
                    throw new WmsException(wm.getMessage() + "  Also tried to use " + "the generic raster style 'raster', but it wasn't available.");
                }
                layers.add(currLayer);
                styles.add(currStyle);
            }
        }
        request.setLayers(layers.toArray(new MapLayerInfo[layers.size()]));
        request.setStyles(styles);
    }

    private static void addRemoteLayersFromUserLayer(GetMapRequest request, UserLayer ul, List layers, List styles) throws WmsException, IOException {
        RemoteOWS service = ul.getRemoteOWS();
        if (!service.getService().equalsIgnoreCase("WFS")) {
            throw new WmsException("GeoServer only supports WFS as remoteOWS service");
        }
        if (service.getOnlineResource() == null) {
            throw new WmsException("OnlineResource for remote WFS not specified in SLD");
        }
        FeatureTypeConstraint[] featureConstraints = ul.getLayerFeatureConstraints();
        if (featureConstraints == null || featureConstraints.length == 0) {
            throw new WmsException("No FeatureTypeConstraint specified, no layer can be loaded for this UserStyle");
        }
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = null;
        try {
            URL url = new URL(service.getOnlineResource());
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(url);
            remoteTypeNames = new ArrayList<String>(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        catch (MalformedURLException e) {
            throw new WmsException("Invalid online resource url: '" + service.getOnlineResource() + "'");
        }
        Style[] layerStyles = ul.getUserStyles();
        if (request.getFilter() == null) {
            request.setFilter(new ArrayList());
        }
        for (int i = 0; i < featureConstraints.length; ++i) {
            String name = featureConstraints[i].getFeatureTypeName();
            if (Collections.binarySearch(remoteTypeNames, name) < 0) {
                throw new WmsException("Could not find layer feature type '" + name + "' on remote WFS '" + service.getOnlineResource());
            }
            Filter filter = featureConstraints[i].getFilter();
            if (filter == null) {
                filter = Filter.INCLUDE;
            }
            FeatureSource fs = remoteWFS.getFeatureSource(name);
            for (int j = 0; j < layerStyles.length; ++j) {
                Style style = layerStyles[i];
                MapLayerInfo info = new MapLayerInfo(fs);
                layers.add(info);
                styles.add(style);
                request.getFilter().add(filter);
            }
        }
    }

    public static void addStyles(GetMapRequest request, MapLayerInfo currLayer, StyledLayer layer, List layers, List styles) throws WmsException {
        int t;
        if (currLayer == null) {
            return;
        }
        Style[] layerStyles = null;
        FeatureTypeConstraint[] ftcs = null;
        if (layer instanceof NamedLayer) {
            ftcs = ((NamedLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((NamedLayer)layer).getStyles();
        } else if (layer instanceof UserLayer) {
            ftcs = ((UserLayer)layer).getLayerFeatureConstraints();
            layerStyles = ((UserLayer)layer).getUserStyles();
        }
        if (ftcs != null) {
            int length = ftcs.length;
            for (t = 0; t < length; ++t) {
                boolean matches;
                FeatureTypeConstraint ftc = ftcs[t];
                if (ftc.getFeatureTypeName() == null) continue;
                String ftc_name = ftc.getFeatureTypeName();
                try {
                    SimpleFeatureType featureType = currLayer.getFeature().getFeatureType();
                    matches = FeatureTypes.isDecendedFrom((SimpleFeatureType)featureType, null, (String)ftc_name) || featureType.getTypeName().equalsIgnoreCase(ftc_name);
                }
                catch (Exception e) {
                    matches = false;
                }
                if (matches) continue;
            }
        }
        if (layerStyles == null || layerStyles.length == 0) {
            layers.add(currLayer);
            styles.add(currLayer.getDefaultStyle());
            return;
        }
        int length = layerStyles.length;
        for (t = 0; t < length; ++t) {
            if (layerStyles[t] instanceof NamedStyle) {
                layers.add(currLayer);
                Style s = GetMapKvpRequestReader.findStyle(request, ((NamedStyle)layerStyles[t]).getName());
                if (s == null) {
                    throw new WmsException("couldnt find style named '" + ((NamedStyle)layerStyles[t]).getName() + "'");
                }
                styles.add(s);
                continue;
            }
            layers.add(currLayer);
            styles.add(layerStyles[t]);
        }
    }

    public static Style findStyle(GetMapRequest request, String currStyleName) {
        Map configuredStyles = request.getWMS().getData().getStyles();
        Style currStyle = (Style)configuredStyles.get(currStyleName);
        return currStyle;
    }

    private Style findStyleOf(GetMapRequest request, MapLayerInfo layer, String styleName, StyledLayer[] styledLayers) throws WmsException {
        Style[] styles;
        StyledLayer sl;
        int i;
        Style style = null;
        String layerName = layer.getName();
        for (i = 0; i < styledLayers.length; ++i) {
            int j;
            sl = styledLayers[i];
            if (!layerName.equals(sl.getName())) continue;
            if (sl instanceof UserLayer) {
                styles = ((UserLayer)sl).getUserStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if (styleName == null || styleName.equals("") && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                break;
            }
            if (sl instanceof NamedLayer) {
                styles = ((NamedLayer)sl).getStyles();
                for (j = 0; style == null && styles != null && j < styles.length; ++j) {
                    if ((styleName == null || styleName.equals("")) && styles[j].isDefault()) {
                        style = styles[j];
                        continue;
                    }
                    if (styleName == null || !styleName.equals(styles[j].getName())) continue;
                    style = styles[j];
                }
                if (!(style instanceof NamedStyle)) break;
                style = GetMapKvpRequestReader.findStyle(request, style.getName());
                break;
            }
            throw new RuntimeException("Unknown layer type: " + sl);
        }
        if (style == null && this.laxStyleMatchAllowed) {
            for (i = 0; i < styledLayers.length; ++i) {
                sl = styledLayers[i];
                if (!layerName.equals(sl.getName())) continue;
                if (sl instanceof UserLayer) {
                    styles = ((UserLayer)sl).getUserStyles();
                    if (null == styles || 0 >= styles.length) break;
                    style = styles[0];
                    break;
                }
                if (sl instanceof NamedLayer) {
                    styles = ((NamedLayer)sl).getStyles();
                    if (null != styles && 0 < styles.length) {
                        style = styles[0];
                    }
                    if (!(style instanceof NamedStyle)) break;
                    style = GetMapKvpRequestReader.findStyle(request, style.getName());
                    break;
                }
                throw new RuntimeException("Unknown layer type: " + sl);
            }
        }
        if (style == null) {
            if (styleName == null || "".equals(styleName)) {
                style = layer.getDefaultStyle();
                if (style == null) {
                    throw new WmsException("Could not find a default style for " + layer.getName());
                }
            } else {
                style = this.catalog.getStyle(styleName);
                if (style == null) {
                    String msg = "No such style: " + styleName;
                    throw new WmsException(msg, "StyleNotDefined");
                }
            }
        }
        GetMapKvpRequestReader.checkStyle(style, layer);
        return style;
    }

    private static void checkStyle(Style style, MapLayerInfo layer) throws WmsException {
        block9: {
            block8: {
                if (layer.getType() == MapLayerInfo.TYPE_BASEMAP) break block8;
                if (layer.getType() != MapLayerInfo.TYPE_RASTER) break block9;
            }
            return;
        }
        StyleAttributeExtractor sae = new StyleAttributeExtractor();
        sae.visit(style);
        String[] styleAttributes = sae.getAttributeNames();
        HashSet<String> attributes = new HashSet<String>();
        if (layer.getType() == MapLayerInfo.TYPE_VECTOR || layer.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
            try {
                SimpleFeatureType type = layer.getType() == MapLayerInfo.TYPE_VECTOR ? layer.getFeature().getFeatureType() : (SimpleFeatureType)layer.getRemoteFeatureSource().getSchema();
                for (int i = 0; i < type.getAttributeCount(); ++i) {
                    attributes.add(type.getDescriptor(i).getLocalName());
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error getting FeatureType, this should never happen!");
            }
        }
        for (String attName : styleAttributes) {
            if (attributes.contains(attName)) continue;
            throw new WmsException("The requested Style can not be used with this layer.  The style specifies an attribute of " + attName + " and the layer is: " + layer.getName());
        }
    }

    public static void initializeInlineFeatureLayer(GetMapRequest getMapRequest, UserLayer ul, MapLayerInfo currLayer) throws Exception {
        currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo(ul.getInlineFeatureDatastore()));
        if (ul.getInlineFeatureType().getCoordinateReferenceSystem() == null) {
            LOGGER.warning("No CRS set on inline features default geometry.  Assuming the requestor has their inlinefeatures in the boundingbox CRS.");
            SimpleFeatureType currFt = ul.getInlineFeatureType();
            DefaultQuery q = new DefaultQuery(currFt.getTypeName(), (Filter)Filter.INCLUDE);
            FeatureReader ilReader = ul.getInlineFeatureDatastore().getFeatureReader((Query)q, Transaction.AUTO_COMMIT);
            DefaultGeographicCRS crs = getMapRequest.getCrs() == null ? DefaultGeographicCRS.WGS84 : getMapRequest.getCrs();
            MemoryDataStore reTypedDS = new MemoryDataStore((FeatureReader)new ForceCoordinateSystemFeatureReader(ilReader, (CoordinateReferenceSystem)crs));
            currLayer.setFeature((FeatureTypeInfo)new TemporaryFeatureTypeInfo((DataStore)reTypedDS));
        }
    }

    protected MapLayerInfo[] parseLayers(List values, URL remoteOwsUrl, String remoteOwsType) throws Exception {
        ArrayList<MapLayerInfo> layers = new ArrayList<MapLayerInfo>();
        List layerNames = values;
        String layerName2 = null;
        DataStore remoteWFS = null;
        ArrayList<String> remoteTypeNames = null;
        if ("WFS".equals(remoteOwsType) && remoteOwsUrl != null) {
            remoteWFS = GetMapKvpRequestReader.connectRemoteWFS(remoteOwsUrl);
            remoteTypeNames = new ArrayList<String>(Arrays.asList(remoteWFS.getTypeNames()));
            Collections.sort(remoteTypeNames);
        }
        for (String layerName2 : layerNames) {
            if (remoteTypeNames != null && Collections.binarySearch(remoteTypeNames, layerName2) >= 0) {
                FeatureSource remoteSource = remoteWFS.getFeatureSource(layerName2);
                if (remoteSource == null) continue;
                layers.add(new MapLayerInfo(remoteSource));
                continue;
            }
            Integer layerType = this.catalog.getLayerType(layerName2);
            if (layerType != null) {
                layers.add(this.buildMapLayerInfo(layerName2));
                continue;
            }
            if (this.wms.getBaseMapLayers().containsKey(layerName2)) {
                layers.add(this.buildMapLayerInfo(layerName2));
                continue;
            }
            boolean found = false;
            String catalogLayerName2 = null;
            for (String catalogLayerName2 : this.catalog.getLayerNames()) {
                try {
                    FeatureTypeInfo ftype = this.findFeatureLayer(catalogLayerName2);
                    String wmsPath = ftype.getWmsPath();
                    if (wmsPath == null || !wmsPath.matches(".*/" + layerName2)) continue;
                    layers.add(this.buildMapLayerInfo(catalogLayerName2));
                    found = true;
                }
                catch (Exception e_1) {
                    try {
                        CoverageInfo cv = this.findCoverageLayer(catalogLayerName2);
                        String wmsPath = cv.getWmsPath();
                        if (wmsPath == null || !wmsPath.matches(".*/" + layerName2)) continue;
                        layers.add(this.buildMapLayerInfo(catalogLayerName2));
                        found = true;
                    }
                    catch (Exception e_2) {}
                }
            }
            if (found) continue;
            throw new WmsException("Could not find layer " + layerName2, "LayerNotDefined");
        }
        if (layers.size() == 0) {
            throw new WmsException("No LAYERS has been requested", ((Object)((Object)this)).getClass().getName());
        }
        return layers.toArray(new MapLayerInfo[layers.size()]);
    }

    private static DataStore connectRemoteWFS(URL remoteOwsUrl) throws WmsException {
        try {
            WFSDataStoreFactory factory = new WFSDataStoreFactory();
            HashMap<String, Object> params = new HashMap<String, Object>(factory.getImplementationHints());
            params.put(WFSDataStoreFactory.URL.key, remoteOwsUrl + "request=GetCapabilities&service=WFS");
            params.put(WFSDataStoreFactory.TRY_GZIP.key, Boolean.TRUE);
            return factory.createDataStore(params);
        }
        catch (Exception e) {
            throw new WmsException("Could not connect to remote OWS", "RemoteOWSFailure", e);
        }
    }

    private MapLayerInfo buildMapLayerInfo(String layerName) throws Exception {
        MapLayerInfo li = new MapLayerInfo();
        FeatureTypeInfo ftype = this.findFeatureLayer(layerName);
        if (ftype != null) {
            li.setFeature(ftype);
        } else {
            CoverageInfo cv = this.findCoverageLayer(layerName);
            if (cv != null) {
                li.setCoverage(cv);
            } else if (this.wms.getBaseMapLayers().containsKey(layerName)) {
                String styleCsl = (String)this.wms.getBaseMapStyles().get(layerName);
                String layerCsl = (String)this.wms.getBaseMapLayers().get(layerName);
                MapLayerInfo[] layerArray = this.parseLayers(KvpUtils.readFlat((String)layerCsl), null, null);
                List styleList = this.parseStyles(KvpUtils.readFlat((String)styleCsl));
                li.setBase(layerName, new ArrayList<MapLayerInfo>(Arrays.asList(layerArray)), styleList);
            } else {
                throw new WmsException("Layer " + layerName + " could not be found");
            }
        }
        return li;
    }

    FeatureTypeInfo findFeatureLayer(String layerName) throws WmsException {
        FeatureTypeInfo ftype = null;
        Integer layerType = this.catalog.getLayerType(layerName);
        if (Data.TYPE_VECTOR != layerType) {
            return null;
        }
        ftype = this.catalog.getFeatureTypeInfo(layerName);
        return ftype;
    }

    CoverageInfo findCoverageLayer(String layerName) throws WmsException {
        CoverageInfo cv = null;
        Integer layerType = this.catalog.getLayerType(layerName);
        if (Data.TYPE_RASTER != layerType) {
            return null;
        }
        cv = this.catalog.getCoverageInfo(layerName);
        return cv;
    }

    protected List parseStyles(List styleNames) throws Exception {
        ArrayList<Style> styles = new ArrayList<Style>();
        for (String styleid : styleNames) {
            if ("".equals(styleid)) {
                styles.add(null);
                continue;
            }
            Style style = this.catalog.getStyle(styleid);
            if (style == null) {
                String msg = "No such style: " + styleid;
                throw new WmsException(msg, "StyleNotDefined");
            }
            styles.add(style);
        }
        return styles;
    }

    public boolean isLaxStyleMatchAllowed() {
        return this.laxStyleMatchAllowed;
    }

    public void setLaxStyleMatchAllowed(boolean laxStyleMatchAllowed) {
        this.laxStyleMatchAllowed = laxStyleMatchAllowed;
    }
}

