/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.servlets;

import com.vividsolutions.jts.geom.Envelope;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.requests.GetKMLReflectKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.servlets.WMService;

public class KMLReflector
extends WMService {
    private static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.wms.servlets");
    final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml";
    final String KMZ_MIME_TYPE = "application/vnd.google-earth.kmz+xml";
    final int KMSCORE = 50;
    final int REFRESH = 1;
    final boolean KMATTR = true;
    final boolean TRANSPARENT = true;
    final int WIDTH = 1024;
    final int HEIGHT = 1024;
    final String VERSION = "1.0.0";
    final String SRS = "EPSG:4326";
    final String DEFAULT_BBOX = "-180,-90,180,90";
    static /* synthetic */ Class class$org$vfny$geoserver$global$GeoServer;

    public KMLReflector() {
        super("kml_reflect", null);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setWMS((WMS)((Object)config.getServletContext().getAttribute("WMS")));
    }

    protected Response getResponseHandler() {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return new GetMapResponse(this.getWMS(), (ApplicationContext)context);
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return new GetKMLReflectKvpReader(params, this);
    }

    protected XmlRequestReader getXmlRequestReader() {
        throw new UnsupportedOperationException("Method getXmlRequestReader() not yet implemented.");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int i;
        String filter;
        GetMapRequest serviceRequest;
        response.setContentType("application/vnd.google-earth.kml+xml");
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String paramName = (String)pnames.nextElement();
            String paramValue = request.getParameter(paramName);
            requestParams.put(paramName.toUpperCase(), paramValue);
        }
        if (!requestParams.containsKey("BBOX")) {
            requestParams.put("BBOX", "-180,-90,180,90");
        }
        KvpRequestReader requestReader = this.getKvpReader(requestParams);
        try {
            serviceRequest = (GetMapRequest)requestReader.getRequest(request);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        MapLayerInfo[] layers = serviceRequest.getLayers();
        LOGGER.info("KML NetworkLink sharing " + layers.length + " layer(s) created.");
        Style[] styles = null;
        if (serviceRequest.getStyles() != null && !serviceRequest.getStyles().isEmpty()) {
            styles = serviceRequest.getStyles().toArray(new Style[0]);
        }
        if (!requestParams.containsKey("TRANSPARENT")) {
            serviceRequest.setTransparent(true);
        }
        if (!requestParams.containsKey("KMATTR")) {
            serviceRequest.setKMattr(true);
        }
        if (!requestParams.containsKey("KMSCORE")) {
            serviceRequest.setKMScore(50);
        }
        if (!requestParams.containsKey("WIDTH")) {
            serviceRequest.setWidth(1024);
        }
        if (!requestParams.containsKey("HEIGHT")) {
            serviceRequest.setHeight(1024);
        }
        if (!requestParams.containsKey("VERSION")) {
            serviceRequest.setVersion("1.0.0");
        }
        ArrayList<String> filters = null;
        String filterKey = null;
        if (requestParams.containsKey("FILTER")) {
            filter = (String)requestParams.get("FILTER");
            filters = KvpUtils.readFlat((String)filter, (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
            filterKey = "filter";
        } else if (requestParams.containsKey("CQL_FILTER")) {
            filter = (String)requestParams.get("CQL_FILTER");
            filters = KvpUtils.readFlat((String)filter, (KvpUtils.Tokenizer)KvpUtils.CQL_DELIMITER);
            filterKey = "cql_filter";
        } else if (requestParams.containsKey("FEATUREID")) {
            filter = (String)requestParams.get("FEATUREID");
            filters = new ArrayList<String>();
            for (i = 0; i < layers.length; ++i) {
                filters.add(filter);
            }
            filterKey = "featureid";
        }
        if (filters != null && filters.size() != layers.length) {
            throw (IOException)new IOException().initCause(new ServiceException(layers.length + " layers specified, but " + filters.size() + " filters"));
        }
        StringBuffer filename = new StringBuffer();
        for (i = 0; i < layers.length; ++i) {
            String name = layers[i].getName();
            int j = name.indexOf(58);
            if (j > -1) {
                name = name.substring(j + 1);
            }
            filename.append(name + "_");
        }
        filename.setLength(filename.length() - 1);
        response.setHeader("Content-Disposition", "attachment; filename=" + filename.toString() + ".kml");
        serviceRequest.setFormat("application/vnd.google-earth.kml+xml");
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        sb.append("<Folder>\n");
        String proxifiedBaseUrl = RequestUtils.baseURL((HttpServletRequest)request);
        GeoServer gs = (GeoServer)GeoServerExtensions.extensions((Class)(class$org$vfny$geoserver$global$GeoServer == null ? (class$org$vfny$geoserver$global$GeoServer = KMLReflector.class$("org.vfny.geoserver.global.GeoServer")) : class$org$vfny$geoserver$global$GeoServer)).get(0);
        proxifiedBaseUrl = RequestUtils.proxifiedBaseURL((String)proxifiedBaseUrl, (String)gs.getProxyBaseUrl());
        Envelope layerbbox = null;
        for (int i2 = 0; i2 < layers.length; ++i2) {
            String style = "&styles=" + layers[i2].getDefaultStyle().getName();
            if (styles != null && styles.length >= i2 + 1) {
                style = "&styles=" + styles[i2].getName();
            }
            String filter2 = filters != null ? filters.get(i2) : null;
            filter2 = filter2 != null ? "&" + filterKey + "=" + filter2 : "";
            Envelope le = layers[i2].getLatLongBoundingBox();
            if (layerbbox == null) {
                layerbbox = new Envelope(le);
            } else {
                layerbbox.expandToInclude(le);
            }
            if (serviceRequest.getSuperOverlay()) {
                Envelope bbox = serviceRequest.getBbox();
                sb.append("<NetworkLink>\n");
                sb.append("<name>" + layers[0].getName() + "</name>\n");
                sb.append("<Region>");
                sb.append("<LatLonAltBox>");
                sb.append("<north>" + bbox.getMaxY() + "</north>");
                sb.append("<south>" + bbox.getMinY() + "</south>");
                sb.append("<east>" + bbox.getMaxX() + "</east>");
                sb.append("<west>" + bbox.getMinX() + "</west>");
                sb.append("</LatLonAltBox>");
                sb.append("<Lod>");
                sb.append("<minLodPixels>256</minLodPixels>");
                sb.append("<maxLodPixels>-1</maxLodPixels>");
                sb.append("</Lod>");
                sb.append("</Region>");
                sb.append("<Link>\n");
                sb.append("<href><![CDATA[" + proxifiedBaseUrl + "/wms?service=WMS&request=GetMap&format=application/vnd.google-earth.kml+XML" + "&width=" + 1024 + "&height=" + 1024 + "&srs=" + "EPSG:4326" + "&layers=" + layers[i2].getName() + style + "&bbox=" + (String)requestParams.get("BBOX") + filter2 + "&legend=" + String.valueOf(serviceRequest.getLegend()) + "&superoverlay=true]]></href>\n");
                sb.append("<viewRefreshMode>onRegion</viewRefreshMode>\n");
                sb.append("</Link>\n");
                sb.append("</NetworkLink>\n");
                continue;
            }
            sb.append("<NetworkLink>\n");
            sb.append(this.getLookAt(le));
            sb.append("<name>" + layers[i2].getName() + "</name>\n");
            sb.append("<open>1</open>\n");
            sb.append("<visibility>1</visibility>\n");
            sb.append("<Url>\n");
            sb.append("<href><![CDATA[" + proxifiedBaseUrl + "/wms?service=WMS&request=GetMap&format=application/vnd.google-earth.kmz+XML" + "&width=" + 1024 + "&height=" + 1024 + "&srs=" + "EPSG:4326" + "&layers=" + layers[i2].getName() + style + filter2 + "&KMScore=" + serviceRequest.getKMScore() + "&KMAttr=" + String.valueOf(serviceRequest.getKMattr()) + "&legend=" + String.valueOf(serviceRequest.getLegend()) + "]]></href>\n");
            sb.append("<viewRefreshMode>onStop</viewRefreshMode>\n");
            sb.append("<viewRefreshTime>1</viewRefreshTime>\n");
            sb.append("</Url>\n");
            sb.append("</NetworkLink>\n");
        }
        sb.append(this.getLookAt(layerbbox));
        sb.append("</Folder>\n");
        sb.append("</kml>\n");
        byte[] kml_b = sb.toString().getBytes();
        out.write(kml_b);
        out.flush();
    }

    private String getLookAt(Envelope e) {
        double lon1 = e.getMinX();
        double lat1 = e.getMinY();
        double lon2 = e.getMaxX();
        double lat2 = e.getMaxY();
        double R_EARTH = 6371000.0;
        double VIEWER_WIDTH = 0.3839724354387525;
        double[] p1 = this.getRect(lon1, lat1, R_EARTH);
        double[] p2 = this.getRect(lon2, lat2, R_EARTH);
        double[] midpoint = new double[]{(p1[0] + p2[0]) / 2.0, (p1[1] + p2[1]) / 2.0, (p1[2] + p2[2]) / 2.0};
        midpoint = this.getGeographic(midpoint[0], midpoint[1], midpoint[2]);
        midpoint[0] = (lon1 + lon2) / 2.0;
        double distance = this.distance(p1, p2);
        double height = distance / (2.0 * Math.tan(VIEWER_WIDTH));
        LOGGER.fine("lat1: " + lat1 + "; lon1: " + lon1);
        LOGGER.fine("lat2: " + lat2 + "; lon2: " + lon2);
        LOGGER.fine("latmid: " + midpoint[1] + "; lonmid: " + midpoint[0]);
        return "<LookAt id=\"geoserver\">  <longitude>" + (lon1 + lon2) / 2.0 + "</longitude>      <!-- kml:angle180 -->" + "  <latitude>" + midpoint[1] + "</latitude>        <!-- kml:angle90 -->" + "  <altitude>0</altitude>       <!-- double --> " + "  <range>" + distance + "</range>              <!-- double -->" + "  <tilt>0</tilt>               <!-- float -->" + "  <heading>0</heading>         <!-- float -->" + "  <altitudeMode>clampToGround</altitudeMode> " + "  <!--kml:altitudeModeEnum:clampToGround, relativeToGround, absolute -->" + "</LookAt>";
    }

    private double[] getRect(double lat, double lon, double radius) {
        double theta = (90.0 - lat) * Math.PI / 180.0;
        double phi = (90.0 - lon) * Math.PI / 180.0;
        double x = radius * Math.sin(phi) * Math.cos(theta);
        double y = radius * Math.sin(phi) * Math.sin(theta);
        double z = radius * Math.cos(phi);
        return new double[]{x, y, z};
    }

    private double[] getGeographic(double x, double y, double z) {
        double radius = this.distance(new double[]{x, y, z}, new double[]{0.0, 0.0, 0.0});
        double theta = Math.atan2(Math.sqrt(x * x + y * y), z);
        double phi = Math.atan2(y, x);
        double lat = 90.0 - theta * 180.0 / Math.PI;
        double lon = 90.0 - phi * 180.0 / Math.PI;
        return new double[]{lon > 180.0 ? lon - 360.0 : lon, lat, radius};
    }

    private double distance(double[] p1, double[] p2) {
        double dx = p1[0] - p2[0];
        double dy = p1[1] - p2[1];
        double dz = p1[2] - p2[2];
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

