/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.crs.ReprojectFeatureResults;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Or;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLLegendTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLRasterTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLSuperOverlayTransformer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformerBase;
import org.vfny.geoserver.wms.responses.map.kml.KMLVectorTransformer;
import org.xml.sax.ContentHandler;

public class KMLTransformer
extends TransformerBase {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.kml");
    FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
    private static final CoordinateReferenceSystem WGS84;
    boolean kmz = false;

    public KMLTransformer() {
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new KMLTranslator(handler);
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }

    public void setKmz(boolean kmz) {
        this.kmz = kmz;
    }

    static {
        try {
            WGS84 = CRS.decode((String)"EPSG:4326");
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot decode EPSG:4326, the CRS subsystem must be badly broken...");
        }
    }

    protected class KMLTranslator
    extends TransformerBase.TranslatorSupport {
        static final double TOLERANCE = 1.0E-6;
        static final int RULES = 0;
        static final int ELSE_RULES = 1;
        private double scaleDenominator;

        public KMLTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            int i;
            boolean group;
            this.start("kml");
            WMSMapContext mapContext = (WMSMapContext)((Object)o);
            GetMapRequest request = mapContext.getRequest();
            MapLayer[] layers = mapContext.getLayers();
            this.scaleDenominator = 1.0;
            try {
                this.scaleDenominator = RendererUtilities.calculateScale((ReferencedEnvelope)mapContext.getAreaOfInterest(), (int)mapContext.getMapWidth(), (int)mapContext.getMapHeight(), null);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error calculating scale denominator", e);
            }
            LOGGER.fine("scale denominator = " + this.scaleDenominator);
            boolean bl = group = layers.length > 1 || request.getLegend();
            if (group) {
                StringBuffer sb = new StringBuffer();
                for (int i2 = 0; i2 < layers.length; ++i2) {
                    sb.append(layers[i2].getTitle() + ",");
                }
                sb.setLength(sb.length() - 1);
                this.start("Document");
                this.element("name", sb.toString());
            }
            for (i = 0; i < layers.length; ++i) {
                MapLayer layer = layers[i];
                MapLayerInfo layerInfo = mapContext.getRequest().getLayers()[i];
                if (mapContext.getRequest().getSuperOverlay()) {
                    this.encodeSuperOverlayLayer(mapContext, layer);
                    continue;
                }
                if (layerInfo.getType() == MapLayerInfo.TYPE_VECTOR || layerInfo.getType() == MapLayerInfo.TYPE_REMOTE_VECTOR) {
                    this.encodeVectorLayer(mapContext, layer);
                    continue;
                }
                this.encodeRasterLayer(mapContext, layer);
            }
            if (request.getLegend()) {
                for (i = 0; i < layers.length; ++i) {
                    MapLayer layer = layers[i];
                    this.encodeLegend(mapContext, layer);
                }
            }
            if (group) {
                this.end("Document");
            }
            this.end("kml");
        }

        protected void encodeVectorLayer(WMSMapContext mapContext, MapLayer layer) {
            FeatureSource featureSource = layer.getFeatureSource();
            FeatureCollection features = null;
            try {
                features = this.loadFeatureCollection(featureSource, layer, mapContext);
                if (features == null) {
                    return;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (KMLTransformer.this.kmz) {
                int kmscore = mapContext.getRequest().getKMScore();
                boolean useVector = this.useVectorOutput(kmscore, features.size());
                if (useVector) {
                    KMLVectorTransformer tx = this.createVectorTransformer(mapContext, layer);
                    this.initTransformer(tx);
                    tx.setScaleDenominator(this.scaleDenominator);
                    tx.createTranslator(this.contentHandler).encode((Object)features);
                } else {
                    KMLRasterTransformer tx = this.createRasterTransfomer(mapContext);
                    this.initTransformer(tx);
                    tx.setInline(true);
                    tx.createTranslator(this.contentHandler).encode((Object)layer);
                }
            } else {
                KMLVectorTransformer tx = this.createVectorTransformer(mapContext, layer);
                this.initTransformer(tx);
                tx.setScaleDenominator(this.scaleDenominator);
                tx.createTranslator(this.contentHandler).encode((Object)features);
            }
        }

        protected KMLRasterTransformer createRasterTransfomer(WMSMapContext mapContext) {
            return new KMLRasterTransformer(mapContext);
        }

        protected KMLVectorTransformer createVectorTransformer(WMSMapContext mapContext, MapLayer layer) {
            return new KMLVectorTransformer(mapContext, layer);
        }

        protected void encodeRasterLayer(WMSMapContext mapContext, MapLayer layer) {
            KMLRasterTransformer tx = this.createRasterTransfomer(mapContext);
            this.initTransformer(tx);
            tx.setInline(KMLTransformer.this.kmz);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeSuperOverlayLayer(WMSMapContext mapContext, MapLayer layer) {
            KMLSuperOverlayTransformer tx = new KMLSuperOverlayTransformer(mapContext);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void encodeLegend(WMSMapContext mapContext, MapLayer layer) {
            KMLLegendTransformer tx = new KMLLegendTransformer(mapContext);
            this.initTransformer(tx);
            tx.createTranslator(this.contentHandler).encode((Object)layer);
        }

        protected void initTransformer(KMLTransformerBase delegate) {
            delegate.setIndentation(KMLTransformer.this.getIndentation());
            delegate.setStandAlone(false);
        }

        double computeScaleDenominator(MapLayer layer, WMSMapContext mapContext) {
            Rectangle paintArea = new Rectangle(mapContext.getMapWidth(), mapContext.getMapHeight());
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapContext.getAreaOfInterest(), (Rectangle)paintArea);
            try {
                return RendererUtilities.calculateScale((Envelope)mapContext.getAreaOfInterest(), (CoordinateReferenceSystem)mapContext.getCoordinateReferenceSystem(), (int)paintArea.width, (int)paintArea.height, (double)90.0);
            }
            catch (Exception e) {
                return 1.0 / worldToScreen.getScaleX();
            }
        }

        boolean useVectorOutput(int kmscore, int numFeatures) {
            if (kmscore == 100) {
                return true;
            }
            if (kmscore == 0) {
                return false;
            }
            double magic = Math.pow(10.0, kmscore / 15);
            return !((double)numFeatures > magic);
        }

        FeatureCollection loadFeatureCollection(FeatureSource featureSource, MapLayer layer, WMSMapContext mapContext) throws Exception {
            boolean reprojectBBox;
            FeatureType schema = featureSource.getSchema();
            ReferencedEnvelope envelope = mapContext.getAreaOfInterest();
            ReferencedEnvelope aoi = new ReferencedEnvelope((Envelope)envelope, mapContext.getCoordinateReferenceSystem());
            CoordinateReferenceSystem sourceCrs = schema.getDefaultGeometry().getCoordinateSystem();
            boolean bl = reprojectBBox = sourceCrs != null && !CRS.equalsIgnoreMetadata((Object)aoi.getCoordinateReferenceSystem(), (Object)sourceCrs);
            if (reprojectBBox) {
                aoi = aoi.transform(sourceCrs, true);
            }
            Filter filter = this.createBBoxFilter(schema, (Envelope)aoi);
            DefaultQuery q = new DefaultQuery(schema.getTypeName());
            q.setFilter(filter);
            Query definitionQuery = layer.getQuery();
            if (definitionQuery != Query.ALL) {
                q = q == Query.ALL ? (DefaultQuery)definitionQuery : (DefaultQuery)DataUtilities.mixQueries((Query)definitionQuery, (Query)q, (String)"KMLEncoder");
            }
            if (sourceCrs != null && !CRS.equalsIgnoreMetadata((Object)WGS84, (Object)sourceCrs)) {
                return new ReprojectFeatureResults(featureSource.getFeatures((Query)q), WGS84);
            }
            List[] rules = this.getLayerRules(featureSource.getSchema(), layer.getStyle());
            if (rules[0].size() == 0 && rules[1].size() == 0) {
                return null;
            }
            if (rules[1].size() == 0) {
                Filter newFilter = this.summarizeRuleFilters(rules[0], q.getFilter());
                q.setFilter(newFilter);
            }
            return featureSource.getFeatures((Query)q);
        }

        private List[] getLayerRules(FeatureType ftype, Style style) {
            List[] result = new List[]{new ArrayList(), new ArrayList()};
            String typeName = ftype.getTypeName();
            FeatureTypeStyle[] featureStyles = style.getFeatureTypeStyles();
            int length = featureStyles.length;
            for (int i = 0; i < length; ++i) {
                FeatureTypeStyle fts = featureStyles[i];
                if (typeName == null || !ftype.isDescendedFrom(null, fts.getFeatureTypeName()) && !typeName.equalsIgnoreCase(fts.getFeatureTypeName())) continue;
                Rule[] ftsRules = fts.getRules();
                for (int j = 0; j < ftsRules.length; ++j) {
                    Rule r = ftsRules[j];
                    if (!this.isWithInScale(r)) continue;
                    if (r.hasElseFilter()) {
                        result[1].add(r);
                        continue;
                    }
                    result[0].add(r);
                }
            }
            return result;
        }

        private Filter summarizeRuleFilters(List rules, Filter originalFiter) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            Iterator it = rules.iterator();
            while (it.hasNext()) {
                Rule rule = (Rule)it.next();
                if (rule.getFilter() == null || Filter.INCLUDE.equals((Object)rule.getFilter())) {
                    return originalFiter;
                }
                filters.add(rule.getFilter());
            }
            FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
            Or summary = ff.or(filters);
            if (originalFiter != null && !Filter.INCLUDE.equals((Object)originalFiter)) {
                return ff.and(originalFiter, (Filter)summary);
            }
            return summary;
        }

        boolean isWithInScale(Rule r) {
            return r.getMinScaleDenominator() - 1.0E-6 <= this.scaleDenominator && r.getMaxScaleDenominator() + 1.0E-6 > this.scaleDenominator;
        }

        Filter createBBoxFilter(FeatureType schema, Envelope bbox) throws IllegalFilterException {
            ArrayList<BBOX> filters = new ArrayList<BBOX>();
            for (int j = 0; j < schema.getAttributeCount(); ++j) {
                AttributeType attType = schema.getAttributeType(j);
                if (!(attType instanceof GeometryAttributeType)) continue;
                BBOX gfilter = KMLTransformer.this.filterFactory.bbox(attType.getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
                filters.add(gfilter);
            }
            if (filters.size() == 0) {
                return Filter.INCLUDE;
            }
            if (filters.size() == 1) {
                return (Filter)filters.get(0);
            }
            return KMLTransformer.this.filterFactory.or(filters);
        }
    }
}

