/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.GetMapProducerFactorySpi;
import org.vfny.geoserver.wms.responses.map.kml.KMLMapProducer;

public class KMLMapProducerFactory
implements GetMapProducerFactorySpi {
    private static final String PRODUCE_TYPE = "kml";
    public static final String MIME_TYPE = "application/vnd.google-earth.kml+xml";
    private static final Set SUPPORTED_FORMATS = Collections.singleton("application/vnd.google-earth.kml+xml");

    public String getName() {
        return "Keyhole markup language producer";
    }

    public Set getSupportedFormats() {
        return SUPPORTED_FORMATS;
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean canProduce(String mapFormat) {
        return mapFormat != null && (mapFormat.startsWith(PRODUCE_TYPE) || mapFormat.startsWith("application/vnd.google-earth.kml"));
    }

    public GetMapProducer createMapProducer(String mapFormat, WMS wms) throws IllegalArgumentException {
        if (this.canProduce(mapFormat)) {
            return new KMLMapProducer(mapFormat, MIME_TYPE);
        }
        throw new IllegalArgumentException("Unable to produce format " + mapFormat);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

