/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.geotools.map.MapLayer;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.map.kml.KMLTransformer;

class KMLMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.kml");
    protected KMLTransformer transformer;

    public KMLMapProducer(String mapFormat, String mime_type) {
        super(mapFormat, mime_type);
    }

    public void abort(Service gs) {
        if (this.transformer != null) {
            // empty if block
        }
    }

    public void abort() {
        LOGGER.fine("aborting KML map response");
        if (this.transformer != null) {
            LOGGER.info("aborting KML encoder");
        }
    }

    public void produceMap() throws WmsException {
        this.transformer = new KMLTransformer();
        this.transformer.setIndentation(3);
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        try {
            this.transformer.transform((Object)this.mapContext, out);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public String getContentDisposition() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mapContext.getLayerCount(); ++i) {
            MapLayer layer = this.mapContext.getLayer(i);
            String title = layer.getFeatureSource().getSchema().getTypeName();
            if (title == null || title.equals("")) continue;
            sb.append(title).append("_");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return "attachment; filename=" + sb.toString() + ".kml";
        }
        return "attachment; filename=geoserver.kml";
    }
}

