/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.media.jai.GraphicsJAI;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.kml.AbortedException;
import org.vfny.geoserver.wms.responses.map.kml.KMLWriter;

public class EncodeKML {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.kml");
    private static final String KML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\t<kml xmlns=\"http://earth.google.com/kml/2.0\">\n";
    private static final String KML_FOOTER = "</kml>\n";
    private WMSMapContext mapContext;
    private KMLWriter writer;
    private FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private boolean abortProcess;

    public EncodeKML(WMSMapContext mapContext) {
        this.mapContext = mapContext;
    }

    public void abort() {
        this.abortProcess = true;
    }

    public void encodeKML(OutputStream out) throws IOException {
        this.writer = new KMLWriter(out, this.mapContext);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            this.writeHeader();
            ArrayList layerRenderList = new ArrayList();
            this.writeLayers(false, layerRenderList);
            this.writeFooter();
            this.writer.flush();
            t = System.currentTimeMillis() - t;
            LOGGER.fine("KML generated, it took" + t + " ms");
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("KML encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    public void encodeKMZ(ZipOutputStream out) throws IOException {
        this.writer = new KMLWriter((OutputStream)out, this.mapContext);
        this.abortProcess = false;
        long t = System.currentTimeMillis();
        try {
            ZipEntry e = new ZipEntry("wms.kml");
            out.putNextEntry(e);
            this.writeHeader();
            ArrayList layerRenderList = new ArrayList();
            this.writeLayers(true, layerRenderList);
            this.writeFooter();
            this.writer.flush();
            out.closeEntry();
            this.writeImages(out, layerRenderList);
            t = System.currentTimeMillis() - t;
            LOGGER.fine("KMZ generated, it took" + t + " ms");
        }
        catch (IOException ioe) {
            if (this.abortProcess) {
                LOGGER.fine("KMZ encoding aborted");
                return;
            }
            throw ioe;
        }
        catch (AbortedException ex) {
            return;
        }
    }

    private boolean useVectorOutput(int kmscore, int numFeatures) {
        if (kmscore == 100) {
            return true;
        }
        if (kmscore == 0) {
            return false;
        }
        double magic = Math.pow(10.0, kmscore / 15);
        return !((double)numFeatures > magic);
    }

    private void writeHeader() throws IOException {
        this.writer.write(KML_HEADER);
    }

    private void writeFooter() throws IOException {
        this.writer.write(KML_FOOTER);
    }

    private void writeLayers(boolean kmz, ArrayList layerRenderList) throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        int imageWidth = this.mapContext.getMapWidth();
        int imageHeight = this.mapContext.getMapHeight();
        if (nLayers > 1) {
            this.writer.startDocument("GeoServer", null);
        }
        for (int i = 0; i < nLayers; ++i) {
            MapLayer layer = layers[i];
            this.writer.startDocument(layer.getTitle(), null);
            FeatureSource fSource = layer.getFeatureSource();
            FeatureType schema = fSource.getSchema();
            Rectangle paintArea = new Rectangle(imageWidth, imageHeight);
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)this.mapContext.getAreaOfInterest(), (Rectangle)paintArea);
            double scaleDenominator = 1.0;
            try {
                scaleDenominator = RendererUtilities.calculateScale((Envelope)this.mapContext.getAreaOfInterest(), (CoordinateReferenceSystem)this.mapContext.getCoordinateReferenceSystem(), (int)paintArea.width, (int)paintArea.height, (double)90.0);
            }
            catch (Exception e) {
                scaleDenominator = 1.0 / worldToScreen.getScaleX();
            }
            this.writer.setRequestedScale(scaleDenominator);
            boolean isRaster = false;
            AttributeType[] ats = schema.getAttributeTypes();
            int length = ats.length;
            String[] attributes = new String[length];
            for (int t = 0; t < length; ++t) {
                attributes[t] = ats[t].getName();
                if (!attributes[t].equals("grid")) continue;
                isRaster = true;
            }
            try {
                CoordinateReferenceSystem sourceCrs = schema.getDefaultGeometry().getCoordinateSystem();
                this.writer.setSourceCrs(sourceCrs);
                ReferencedEnvelope envelope = this.mapContext.getAreaOfInterest();
                ReferencedEnvelope aoi = new ReferencedEnvelope((Envelope)envelope, this.mapContext.getCoordinateReferenceSystem());
                Filter filter = null;
                if (!CRS.equalsIgnoreMetadata((Object)aoi.getCoordinateReferenceSystem(), (Object)schema.getDefaultGeometry().getCoordinateSystem())) {
                    aoi = aoi.transform(schema.getDefaultGeometry().getCoordinateSystem(), true);
                }
                filter = this.createBBoxFilters(schema, attributes, (Envelope)aoi);
                DefaultQuery q = new DefaultQuery(schema.getTypeName());
                q.setFilter(filter);
                q.setPropertyNames(attributes);
                Query definitionQuery = layer.getQuery();
                if (definitionQuery != Query.ALL) {
                    q = q == Query.ALL ? (DefaultQuery)definitionQuery : (DefaultQuery)DataUtilities.mixQueries((Query)definitionQuery, (Query)q, (String)"KMLEncoder");
                }
                q.setCoordinateSystem(layer.getFeatureSource().getSchema().getDefaultGeometry().getCoordinateSystem());
                FeatureCollection fc = fSource.getFeatures((Query)q);
                int kmscore = this.mapContext.getRequest().getKMScore();
                boolean useVector = this.useVectorOutput(kmscore, fc.size());
                if (useVector || !kmz) {
                    LOGGER.info("Layer (" + layer.getTitle() + ") rendered with KML vector output.");
                    layerRenderList.add(new Integer(i));
                    if (!isRaster) {
                        this.writer.writeFeaturesAsVectors(fc, layer);
                    } else {
                        this.writer.writeCoverages(fc, layer);
                    }
                } else {
                    LOGGER.info("Layer (" + layer.getTitle() + ") rendered with KMZ raster output.");
                    this.writer.writeFeaturesAsRaster(fc, layer, i);
                }
                LOGGER.fine("finished writing");
            }
            catch (IOException ex) {
                LOGGER.info("process failed: " + ex.getMessage());
                throw ex;
            }
            catch (AbortedException ae) {
                LOGGER.info("process aborted: " + ae.getMessage());
                throw ae;
            }
            catch (Throwable t) {
                LOGGER.warning("UNCAUGHT exception: " + t.getMessage());
                IOException ioe = new IOException("UNCAUGHT exception: " + t.getMessage());
                ioe.setStackTrace(t.getStackTrace());
                throw ioe;
            }
            this.writer.endDocument();
        }
        if (nLayers > 1) {
            this.writer.endDocument();
        }
    }

    private void writeImages(ZipOutputStream outZ, ArrayList layerRenderList) throws IOException, AbortedException {
        MapLayer[] layers = this.mapContext.getLayers();
        int nLayers = layers.length;
        for (int i = 0; i < nLayers; ++i) {
            int num;
            if (layerRenderList.size() > 0 && (num = ((Integer)layerRenderList.get(0)).intValue()) == i) {
                layerRenderList.remove(0);
                continue;
            }
            MapLayer layer = layers[i];
            WMSMapContext map = this.mapContext;
            map.clearLayerList();
            map.addLayer(layer);
            int width = this.mapContext.getMapWidth();
            int height = this.mapContext.getMapHeight();
            LOGGER.fine("setting up " + width + "x" + height + " image");
            BufferedImage curImage = new BufferedImage(width, height, 6);
            GraphicsJAI graphic = GraphicsJAI.createGraphicsJAI((Graphics2D)curImage.createGraphics(), null);
            LOGGER.fine("setting to transparent");
            int type = 2;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(this.mapContext.getBgColor().getRed(), this.mapContext.getBgColor().getGreen(), this.mapContext.getBgColor().getBlue(), 0);
            graphic.setBackground(this.mapContext.getBgColor());
            graphic.setColor(c);
            graphic.fillRect(0, 0, width, height);
            type = 3;
            graphic.setComposite(AlphaComposite.getInstance(type));
            Rectangle paintArea = new Rectangle(width, height);
            StreamingRenderer renderer = new StreamingRenderer();
            renderer.setContext((MapContext)map);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderer.setJava2DHints(hints);
            HashMap<String, Comparable<Boolean>> rendererParams = new HashMap<String, Comparable<Boolean>>();
            rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
            rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
            renderer.setRendererHints(rendererParams);
            ReferencedEnvelope dataArea = map.getAreaOfInterest();
            AffineTransform at = RendererUtilities.worldToScreenTransform((Envelope)dataArea, (Rectangle)paintArea);
            renderer.paint((Graphics2D)graphic, paintArea, (Envelope)dataArea, at);
            graphic.dispose();
            ZipEntry e = new ZipEntry("layer_" + i + ".png");
            outZ.putNextEntry(e);
            new ImageWorker((RenderedImage)curImage).writePNG((Object)outZ, "FILTERED", 0.75f, false, false);
            outZ.closeEntry();
        }
    }

    private Filter createBBoxFilters(FeatureType schema, String[] attributes, Envelope bbox) throws IllegalFilterException {
        ArrayList<BBOX> filters = new ArrayList<BBOX>();
        int length = attributes.length;
        for (int j = 0; j < length; ++j) {
            AttributeType attType = schema.getAttributeType(attributes[j]);
            if (attType == null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Could not find '" + attributes[j] + "' in the FeatureType (" + schema.getTypeName() + ")");
                }
                throw new IllegalFilterException("Could not find '" + (attributes[j] + "' in the FeatureType (") + schema.getTypeName() + ")");
            }
            if (!(attType instanceof GeometryAttributeType)) continue;
            BBOX gfilter = this.filterFactory.bbox(attType.getLocalName(), bbox.getMinX(), bbox.getMinY(), bbox.getMaxX(), bbox.getMaxY(), null);
            filters.add(gfilter);
        }
        if (filters.size() == 0) {
            return Filter.INCLUDE;
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return this.filterFactory.or(filters);
    }
}

