/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetKMLReflectKvpReader
extends GetMapKvpReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers.wms");

    public GetKMLReflectKvpReader(Map kvpPairs, WMService service) {
        super(kvpPairs, service);
        this.setStylesRequired(false);
    }

    public void parseOptionalParameters(GetMapRequest request) throws WmsException {
        super.parseOptionalParameters(request);
        if (this.keyExists("WIDTH") && this.keyExists("HEIGHT")) {
            try {
                int width = Integer.parseInt(this.getValue("WIDTH"));
                int height = Integer.parseInt(this.getValue("HEIGHT"));
                request.setWidth(width);
                request.setHeight(height);
            }
            catch (NumberFormatException ex) {
                throw new WmsException("WIDTH and HEIGHT incorrectly specified, they must be integers");
            }
        }
        if (this.keyExists("FORMAT")) {
            String format = this.getValue("FORMAT");
            request.setFormat(format);
        }
    }

    public void parseMandatoryParameters(GetMapRequest request, boolean parseStylesLayers) throws WmsException {
        Envelope bbox = this.parseBbox(this.getValue("BBOX"));
        request.setBbox(bbox);
        if (parseStylesLayers) {
            this.parseLayersAndStyles(request);
        }
    }

    protected void parseLayersAndStyles(GetMapRequest request) throws WmsException {
        String sldParam = this.getValue("SLD");
        String sldBodyParam = this.getValue("SLD_BODY");
        if (sldBodyParam != null) {
            LOGGER.fine("Getting layers and styles from SLD_BODY");
            this.parseSldBodyParam(request);
        } else if (sldParam != null) {
            LOGGER.fine("Getting layers and styles from reomte SLD");
            this.parseSldParam(request);
        } else {
            MapLayerInfo[] featureTypes = this.parseLayersParam(request);
            List styles = null;
            request.setLayers(featureTypes);
            if (this.isStylesRquired()) {
                styles = this.parseStylesParam(request, featureTypes);
                request.setStyles(styles);
            } else if (this.keyExists("STYLES")) {
                styles = this.parseStylesParam(request, featureTypes);
                request.setStyles(styles);
            }
        }
    }
}

