/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetMapKvpReader;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WmsKvpRequestReader;
import org.vfny.geoserver.wms.servlets.WMService;

public class GetFeatureInfoKvpReader
extends WmsKvpRequestReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests.readers.wms");
    private GetFeatureInfoRequest request;
    private GetMapKvpReader getMapReader;

    public GetFeatureInfoKvpReader(Map kvpPairs, WMService service) {
        super(kvpPairs, service);
        this.getMapReader = new GetMapKvpReader(kvpPairs, service);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        WMService service = (WMService)this.getServiceRef();
        WMS wms = service.getWMS();
        this.request = new GetFeatureInfoRequest(service);
        this.request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        this.request.setVersion(version);
        this.getMapReader.setStylesRequired(false);
        GetMapRequest getMapPart = (GetMapRequest)this.getMapReader.getRequest(httpRequest);
        this.request.setGetMapRequest(getMapPart);
        MapLayerInfo[] layers = this.parseLayers(wms);
        this.request.setQueryLayers(layers);
        String format = this.getValue("INFO_FORMAT");
        if (format == null) {
            format = "text/plain";
        }
        this.request.setInfoFormat(format);
        this.request.setFeatureCount(1);
        try {
            int maxFeatures = Integer.parseInt(this.getValue("FEATURE_COUNT"));
            this.request.setFeatureCount(maxFeatures);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            int x = Integer.parseInt(this.getValue("X"));
            int y = Integer.parseInt(this.getValue("Y"));
            this.request.setXPixel(x);
            this.request.setYPixel(y);
        }
        catch (NumberFormatException ex) {
            throw new WmsException("X and Y incorrectly specified");
        }
        String exceptionsFormat = this.getValue("EXCEPTIONS");
        this.request.setExeptionFormat(exceptionsFormat);
        return this.request;
    }

    private MapLayerInfo[] parseLayers(WMS wms) throws WmsException {
        List layers = KvpRequestReader.readFlat((String)this.getValue("QUERY_LAYERS"), (String)",");
        if (wms.getBaseMapLayers() != null) {
            for (int i = 0; i < layers.size(); ++i) {
                String layerGroup = (String)wms.getBaseMapLayers().get(layers.get(i));
                if (layerGroup == null) continue;
                List layerGroupExpanded = KvpRequestReader.readFlat((String)layerGroup, (String)",");
                layers.remove(i);
                layers.addAll(i, layerGroupExpanded);
            }
        }
        Data catalog = this.request.getWMS().getData();
        int layerCount = layers.size();
        if (layerCount == 0) {
            throw new WmsException("No QUERY_LAYERS has been requested, or no queriable layer in the request anyways", ((Object)((Object)this)).getClass().getName());
        }
        MapLayerInfo[] layerInfos = new MapLayerInfo[layerCount];
        String layerName = null;
        for (int i = 0; i < layerCount; ++i) {
            layerName = (String)layers.get(i);
            layerInfos[i] = catalog.getMapLayerInfo(layerName);
        }
        return layerInfos;
    }
}

