/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.requests;

import java.io.IOException;
import java.io.Reader;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.util.requests.CapabilitiesHandler;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.servlets.WMService;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserAdapter;

public class CapabilitiesXmlReader
extends XmlRequestReader {
    public CapabilitiesXmlReader(WMService service) {
        super((AbstractService)service);
    }

    public Request read(Reader reader, HttpServletRequest req) throws WmsException {
        InputSource requestSource = new InputSource(reader);
        CapabilitiesHandler currentRequest = new CapabilitiesHandler((CapabilitiesRequest)new WMSCapabilitiesRequest(this.getServiceRef()));
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            ParserAdapter adapter = new ParserAdapter(parser.getParser());
            adapter.setContentHandler((ContentHandler)currentRequest);
            adapter.parse(requestSource);
            XmlRequestReader.LOGGER.fine("just parsed: " + requestSource);
        }
        catch (SAXException e) {
            throw new WmsException(e, "XML capabilities request parsing error", ((Object)((Object)this)).getClass().getName());
        }
        catch (IOException e) {
            throw new WmsException(e, "XML capabilities request input error", ((Object)((Object)this)).getClass().getName());
        }
        catch (ParserConfigurationException e) {
            throw new WmsException(e, "Some sort of issue creating parser", ((Object)((Object)this)).getClass().getName());
        }
        CapabilitiesRequest r = currentRequest.getRequest(req);
        return r;
    }
}

