/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.util;

import com.vividsolutions.jts.geom.Envelope;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.util.KvpUtils;
import org.geotools.map.MapLayer;
import org.geotools.styling.Style;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.util.Requests;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WMSRequest;

public class WMSRequests {
    public static String getBaseUrl(HttpServletRequest request, GeoServer geoServer) {
        String baseUrl = Requests.getBaseUrl((HttpServletRequest)request, (GeoServer)geoServer);
        baseUrl = Requests.appendContextPath((String)baseUrl, (String)"wms");
        return baseUrl;
    }

    public static String getBaseUrl(WMSRequest request) {
        return WMSRequests.getBaseUrl(request.getHttpServletRequest(), request.getGeoServer());
    }

    public static String getBaseUrl(WMSMapContext map) {
        return WMSRequests.getBaseUrl(map.getRequest());
    }

    public static String getTiledGetMapUrl(GetMapRequest req, MapLayer layer, Envelope bbox, String[] kvp) {
        String baseUrl = Requests.getTileCacheBaseUrl((HttpServletRequest)req.getHttpServletRequest(), (GeoServer)req.getGeoServer());
        if (baseUrl == null) {
            return WMSRequests.getGetMapUrl(req, layer, bbox, kvp);
        }
        return WMSRequests.getGetMapUrl(baseUrl, req, layer.getTitle(), layer.getStyle().getName(), bbox, kvp);
    }

    public static String getGetMapUrl(GetMapRequest req, MapLayer layer, Envelope bbox, String[] kvp) {
        String baseUrl = WMSRequests.getBaseUrl(req);
        String layerName = layer != null ? layer.getTitle() : null;
        String style = layer != null ? layer.getStyle().getTitle() : null;
        return WMSRequests.getGetMapUrl(baseUrl, req, layerName, style, bbox, kvp);
    }

    public static String getGetMapUrl(GetMapRequest req, String layer, String style, Envelope bbox, String[] kvp) {
        String baseUrl = WMSRequests.getBaseUrl(req);
        return WMSRequests.getGetMapUrl(baseUrl, req, layer, style, bbox, kvp);
    }

    public static String getGetLegendGraphicUrl(WMSRequest req, MapLayer layer, String[] kvp) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", "wms");
        params.put("request", "GetLegendGraphic");
        params.put("version", "1.1.1");
        params.put("format", "image/png");
        params.put("layer", layer.getTitle());
        params.put("style", layer.getStyle().getName());
        params.put("height", "20");
        params.put("width", "20");
        for (int i = 0; kvp != null && i < kvp.length; i += 2) {
            params.put(kvp[i], kvp[i + 1]);
        }
        return WMSRequests.encode(WMSRequests.getBaseUrl(req), params);
    }

    static String getGetMapUrl(String baseUrl, GetMapRequest req, String layer, String style, Envelope bbox, String[] kvp) {
        int i;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("service", "wms");
        params.put("request", "GetMap");
        params.put("version", "1.1.1");
        params.put("format", req.getFormat());
        StringBuffer layers = new StringBuffer();
        StringBuffer styles = new StringBuffer();
        if (layer != null) {
            layers.append(layer);
            if (style != null) {
                styles.append(style);
            } else {
                for (i = 0; i < req.getLayers().length; ++i) {
                    if (!layer.equals(req.getLayers()[i].getName())) continue;
                    styles.append(req.getLayers()[i].getDefaultStyle().getName());
                }
            }
        } else {
            for (i = 0; i < req.getLayers().length; ++i) {
                MapLayerInfo mapLayer = req.getLayers()[i];
                Style s = (Style)req.getStyles().get(0);
                layers.append(mapLayer.getName()).append(",");
                styles.append(s.getName()).append(",");
            }
            layers.setLength(layers.length() - 1);
            styles.setLength(styles.length() - 1);
        }
        params.put("layers", layers.toString());
        params.put("styles", styles.toString());
        if (layer != null) {
            List filters;
            int index;
            for (index = 0; index < req.getLayers().length && !req.getLayers()[index].getName().equals(layer); ++index) {
            }
            if (req.getRawKvp().get("filter") != null) {
                filters = KvpUtils.readFlat((String)((String)req.getRawKvp().get("filter")), (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
                params.put("filter", (String)filters.get(index));
            } else if (req.getRawKvp().get("cql_filter") != null) {
                filters = KvpUtils.readFlat((String)((String)req.getRawKvp().get("cql_filter")), (KvpUtils.Tokenizer)KvpUtils.CQL_DELIMITER);
                params.put("cql_filter", (String)filters.get(index));
            } else if (req.getRawKvp().get("featureid") != null) {
                params.put("featureid", (String)req.getRawKvp().get("featureid"));
            }
        } else if (req.getRawKvp().get("filter") != null) {
            params.put("filter", (String)req.getRawKvp().get("filter"));
        } else if (req.getRawKvp().get("cql_filter") != null) {
            params.put("cql_filter", (String)req.getRawKvp().get("cql_filter"));
        } else if (req.getRawKvp().get("featureid") != null) {
            params.put("featureid", (String)req.getRawKvp().get("featureid"));
        }
        params.put("height", String.valueOf(req.getHeight()));
        params.put("width", String.valueOf(req.getWidth()));
        params.put("transparent", "" + req.isTransparent());
        if (bbox == null) {
            bbox = req.getBbox();
        }
        if (bbox != null) {
            params.put("bbox", WMSRequests.encode(bbox));
        }
        params.put("srs", req.getSRS());
        if (req.getFormatOptions() != null && !req.getFormatOptions().isEmpty()) {
            params.put("format_options", WMSRequests.encodeFormatOptions(req.getFormatOptions()));
        }
        for (i = 0; kvp != null && i < kvp.length; i += 2) {
            params.put(kvp[i], kvp[i + 1]);
        }
        return WMSRequests.encode(baseUrl, params);
    }

    public static String encodeFormatOptions(Map formatOptions) {
        StringBuffer sb = new StringBuffer();
        Iterator e = formatOptions.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            sb.append(key).append(":");
            if (val instanceof Collection) {
                Iterator i = ((Collection)val).iterator();
                while (i.hasNext()) {
                    sb.append(i.next()).append(",");
                }
                sb.setLength(sb.length() - 1);
            } else if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                for (int i = 0; i < len; ++i) {
                    Object o = Array.get(val, i);
                    if (o == null) continue;
                    sb.append(o).append(",");
                }
                sb.setLength(sb.length() - 1);
            } else {
                sb.append(val.toString());
            }
            sb.append(";");
        }
        sb.setLength(sb.length());
        return sb.toString();
    }

    static String encode(Envelope box) {
        return box.getMinX() + "," + box.getMinY() + "," + box.getMaxX() + "," + box.getMaxY();
    }

    static String encode(String baseUrl, Map kvp) {
        StringBuffer query = new StringBuffer();
        Iterator e = kvp.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry entry = e.next();
            query.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        query.setLength(query.length() - 1);
        return Requests.appendQueryString((String)baseUrl, (String)query.toString());
    }
}

