/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geoserver.wms.WebMapService;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.DescribeLayerRequest;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.requests.GetLegendGraphicRequest;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.requests.WMSCapabilitiesRequest;
import org.vfny.geoserver.wms.responses.DescribeLayerResponse;
import org.vfny.geoserver.wms.responses.GetFeatureInfoResponse;
import org.vfny.geoserver.wms.responses.GetLegendGraphicResponse;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.WMSCapabilitiesResponse;
import org.vfny.geoserver.wms.servlets.Capabilities;
import org.vfny.geoserver.wms.servlets.DescribeLayer;
import org.vfny.geoserver.wms.servlets.GetFeatureInfo;
import org.vfny.geoserver.wms.servlets.GetLegendGraphic;
import org.vfny.geoserver.wms.servlets.GetMap;

public class DefaultWebMapService
implements WebMapService,
ApplicationContextAware {
    public static String FORMAT = "image/png";
    public static List STYLES = Collections.EMPTY_LIST;
    public static int HEIGHT = 512;
    public static int WIDTH = 512;
    public static String SRS = "EPSG:4326";
    public static Boolean TRANSPARENT = Boolean.TRUE;
    public static ReferencedEnvelope BBOX = new ReferencedEnvelope(new Envelope(-180.0, 180.0, -90.0, 90.0), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    GetMapRequest getMap = null;
    ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public WMSCapabilitiesResponse getCapabilities(WMSCapabilitiesRequest request) {
        Capabilities capabilities = (Capabilities)((Object)this.context.getBean("wmsGetCapabilities"));
        return (WMSCapabilitiesResponse)capabilities.getResponse();
    }

    public WMSCapabilitiesResponse capabilities(WMSCapabilitiesRequest request) {
        return this.getCapabilities(request);
    }

    public DescribeLayerResponse describeLayer(DescribeLayerRequest request) {
        DescribeLayer describeLayer = (DescribeLayer)((Object)this.context.getBean("wmsDescribeLayer"));
        return (DescribeLayerResponse)describeLayer.getResponse();
    }

    public GetMapResponse getMap(GetMapRequest request) {
        GetMap getMap = (GetMap)((Object)this.context.getBean("wmsGetMap"));
        return (GetMapResponse)getMap.getResponse();
    }

    public GetMapResponse map(GetMapRequest request) {
        return this.getMap(request);
    }

    public GetFeatureInfoResponse getFeatureInfo(GetFeatureInfoRequest request) {
        GetFeatureInfo getFeatureInfo = (GetFeatureInfo)((Object)this.context.getBean("wmsGetFeatureInfo"));
        return (GetFeatureInfoResponse)getFeatureInfo.getResponse();
    }

    public GetLegendGraphicResponse getLegendGraphic(GetLegendGraphicRequest request) {
        GetLegendGraphic getLegendGraphic = (GetLegendGraphic)((Object)this.context.getBean("wmsGetLegendGraphic"));
        return (GetLegendGraphicResponse)getLegendGraphic.getResponse();
    }

    public GetMapResponse reflect(GetMapRequest request) {
        return this.getMapReflect(request);
    }

    public GetMapResponse getMapReflect(GetMapRequest request) {
        this.getMap = request;
        if (this.getMap.getFormat() == null) {
            this.getMap.setFormat(FORMAT);
        }
        if (this.getMap.getStyles() == null || this.getMap.getStyles().isEmpty()) {
            if (this.getMap.getLayers() != null && this.getMap.getLayers().length > 0) {
                ArrayList<Style> styles = new ArrayList<Style>(this.getMap.getLayers().length);
                for (int i = 0; i < this.getMap.getLayers().length; ++i) {
                    styles.add(this.getMap.getLayers()[i].getDefaultStyle());
                }
                this.getMap.setStyles(styles);
            } else {
                this.getMap.setStyles(STYLES);
            }
        }
        this.autoSetBoundsAndSize();
        return this.getMap(this.getMap);
    }

    private void autoSetBoundsAndSize() {
        boolean specifiedBbox;
        MapLayerInfo[] layers = this.getMap.getLayers();
        String reqSRS = this.getMap.getSRS();
        CoordinateReferenceSystem reqCRS = this.getMap.getCrs();
        boolean useNativeBounds = true;
        if (this.getMap.getSRS() == null || reqSRS.equalsIgnoreCase("EPSG:4326")) {
            useNativeBounds = false;
            reqSRS = "EPSG:4326";
            this.getMap.setSRS(reqSRS);
            try {
                reqCRS = CRS.decode((String)reqSRS);
            }
            catch (NoSuchAuthorityCodeException e) {
                e.printStackTrace();
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            this.getMap.setCrs(reqCRS);
        } else {
            for (int i = 0; useNativeBounds && i < layers.length; ++i) {
                useNativeBounds = layers[i].getFeature().getSRS().equalsIgnoreCase(reqSRS);
            }
        }
        Envelope layerbbox = null;
        boolean bl = specifiedBbox = this.getMap.getBbox() != null;
        if (specifiedBbox) {
            layerbbox = this.getMap.getBbox();
        } else {
            for (int i = 0; i < layers.length; ++i) {
                Envelope curbbox = null;
                FeatureTypeInfo curFTI = layers[i].getFeature();
                try {
                    curbbox = curFTI != null ? (useNativeBounds ? curFTI.getLatLongBoundingBox() : curFTI.getBoundingBox()) : layers[i].getRemoteFeatureSource().getBounds();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (i == 0) {
                    layerbbox = new Envelope(curbbox);
                    continue;
                }
                layerbbox.expandToInclude(curbbox);
            }
            if (!useNativeBounds) {
                try {
                    ReferencedEnvelope ref = new ReferencedEnvelope(layerbbox, CRS.decode((String)"EPSG:4326"));
                    layerbbox = ref.transform(reqCRS, true);
                }
                catch (NoSuchAuthorityCodeException e) {
                    e.printStackTrace();
                }
                catch (TransformException e) {
                    e.printStackTrace();
                }
                catch (FactoryException e) {
                    e.printStackTrace();
                }
            }
        }
        if (layerbbox == null) {
            layerbbox = BBOX;
        }
        double bbheight = layerbbox.getHeight();
        double bbwidth = layerbbox.getWidth();
        double bbratio = bbwidth / bbheight;
        if (!specifiedBbox) {
            layerbbox.expandBy(layerbbox.getWidth() / 50.0, layerbbox.getHeight() / 50.0);
        }
        double mheight = this.getMap.getHeight();
        double mwidth = this.getMap.getWidth();
        if (!(mheight > 0.5 && mwidth > 0.5 && specifiedBbox)) {
            if (mheight > 0.5 && mwidth > 0.5) {
                double mratio = mwidth / mheight;
                if (bbratio > mratio) {
                    double diff = (bbwidth / mratio - bbheight) / 2.0;
                    layerbbox.expandBy(0.0, diff);
                } else {
                    double diff = (bbheight * mratio - bbwidth) / 2.0;
                    layerbbox.expandBy(diff, 0.0);
                }
            } else if (mheight > 0.5) {
                mwidth = bbratio * mheight;
            } else {
                if (!(mwidth > 0.5)) {
                    mwidth = WIDTH;
                }
                mheight = mwidth / bbratio;
            }
            this.getMap.setBbox(layerbbox);
            this.getMap.setWidth((int)mwidth);
            this.getMap.setHeight((int)mheight);
        }
    }
}

