/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.wms.WebMapService;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.map.kml.KMLNetworkLinkTransformer;

public class KMLReflector {
    public static final String KML_MIME_TYPE = "application/vnd.google-earth.kml+xml";
    public static final String KMZ_MIME_TYPE = "application/vnd.google-earth.kmz+xml";
    public static final Integer KMSCORE = new Integer(50);
    public static final Boolean KMATTR = Boolean.TRUE;
    public static final String FORMAT = "application/vnd.google-earth.kml+xml";
    WebMapService wms;

    public KMLReflector(WebMapService wms) {
        this.wms = wms;
    }

    public void wms(GetMapRequest request, HttpServletResponse response) throws Exception {
        if (request.getWidth() < 1) {
            request.setWidth(1024);
        }
        if (request.getHeight() < 1) {
            request.setHeight(1024);
        }
        this.wms.reflect(request);
        Map fo = request.getFormatOptions();
        if (fo.get("kmattr") == null) {
            fo.put("kmattr", KMATTR);
        }
        if (fo.get("kmscore") == null) {
            fo.put("kmscore", KMSCORE);
        }
        if (request.getSuperOverlay()) {
            request.setFormat("application/vnd.google-earth.kml+xml");
        } else {
            request.setFormat(KMZ_MIME_TYPE);
        }
        response.setContentType("application/vnd.google-earth.kml+xml");
        StringBuffer filename = new StringBuffer();
        for (int i = 0; i < request.getLayers().length; ++i) {
            String name = request.getLayers()[i].getName();
            int j = name.indexOf(58);
            if (j > -1) {
                name = name.substring(j + 1);
            }
            filename.append(name + "_");
        }
        filename.setLength(filename.length() - 1);
        response.setHeader("Content-Disposition", "attachment; filename=" + filename.toString() + ".kml");
        KMLNetworkLinkTransformer transformer = new KMLNetworkLinkTransformer();
        transformer.setIndentation(3);
        transformer.setEncodeAsRegion(request.getSuperOverlay());
        transformer.transform((Object)request, (OutputStream)response.getOutputStream());
    }
}

