/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.kml;

import com.vividsolutions.jts.geom.Envelope;
import org.geoserver.wms.util.WMSRequests;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.MapLayerInfo;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.xml.sax.ContentHandler;

public class KMLNetworkLinkTransformer
extends TransformerBase {
    boolean encodeAsRegion = false;

    public Translator createTranslator(ContentHandler handler) {
        return new KMLNetworkLinkTranslator(handler);
    }

    public void setEncodeAsRegion(boolean encodeAsRegion) {
        this.encodeAsRegion = encodeAsRegion;
    }

    class KMLNetworkLinkTranslator
    extends TransformerBase.TranslatorSupport {
        public KMLNetworkLinkTranslator(ContentHandler contentHandler) {
            super(contentHandler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            GetMapRequest request = (GetMapRequest)((Object)o);
            this.start("kml");
            this.start("Folder");
            if (KMLNetworkLinkTransformer.this.encodeAsRegion) {
                this.encodeAsSuperOverlay(request);
            } else {
                this.encodeAsOverlay(request);
            }
            this.end("Folder");
            this.end("kml");
        }

        protected void encodeAsSuperOverlay(GetMapRequest request) {
            MapLayerInfo[] layers = request.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                this.start("NetworkLink");
                this.element("name", layers[i].getName());
                this.element("open", "1");
                this.element("visibility", "1");
                this.start("Region");
                Envelope bbox = request.getBbox();
                this.start("LatLonAltBox");
                this.element("north", "" + bbox.getMaxY());
                this.element("south", "" + bbox.getMinY());
                this.element("east", "" + bbox.getMaxX());
                this.element("west", "" + bbox.getMinX());
                this.end("LatLonAltBox");
                this.start("Lod");
                this.element("minLodPixels", "256");
                this.element("maxLodPixels", "-1");
                this.end("Lod");
                this.end("Region");
                this.start("Link");
                String href = WMSRequests.getGetMapUrl(request, layers[i].getName(), null, null, null);
                this.start("href");
                this.cdata(href);
                this.end("href");
                this.element("viewRefreshMode", "onRegion");
                this.end("Link");
                this.end("NetworkLink");
            }
        }

        protected void encodeAsOverlay(GetMapRequest request) {
            MapLayerInfo[] layers = request.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                this.start("NetworkLink");
                this.element("name", layers[i].getName());
                this.element("open", "1");
                this.element("visibility", "1");
                this.start("Url");
                request.setBbox(null);
                String href = WMSRequests.getGetMapUrl(request, layers[i].getName(), null, null, null);
                this.start("href");
                this.cdata(href);
                this.end("href");
                this.element("viewRefreshMode", "onStop");
                this.element("viewRefreshTime", "1");
                this.end("Url");
                this.end("NetworkLink");
            }
        }
    }
}

