/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.featureInfo;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.opengis.wfs.FeatureCollectionType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFS;
import org.geoserver.wfs.xml.GML2OutputFormat;
import org.geotools.feature.FeatureCollection;
import org.geotools.gml2.bindings.GML2EncodingUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.requests.GetFeatureInfoRequest;
import org.vfny.geoserver.wms.responses.featureInfo.AbstractFeatureInfoResponse;

public class GmlFeatureInfoResponse
extends AbstractFeatureInfoResponse {
    private static final String FORMAT = "application/vnd.ogc.gml";

    public GmlFeatureInfoResponse() {
        this.supportedFormats = Collections.singletonList(FORMAT);
    }

    public HashMap getResponseHeaders() {
        return new HashMap();
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        GetFeatureInfoRequest fInfoReq = this.getRequest();
        WMS wms = (WMS)fInfoReq.getServiceRef().getServiceRef();
        WFS wfs = wms.getWFS();
        GeoServer gs = wms.getGeoServer();
        Data catalog = fInfoReq.getServiceRef().getCatalog();
        FeatureCollectionType features = WfsFactory.eINSTANCE.createFeatureCollectionType();
        GetFeatureType gfreq = WfsFactory.eINSTANCE.createGetFeatureType();
        gfreq.setBaseUrl(fInfoReq.getBaseUrl());
        Iterator i = this.results.iterator();
        while (i.hasNext()) {
            FeatureCollection fc = (FeatureCollection)i.next();
            features.getFeature().add(fc);
            QueryType qt = WfsFactory.eINSTANCE.createQueryType();
            String crs = GML2EncodingUtils.epsgCode((CoordinateReferenceSystem)fc.getSchema().getDefaultGeometry().getCoordinateSystem());
            if (crs != null) {
                String srsName = "EPSG:" + crs;
                try {
                    qt.setSrsName(new URI(srsName));
                }
                catch (URISyntaxException e) {
                    throw new ServiceException("Unable to determite coordinate system for featureType " + fc.getSchema().getTypeName() + ".  Schema told us '" + srsName + "'", (Throwable)e);
                }
            }
            gfreq.getQuery().add(qt);
        }
        Service serviceDesc = new Service("wms", null, null);
        Operation opDescriptor = new Operation("", serviceDesc, null, new Object[]{gfreq});
        GML2OutputFormat format = new GML2OutputFormat(wfs, gs, catalog);
        format.write((Object)features, out, opDescriptor);
    }

    public String getContentDisposition() {
        return null;
    }
}

