/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.helpers.WMSCapsTransformer;

public class WMSCapabilitiesResponse
implements Response {
    private static final Logger LOGGER = Logger.getLogger((class$org$vfny$geoserver$wms$responses$WMSCapabilitiesResponse == null ? (class$org$vfny$geoserver$wms$responses$WMSCapabilitiesResponse = WMSCapabilitiesResponse.class$("org.vfny.geoserver.wms.responses.WMSCapabilitiesResponse")) : class$org$vfny$geoserver$wms$responses$WMSCapabilitiesResponse).getPackage().getName());
    private byte[] rawResponse;
    private Set formats;
    private ApplicationContext applicationContext;
    static /* synthetic */ Class class$org$vfny$geoserver$wms$responses$WMSCapabilitiesResponse;

    public WMSCapabilitiesResponse(Set wmsGetMapFormats, ApplicationContext applicationContext) {
        this.formats = wmsGetMapFormats;
        this.applicationContext = applicationContext;
    }

    public HashMap getResponseHeaders() {
        return null;
    }

    public void execute(Request request) throws ServiceException {
        if (!(request instanceof CapabilitiesRequest)) {
            throw new IllegalArgumentException("Not a GetCapabilities Request");
        }
        WMSCapsTransformer transformer = new WMSCapsTransformer(request.getBaseUrl(), this.formats, this.applicationContext);
        transformer.setIndentation(2);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            transformer.transform(request, out);
        }
        catch (TransformerException e) {
            throw new WmsException(e);
        }
        this.rawResponse = out.toByteArray();
    }

    public String getContentType(GeoServer gs) throws IllegalStateException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("execute() not called or not succeed.");
        }
        return "application/vnd.ogc.wms_xml";
    }

    public String getContentEncoding() {
        return null;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        if (this.rawResponse == null) {
            throw new IllegalStateException("No raw response presents!");
        }
        out.write(this.rawResponse);
    }

    public void abort(Service gs) {
    }

    public String getContentDisposition() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

