/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.LookupDescriptor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.map.MapContext;
import org.geotools.map.MapLayer;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.wms.RasterMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.AbstractRasterMapProducer;
import org.vfny.geoserver.wms.responses.PaletteExtractor;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileMapProducer;
import org.vfny.geoserver.wms.responses.palette.CustomPaletteBuilder;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public abstract class DefaultRasterMapProducer
extends AbstractRasterMapProducer
implements RasterMapProducer {
    private static final Interpolation NN_INTERPOLATION = new InterpolationNearest();
    private static final Interpolation BIL_INTERPOLATION = new InterpolationBilinear();
    private static final Interpolation BIC_INTERPOLATION = new InterpolationBicubic2(0);
    private static final String AA_NONE = "NONE";
    private static final String AA_TEXT = "TEXT";
    private static final String AA_FULL = "FULL";
    private static final List AA_SETTINGS = Arrays.asList("NONE", "TEXT", "FULL");
    private static LookupTableJAI IDENTITY_TABLE = new LookupTableJAI(DefaultRasterMapProducer.getTable());
    private WMS wms;
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.responses.wms.map");
    private static final String DEFAULT_MAP_FORMAT = "image/png";

    private static byte[] getTable() {
        byte[] arr = new byte[256];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (byte)i;
        }
        return arr;
    }

    public DefaultRasterMapProducer() {
        this(DEFAULT_MAP_FORMAT, (WMS)null);
    }

    public DefaultRasterMapProducer(WMS wms) {
        this(DEFAULT_MAP_FORMAT, wms);
    }

    public DefaultRasterMapProducer(String outputFormat, WMS wms) {
        this(outputFormat, outputFormat, wms);
    }

    public DefaultRasterMapProducer(String outputFormat, String mime, WMS wms) {
        super(outputFormat, mime);
        this.wms = wms;
    }

    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.formatImageOutputStream(this.image, out);
    }

    /*
     * WARNING - void declaration
     */
    public void produceMap() throws WmsException {
        void var9_11;
        Graphics2D graphic;
        GetMapRequest request;
        String antialias;
        int width = this.mapContext.getMapWidth();
        int height = this.mapContext.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        if ((antialias = (String)(request = this.mapContext.getRequest()).getFormatOptions().get("antialias")) != null) {
            antialias = antialias.toUpperCase();
        }
        IndexColorModel palette = null;
        InverseColorMapOp paletteInverter = this.mapContext.getPaletteInverter();
        if (paletteInverter != null && AA_NONE.equals(antialias)) {
            palette = paletteInverter.getIcm();
        } else if (AA_NONE.equals(antialias)) {
            PaletteExtractor pe = new PaletteExtractor(this.mapContext.isTransparent() ? null : this.mapContext.getBgColor());
            MapLayer[] layers = this.mapContext.getLayers();
            for (int i = 0; i < layers.length; ++i) {
                pe.visit(layers[i].getStyle());
                if (!pe.canComputePalette()) break;
            }
            if (pe.canComputePalette()) {
                palette = pe.getPalette();
            }
        }
        boolean useAlpha = this.mapContext.isTransparent() || MetatileMapProducer.isRequestTiled(request, this);
        RenderedImage preparedImage = this.prepareImage(width, height, palette, useAlpha);
        if (preparedImage instanceof BufferedImage) {
            graphic = ((BufferedImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof TiledImage) {
            graphic = ((TiledImage)preparedImage).createGraphics();
        } else if (preparedImage instanceof VolatileImage) {
            graphic = ((VolatileImage)((Object)preparedImage)).createGraphics();
        } else {
            throw new WmsException("Unrecognized back-end image type");
        }
        HashMap<RenderingHints.Key, Object> hintsMap = new HashMap<RenderingHints.Key, Object>();
        hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        var9_11.setRenderingHints(hintsMap);
        if (!this.mapContext.isTransparent()) {
            var9_11.setColor(this.mapContext.getBgColor());
            var9_11.fillRect(0, 0, width, height);
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("setting to transparent");
            }
            int type = 2;
            var9_11.setComposite(AlphaComposite.getInstance(type));
            Color c = new Color(this.mapContext.getBgColor().getRed(), this.mapContext.getBgColor().getGreen(), this.mapContext.getBgColor().getBlue(), 0);
            var9_11.setBackground(this.mapContext.getBgColor());
            var9_11.setColor(c);
            var9_11.fillRect(0, 0, width, height);
            type = 3;
            var9_11.setComposite(AlphaComposite.getInstance(type));
        }
        if (AA_NONE.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            if (preparedImage.getColorModel() instanceof IndexColorModel) {
                hintsMap.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            }
        } else if (AA_TEXT.equals(antialias)) {
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            if (antialias != null && !AA_FULL.equals(antialias)) {
                LOGGER.warning("Unrecognized antialias setting '" + antialias + "', valid values are " + AA_SETTINGS);
            }
            hintsMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.wms != null && "Nearest".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, NN_INTERPOLATION);
        } else if (this.wms != null && "Bilinear".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIL_INTERPOLATION);
        } else if (this.wms != null && "Bicubic".equals(this.wms.getAllowInterpolation())) {
            hintsMap.put(JAI.KEY_INTERPOLATION, BIC_INTERPOLATION);
        }
        var9_11.setRenderingHints(hintsMap);
        Rectangle paintArea = new Rectangle(width, height);
        RenderingHints hints = new RenderingHints(hintsMap);
        this.renderer = new ShapefileRenderer();
        this.renderer.setContext((MapContext)this.mapContext);
        this.renderer.setJava2DHints(hints);
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", new Boolean(true));
        rendererParams.put("renderingBuffer", new Integer(this.mapContext.getBuffer()));
        rendererParams.put("scaleComputationMethod", "OGC");
        this.renderer.setRendererHints(rendererParams);
        if (this.abortRequested) {
            var9_11.dispose();
            return;
        }
        ReferencedEnvelope dataArea = this.mapContext.getAreaOfInterest();
        this.renderer.paint((Graphics2D)var9_11, paintArea, dataArea);
        var9_11.dispose();
        if (!this.abortRequested) {
            this.image = palette != null && palette.getMapSize() < 256 ? this.optimizeSampleModel(preparedImage) : preparedImage;
        }
    }

    protected RenderedImage prepareImage(int width, int height, IndexColorModel palette, boolean transparent) {
        if (palette != null) {
            WritableRaster raster = Raster.createInterleavedRaster(palette.getTransferType(), width, height, 1, null);
            return new BufferedImage(palette, raster, false, null);
        }
        if (transparent) {
            return new BufferedImage(width, height, 6);
        }
        return new BufferedImage(width, height, 5);
    }

    protected RenderedImage forceIndexed8Bitmask(RenderedImage originalImage) {
        RenderedImage image;
        boolean dataTypeByte;
        ColorModel cm = originalImage.getColorModel();
        boolean bl = dataTypeByte = originalImage.getSampleModel().getDataType() == 0;
        if (cm instanceof IndexColorModel && dataTypeByte) {
            IndexColorModel icm = (IndexColorModel)cm;
            image = icm.getTransparency() != 3 ? originalImage : new ImageWorker(originalImage).forceBitmaskIndexColorModel().getRenderedImage();
        } else {
            InverseColorMapOp invColorMap = this.getMapContext().getPaletteInverter();
            if (invColorMap != null) {
                image = invColorMap.filterRenderedImage(originalImage);
            } else {
                image = new ImageWorker(originalImage).forceComponentColorModel().getRenderedImage();
                int subsx = (int)Math.pow(2.0, image.getWidth() / 256);
                int subsy = (int)Math.pow(2.0, image.getHeight() / 256);
                image = new CustomPaletteBuilder(image, 256, subsx, subsy, 1).buildPalette().getIndexedImage();
            }
        }
        return image;
    }

    private RenderedImage optimizeSampleModel(RenderedImage source) {
        int w = source.getWidth();
        int h = source.getHeight();
        ImageLayout layout = new ImageLayout();
        layout.setColorModel(source.getColorModel());
        layout.setSampleModel(source.getColorModel().createCompatibleSampleModel(w, h));
        layout.setTileWidth(w);
        layout.setTileHeight(h);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        return LookupDescriptor.create((RenderedImage)source, (LookupTableJAI)IDENTITY_TABLE, (RenderingHints)hints);
    }

    public abstract /* synthetic */ void formatImageOutputStream(RenderedImage var1, OutputStream var2) throws WmsException, IOException;
}

