/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.sld.requests;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.ServiceException;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.servlets.AbstractService;
import org.vfny.geoserver.sld.SldException;
import org.vfny.geoserver.sld.requests.PutStylesRequest;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;

public class PutStylesKvpReader
extends KvpRequestReader {
    public PutStylesKvpReader(Map kvpPairs, AbstractService service) {
        super(kvpPairs, service);
    }

    public Request getRequest(HttpServletRequest httpRequest) throws ServiceException {
        PutStylesRequest request = new PutStylesRequest(this.getServiceRef());
        request.setHttpServletRequest(httpRequest);
        String version = this.getRequestVersion();
        request.setVersion(version);
        this.parseMandatoryParameters(request);
        this.parseOptionalParameters(request);
        return request;
    }

    public void parseMandatoryParameters(PutStylesRequest request) throws SldException {
        String req = this.getValue("REQUEST");
        if (req != null && !req.equals("") && !req.equalsIgnoreCase("PutStyles")) {
            throw new SldException("Expecting 'request=PutStyles'");
        }
        String mode = this.getValue("MODE");
        if (mode != null && !mode.equals("")) {
            if (mode.equalsIgnoreCase("InsertAndReplace") || mode.equalsIgnoreCase("ReplaceAll")) {
                request.setMode(mode);
            } else {
                throw new SldException("Parameter must be 'InsertAndReplace' or 'ReplaceAll'.");
            }
        }
    }

    public void parseOptionalParameters(PutStylesRequest request) {
        String sld_body;
        String sld = this.getValue("SLD");
        if (sld != null && !sld.equals("")) {
            request.setSLD(sld);
        }
        if ((sld_body = this.getValue("SLD_BODY")) != null && !sld_body.equals("")) {
            request.setSldBody(sld_body);
        }
    }

    protected String getRequestVersion() {
        String version = this.getValue("VERSION");
        if (version == null) {
            version = this.getValue("WMTVER");
        }
        if (version == null) {
            version = WMS.getVersion();
        }
        return version;
    }
}

